/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.ui.internal.views;

import java.util.HashMap;
import java.util.List;
import org.eclipse.codewind.core.internal.CodewindApplication;
import org.eclipse.codewind.core.internal.IUpdateHandler;
import org.eclipse.codewind.core.internal.connection.CodewindConnection;
import org.eclipse.codewind.ui.internal.views.ViewHelper;

public class UpdateHandler
implements IUpdateHandler {
    private HashMap<String, AppUpdateListener> appListeners = new HashMap();

    public void updateAll() {
        ViewHelper.refreshCodewindExplorerView(null);
    }

    public void updateConnection(CodewindConnection connection) {
        ViewHelper.refreshCodewindExplorerView(connection);
        ViewHelper.expandConnection(connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateApplication(CodewindApplication app) {
        ViewHelper.refreshCodewindExplorerView(app);
        ViewHelper.expandConnection(app.connection);
        HashMap<String, AppUpdateListener> hashMap = this.appListeners;
        synchronized (hashMap) {
            AppUpdateListener listener = this.appListeners.get(app.projectID);
            if (listener != null) {
                listener.update(app);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnection(List<CodewindApplication> apps) {
        ViewHelper.refreshCodewindExplorerView(null);
        HashMap<String, AppUpdateListener> hashMap = this.appListeners;
        synchronized (hashMap) {
            for (CodewindApplication app : apps) {
                AppUpdateListener listener = this.appListeners.get(app.projectID);
                if (listener == null) continue;
                listener.remove(app);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeApplication(CodewindApplication app) {
        ViewHelper.refreshCodewindExplorerView(app.connection);
        ViewHelper.expandConnection(app.connection);
        HashMap<String, AppUpdateListener> hashMap = this.appListeners;
        synchronized (hashMap) {
            AppUpdateListener listener = this.appListeners.get(app.projectID);
            if (listener != null) {
                listener.remove(app);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAppUpdateListener(String projectID, AppUpdateListener listener) {
        HashMap<String, AppUpdateListener> hashMap = this.appListeners;
        synchronized (hashMap) {
            this.appListeners.put(projectID, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAppUpdateListener(String projectID) {
        HashMap<String, AppUpdateListener> hashMap = this.appListeners;
        synchronized (hashMap) {
            this.appListeners.remove(projectID);
        }
    }

    public static interface AppUpdateListener {
        public void update(CodewindApplication var1);

        public void remove(CodewindApplication var1);
    }
}

