/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.ui.internal.wizards;

import org.eclipse.codewind.core.internal.PlatformUtil;
import org.eclipse.codewind.core.internal.connection.CodewindConnection;
import org.eclipse.codewind.ui.internal.messages.Messages;
import org.eclipse.codewind.ui.internal.wizards.BindProjectWizard;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.SearchPattern;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class ProjectSelectionPage
extends WizardPage {
    private final BindProjectWizard wizard;
    private SearchPattern pattern = new SearchPattern(35);
    private final CodewindConnection connection;
    private IProject project = null;

    protected ProjectSelectionPage(BindProjectWizard wizard, CodewindConnection connection) {
        super(Messages.SelectProjectPageName);
        this.setTitle(Messages.SelectProjectPageTitle);
        this.setDescription(Messages.SelectProjectPageDescription);
        this.pattern.setPattern("*");
        this.wizard = wizard;
        this.connection = connection;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.horizontalSpacing = 5;
        layout.verticalSpacing = 7;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        Text projectLabel = new Text(composite, 8);
        projectLabel.setText(Messages.SelectProjectPageChooseProjectLabel);
        projectLabel.setLayoutData((Object)new GridData(1, 2, false, false));
        projectLabel.setBackground(composite.getBackground());
        projectLabel.setForeground(composite.getForeground());
        final Text filterText = new Text(composite, 2048);
        filterText.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        filterText.setMessage(Messages.SelectProjectPageFilterText);
        final CheckboxTableViewer projectList = CheckboxTableViewer.newCheckList((Composite)composite, (int)2816);
        projectList.setContentProvider((IContentProvider)new WorkbenchContentProvider());
        projectList.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        projectList.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        projectList.getTable().setLayoutData((Object)new GridData(4, 4, true, true));
        projectList.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElem, Object elem) {
                if (!(elem instanceof IProject)) {
                    return false;
                }
                IProject project = (IProject)elem;
                if (!project.isAccessible()) {
                    return false;
                }
                if (!ProjectSelectionPage.this.pattern.matches(project.getName())) {
                    return false;
                }
                if (ProjectSelectionPage.this.connection.getAppByName(project.getName()) != null) {
                    return false;
                }
                IPath workspacePath = ProjectSelectionPage.this.connection.getWorkspacePath();
                IPath projectPath = project.getLocation();
                if (PlatformUtil.getOS() == PlatformUtil.OperatingSystem.WINDOWS) {
                    workspacePath = new Path(workspacePath.toPortableString().toLowerCase());
                    projectPath = new Path(projectPath.toPortableString().toLowerCase());
                }
                return workspacePath.isPrefixOf(projectPath);
            }
        });
        filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                String filter = filterText.getText();
                if (filter == null || filter.isEmpty()) {
                    filterText.setMessage(Messages.SelectProjectPageFilterText);
                    ProjectSelectionPage.this.pattern.setPattern("*");
                } else {
                    ProjectSelectionPage.this.pattern.setPattern("*" + filter + "*");
                }
                projectList.refresh();
            }
        });
        projectList.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (event.getChecked()) {
                    projectList.setCheckedElements(new Object[]{event.getElement()});
                    ProjectSelectionPage.this.project = (IProject)event.getElement();
                } else {
                    ProjectSelectionPage.this.project = null;
                }
                ProjectSelectionPage.this.getWizard().getContainer().updateButtons();
            }
        });
        if (projectList.getTable().getItemCount() == 1) {
            Object element = projectList.getElementAt(0);
            projectList.setChecked(element, true);
            this.project = (IProject)element;
        }
        filterText.setFocus();
        this.setControl((Control)composite);
    }

    public boolean canFlipToNextPage() {
        return this.canFinish();
    }

    public IWizardPage getNextPage() {
        this.wizard.setProject(this.project);
        return super.getNextPage();
    }

    public boolean canFinish() {
        return this.project != null;
    }

    public IProject getProject() {
        return this.project;
    }
}

