/*******************************************************************************
* Copyright (c) 2019 IBM Corporation and others.
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v2.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v20.html
*
* Contributors:
*     IBM Corporation - initial API and implementation
*******************************************************************************/
import { ProjectToWatch } from "./ProjectToWatch";
import { WatchEventEntry } from "./WatchEventEntry";
import { ProjectToWatchFromWebSocket } from "./ProjectToWatchFromWebSocket";
import { IWatchService } from "./IWatchService";
export declare class FileWatcher {
    private readonly _projectsMap;
    private readonly _baseUrl;
    private readonly _wsBaseUrl;
    private readonly _getStatusThread;
    private readonly _watchService;
    private readonly _outputQueue;
    private readonly _webSocketManager;
    private readonly _clientUuid;
    private _disposed;
    constructor(urlParam: string, watchService: IWatchService, clientUuid: string);
    updateFileWatchStateFromGetRequest(projectsToWatch: ProjectToWatch[]): void;
    receiveNewWatchEventEntry(watchEntry: WatchEventEntry, receivedAtInEpochMsecs: number): void;
    sendBulkFileChanges(projectId: string, mostRecentEntryTimestamp: number, base64Compressed: string[]): void;
    updateFileWatchStateFromWebSocket(ptwList: ProjectToWatchFromWebSocket[]): void;
    refreshWatchStatus(): void;
    sendWatchResponseAsync(successParam: boolean, ptw: ProjectToWatch): Promise<void>;
    dispose(): void;
    private removeSingleProjectToWatch;
    private createOrUpdateProjectToWatch;
}
