/*******************************************************************************
* Copyright (c) 2019 IBM Corporation and others.
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v2.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v20.html
*
* Contributors:
*     IBM Corporation - initial API and implementation
*******************************************************************************/
import { OutputQueueEntry } from "./OutputQueueEntry";
export declare class HttpPostOutputQueueNew {
    private static readonly MAX_ACTIVE_REQUESTS;
    private readonly _queue;
    private readonly _serverBaseUrl;
    private _activeRequests;
    private _disposed;
    private readonly _failureDelay;
    constructor(serverBaseUrl: string);
    addToQueue(projectId: string, timestamp: number, base64Compressed: string[]): void;
    dispose(): void;
    addToQueueFromRetry(entryToRetry: OutputQueueEntry): void;
    private doHttpPost;
    private resortQueue;
    private queueIfNeededAsync;
    private pollAndSend;
}
