"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const PathFilter_1 = require("./PathFilter");
const pathutils = require("./PathUtils");
class VSCWatchedPath {
    constructor(pathRoot, ptw, parent) {
        this._pathInNormalizedForm = pathutils.normalizePath(pathRoot);
        this._pathFilter = new PathFilter_1.PathFilter(ptw);
        this._parent = parent;
    }
    receiveFileChanges(entries) {
        const newEvents = [];
        for (const wee of entries) {
            const relativePath = pathutils.convertAbsolutePathWithUnixSeparatorsToProjectRelativePath(wee.absolutePathWithUnixSeparators, this._pathInNormalizedForm);
            if (!relativePath || (!this._pathFilter.isFilteredOutByFilename(relativePath)
                && !this._pathFilter.isFilteredOutByPath(relativePath))) {
                newEvents.push(wee);
            }
        }
        if (newEvents.length > 0) {
            for (const event of newEvents) {
                this._parent.internal_handleEvent(event);
            }
        }
    }
    dispose() {
        /* Nothing to dispose */
    }
}
exports.VSCWatchedPath = VSCWatchedPath;
