/*******************************************************************************
* Copyright (c) 2019 IBM Corporation and others.
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v2.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v20.html
*
* Contributors:
*     IBM Corporation - initial API and implementation
*******************************************************************************/
import { WatchService } from "./WatchService";
import { ProjectToWatch } from "./ProjectToWatch";
export declare class WatchedPath {
    private readonly _pathRoot;
    private readonly _normalizedPath;
    private _watcher;
    private readonly _parent;
    private _watchIsReady;
    private _projectToWatch;
    private _pathFilter;
    private _disposed;
    constructor(pathRoot: string, parent: WatchService, projectToWatch: ProjectToWatch);
    waitForPathToExist(attempts: number, startTime: Date): void;
    init(): void;
    dispose(): void;
    private closeWatcherAsync;
    private handleFileChange;
    private handleDirChange;
    /**
     * Recursively scan a directory and create a list of any files/folders found inside. My thinking
     * in creating this was it would reduce incidents of events being missed by Chokidar, but the code
     * had no obvious effect.
     * @param path Path to scan
     */
    private scanCreatedDirectory;
    private scanCreatedDirectoryInner;
}
