/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.ui.internal.actions;

import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.core.internal.connection.CodewindConnection;
import org.eclipse.codewind.ui.CodewindUIPlugin;
import org.eclipse.codewind.ui.internal.messages.Messages;
import org.eclipse.codewind.ui.internal.views.ViewHelper;
import org.eclipse.codewind.ui.internal.wizards.BindProjectWizard;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.actions.SelectionProviderAction;

public class BindAction
extends SelectionProviderAction {
    protected CodewindConnection connection;

    public BindAction(ISelectionProvider selectionProvider) {
        super(selectionProvider, Messages.BindActionLabel);
        this.setImageDescriptor(CodewindUIPlugin.getDefaultIcon());
        this.selectionChanged(this.getStructuredSelection());
    }

    public void selectionChanged(IStructuredSelection sel) {
        Object obj;
        if (sel.size() == 1 && (obj = sel.getFirstElement()) instanceof CodewindConnection) {
            this.connection = (CodewindConnection)obj;
            this.setEnabled(this.connection.isConnected());
            return;
        }
        this.setEnabled(false);
    }

    public void run() {
        if (this.connection == null) {
            Logger.logError((String)"BindAction ran but no Codewind connection was selected");
            return;
        }
        try {
            BindProjectWizard wizard = new BindProjectWizard(this.connection);
            WizardDialog dialog = new WizardDialog(Display.getDefault().getActiveShell(), (IWizard)wizard);
            if (dialog.open() == 1) {
                return;
            }
            ViewHelper.openCodewindExplorerView();
            ViewHelper.refreshCodewindExplorerView(null);
            ViewHelper.expandConnection(this.connection);
        }
        catch (Exception e) {
            Logger.logError((String)("An error occurred running the bind action on connection: " + this.connection.baseUrl), (Throwable)e);
        }
    }
}

