/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.ui.internal.actions;

import java.util.HashMap;
import org.eclipse.codewind.core.internal.CodewindApplication;
import org.eclipse.codewind.core.internal.CoreUtil;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.tm.terminal.view.ui.interfaces.ILauncherDelegate;
import org.eclipse.tm.terminal.view.ui.launcher.LauncherDelegateManager;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class ContainerShellAction
implements IObjectActionDelegate {
    private static final String LAUNCHER_DELEGATE_ID = "org.eclipse.tm.terminal.connector.local.launcher.local";
    protected CodewindApplication app;
    protected ILauncherDelegate delegate = LauncherDelegateManager.getInstance().getLauncherDelegate("org.eclipse.tm.terminal.connector.local.launcher.local", false);

    public ContainerShellAction() {
        if (this.delegate == null) {
            Logger.logError((String)"Could not get the local terminal launcher delegate.");
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        Object obj;
        if (this.delegate == null || !(selection instanceof IStructuredSelection)) {
            action.setEnabled(false);
            return;
        }
        IStructuredSelection sel = (IStructuredSelection)selection;
        if (sel.size() == 1 && (obj = sel.getFirstElement()) instanceof CodewindApplication) {
            this.app = (CodewindApplication)obj;
            action.setEnabled(this.app.isAvailable() && this.app.getContainerId() != null);
            return;
        }
        action.setEnabled(false);
    }

    public void run(IAction action) {
        if (this.app == null) {
            Logger.logError((String)"ContainerShellAction ran but no application was selected");
            return;
        }
        if (this.app.getContainerId() == null) {
            Logger.logError((String)("ContainerShellAction ran but the container id for the application is not set: " + this.app.name));
            return;
        }
        if (this.delegate == null) {
            Logger.logError((String)"ContainerShellAction ran but the local terminal laucher delegate is null");
            return;
        }
        String command = "sh -c \"if type bash > /dev/null; then bash; else sh; fi\"";
        String envPath = CoreUtil.getEnvPath();
        String dockerPath = envPath != null ? envPath + "docker" : "docker";
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("delegateId", this.delegate.getId());
        properties.put("title", this.app.name);
        properties.put("process.path", dockerPath);
        properties.put("process.args", "exec -it " + this.app.getContainerId() + " " + command);
        this.delegate.execute(properties, null);
    }

    public void setActivePart(IAction arg0, IWorkbenchPart arg1) {
    }
}

