/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.filewatchers.core.internal;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import org.eclipse.codewind.filewatchers.core.FWLogger;
import org.eclipse.codewind.filewatchers.core.Filewatcher;
import org.eclipse.codewind.filewatchers.core.WatchEventEntry;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class FileChangeEventBatchUtil {
    private final List<ChangedFileEntry> files_synch_lock = new ArrayList<ChangedFileEntry>();
    private Timer timer_synch_lock = null;
    public boolean disposed_synch_lock = false;
    private final Object lock = new Object();
    private final Filewatcher parent;
    private final String projectId;
    private static final int TIME_TO_WAIT_FOR_NO_NEW_EVENTS_IN_MSECS = 1000;
    private static final int MAX_REQUEST_SIZE_IN_PATHS = 625;
    private static final FWLogger log = FWLogger.getInstance();
    private static final boolean DEBUG_PRINT_COMPRESSION_RATIO = false;

    public FileChangeEventBatchUtil(Filewatcher parent, String projectId) {
        this.parent = parent;
        this.projectId = projectId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChangedFiles(List<ChangedFileEntry> changedFileEntries) {
        Object object = this.lock;
        synchronized (object) {
            if (this.disposed_synch_lock) {
                return;
            }
            this.files_synch_lock.addAll(changedFileEntries);
            Date scheduledTime = new Date(System.currentTimeMillis() + 1000L);
            if (this.timer_synch_lock == null) {
                this.timer_synch_lock = new Timer();
            } else {
                this.timer_synch_lock.cancel();
                this.timer_synch_lock = new Timer();
            }
            this.timer_synch_lock.schedule((TimerTask)new EventProcessingTimerTask(), scheduledTime);
        }
    }

    static final void removeDuplicateEventsOfType(List<ChangedFileEntry> changedFileList, WatchEventEntry.EventType eventType) {
        if (eventType == WatchEventEntry.EventType.MODIFY) {
            throw new IllegalArgumentException("Unsupported event type: " + (Object)((Object)eventType));
        }
        HashMap<String, Boolean> containsPath = new HashMap<String, Boolean>();
        Iterator<ChangedFileEntry> it = changedFileList.iterator();
        while (it.hasNext()) {
            ChangedFileEntry cfe = it.next();
            String path = cfe.getPath();
            if (cfe.getType() == eventType) {
                if (containsPath.containsKey(path)) {
                    if (log.isDebug()) {
                        log.logDebug("Removing duplicate event: " + cfe.toString());
                    }
                    it.remove();
                    continue;
                }
                containsPath.put(path, true);
                continue;
            }
            containsPath.remove(path);
        }
    }

    private static final byte[] compressString(String str) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DeflaterOutputStream dos = new DeflaterOutputStream((OutputStream)baos, new Deflater(1));
        try {
            byte[] strBytes = str.getBytes();
            dos.write(strBytes);
            dos.close();
            baos.close();
        }
        catch (IOException e) {
            log.logSevere("Unable to compress string contents", e, null);
            throw new RuntimeException(e);
        }
        byte[] result = baos.toByteArray();
        return result;
    }

    private static final String generateChangeListSummaryForDebug(List<ChangedFileEntry> entries) {
        StringBuilder fileChangeSummaryList = new StringBuilder();
        fileChangeSummaryList.append("[ ");
        for (ChangedFileEntry cfe : entries) {
            if (cfe.getType() == WatchEventEntry.EventType.CREATE) {
                fileChangeSummaryList.append("+");
            } else if (cfe.getType() == WatchEventEntry.EventType.DELETE) {
                fileChangeSummaryList.append("-");
            } else if (cfe.getType() == WatchEventEntry.EventType.MODIFY) {
                fileChangeSummaryList.append(">");
            } else {
                fileChangeSummaryList.append("?");
            }
            String filename = cfe.getPath();
            int index = cfe.getPath().lastIndexOf("/");
            if (index != -1) {
                filename = filename.substring(index + 1);
            }
            fileChangeSummaryList.append(filename);
            fileChangeSummaryList.append(" ");
            if (fileChangeSummaryList.length() <= 256) continue;
            break;
        }
        if (fileChangeSummaryList.length() > 256) {
            fileChangeSummaryList.append(" (...) ");
        }
        fileChangeSummaryList.append("]");
        return fileChangeSummaryList.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = this.lock;
        synchronized (object) {
            if (this.disposed_synch_lock) {
                return;
            }
            log.logInfo("dispose() called on " + this.getClass().getSimpleName());
            this.disposed_synch_lock = true;
        }
    }

    public static class ChangedFileEntry
    implements Comparable<ChangedFileEntry> {
        private final String path;
        private final WatchEventEntry.EventType type;
        private final long timestamp;
        private final boolean directory;

        public ChangedFileEntry(String path, boolean directory, WatchEventEntry.EventType type, long timestamp) {
            if (path == null || type == null || timestamp <= 0L) {
                throw new IllegalArgumentException("Invalid parameter '" + path + "' '" + (Object)((Object)type) + "' '" + timestamp + "'");
            }
            this.path = path;
            this.type = type;
            this.timestamp = timestamp;
            this.directory = directory;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public String getPath() {
            return this.path;
        }

        public WatchEventEntry.EventType getType() {
            return this.type;
        }

        public JSONObject toJsonObject() throws JSONException {
            JSONObject result = new JSONObject();
            result.put("path", (Object)this.path);
            result.put("timestamp", this.timestamp);
            result.put("type", (Object)this.type.name());
            result.put("directory", this.directory);
            return result;
        }

        public String toString() {
            try {
                return this.toJsonObject().toString();
            }
            catch (JSONException e) {
                return this.path;
            }
        }

        @Override
        public int compareTo(ChangedFileEntry other) {
            long val = this.getTimestamp() - other.getTimestamp();
            if (val > 0L) {
                return 1;
            }
            if (val < 0L) {
                return -1;
            }
            return 0;
        }
    }

    private class EventProcessingTimerTask
    extends TimerTask {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ArrayList<ChangedFileEntry> entries = new ArrayList<ChangedFileEntry>();
            Object object = FileChangeEventBatchUtil.this.lock;
            synchronized (object) {
                entries.addAll(FileChangeEventBatchUtil.this.files_synch_lock);
                FileChangeEventBatchUtil.this.files_synch_lock.clear();
                FileChangeEventBatchUtil.this.timer_synch_lock.cancel();
                FileChangeEventBatchUtil.this.timer_synch_lock = null;
                if (entries.size() == 0) {
                    return;
                }
            }
            Collections.sort(entries);
            FileChangeEventBatchUtil.removeDuplicateEventsOfType(entries, WatchEventEntry.EventType.CREATE);
            FileChangeEventBatchUtil.removeDuplicateEventsOfType(entries, WatchEventEntry.EventType.DELETE);
            Collections.reverse(entries);
            if (entries.size() == 0) {
                return;
            }
            long mostRecentEntryTimestamp = ((ChangedFileEntry)entries.get(0)).getTimestamp();
            String changeSummary = FileChangeEventBatchUtil.generateChangeListSummaryForDebug(entries);
            log.logInfo("Batch change summary for " + FileChangeEventBatchUtil.this.projectId + "@ " + mostRecentEntryTimestamp + ": " + changeSummary);
            ArrayList<JSONArray> fileListsToSend = new ArrayList<JSONArray>();
            while (entries.size() > 0) {
                ArrayList<JSONObject> currList = new ArrayList<JSONObject>();
                while (currList.size() < 625 && entries.size() > 0) {
                    ChangedFileEntry nextPath = (ChangedFileEntry)entries.remove(entries.size() - 1);
                    try {
                        currList.add(nextPath.toJsonObject());
                    }
                    catch (JSONException e1) {
                        log.logSevere("Unable to convert changed file entry to json", e1, FileChangeEventBatchUtil.this.projectId);
                    }
                }
                if (currList.size() <= 0) continue;
                fileListsToSend.add(new JSONArray(currList));
            }
            ArrayList<String> base64Compressed = new ArrayList<String>();
            for (JSONArray array : fileListsToSend) {
                String json = array.toString();
                byte[] compressedData = FileChangeEventBatchUtil.compressString(json);
                base64Compressed.add(Base64.getEncoder().encodeToString(compressedData));
            }
            if (base64Compressed.size() > 0) {
                FileChangeEventBatchUtil.this.parent.internal_sendBulkFileChanges(FileChangeEventBatchUtil.this.projectId, mostRecentEntryTimestamp, base64Compressed);
            }
        }
    }
}

