/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.openapi.core;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.eclipse.codewind.openapi.core.util.CoreLogger;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.service.debug.DebugOptionsListener;
import org.osgi.framework.BundleContext;

public class Activator
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.codewind.openapi.core";
    private static BundleContext context;
    private static Activator plugin;

    static BundleContext getContext() {
        return context;
    }

    public void start(BundleContext bundleContext) throws Exception {
        context = bundleContext;
        plugin = this;
        context.registerService(DebugOptionsListener.class, (Object)CoreLogger.instance(), null);
    }

    public void stop(BundleContext bundleContext) throws Exception {
        context = null;
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static void log(int severity, String message) {
        switch (severity) {
            case 1: {
                if (!CoreLogger.INFO) break;
                plugin.getLog().log((IStatus)new Status(severity, PLUGIN_ID, message));
                break;
            }
            case 4: {
                if (!CoreLogger.ERROR) break;
                plugin.getLog().log((IStatus)new Status(severity, PLUGIN_ID, message));
                break;
            }
            case 2: {
                if (!CoreLogger.WARNING) break;
                plugin.getLog().log((IStatus)new Status(severity, PLUGIN_ID, message));
                break;
            }
        }
    }

    public static void log(int severity, Exception e) {
        if (CoreLogger.ERROR) {
            StringWriter writer = new StringWriter();
            PrintWriter pw = new PrintWriter(writer);
            e.printStackTrace(pw);
            plugin.getLog().log((IStatus)new Status(severity, PLUGIN_ID, writer.toString()));
        }
    }
}

