/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.core.internal;

import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.codewind.core.CodewindCorePlugin;
import org.eclipse.codewind.core.internal.CodewindApplication;
import org.eclipse.codewind.core.internal.FileUtil;
import org.eclipse.codewind.core.internal.IDebugLauncher;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.core.internal.connection.CodewindConnection;
import org.eclipse.codewind.core.internal.console.ProjectLogInfo;
import org.eclipse.codewind.core.internal.console.SocketConsole;
import org.eclipse.codewind.core.internal.constants.ProjectCapabilities;
import org.eclipse.codewind.core.internal.constants.ProjectLanguage;
import org.eclipse.codewind.core.internal.constants.ProjectType;
import org.eclipse.codewind.core.internal.launch.CodewindLaunchConfigDelegate;
import org.eclipse.codewind.core.internal.messages.Messages;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;

public class CodewindEclipseApplication
extends CodewindApplication {
    public static final String MARKER_TYPE = "org.eclipse.codewind.core.validationMarker";
    public static final String CONNECTION_URL = "connectionUrl";
    public static final String PROJECT_ID = "projectId";
    public static final String QUICK_FIX_ID = "quickFixId";
    public static final String QUICK_FIX_DESCRIPTION = "quickFixDescription";
    public static final int DEFAULT_DEBUG_CONNECT_TIMEOUT = 3;
    private Set<SocketConsole> activeConsoles = new HashSet<SocketConsole>();
    private ILaunch launch = null;

    CodewindEclipseApplication(CodewindConnection connection, String id, String name, ProjectType projectType, ProjectLanguage language, String pathInWorkspace) throws MalformedURLException {
        super(connection, id, name, projectType, language, pathInWorkspace);
    }

    public synchronized void addConsole(SocketConsole console) {
        this.activeConsoles.add(console);
    }

    public synchronized SocketConsole getConsole(ProjectLogInfo logInfo) {
        for (SocketConsole console : this.activeConsoles) {
            if (!console.logInfo.isThisLogInfo(logInfo)) continue;
            return console;
        }
        return null;
    }

    public synchronized void removeConsole(SocketConsole console) {
        if (console != null) {
            this.activeConsoles.remove((Object)console);
        }
    }

    public synchronized void setLaunch(ILaunch launch) {
        this.launch = launch;
    }

    public synchronized ILaunch getLaunch() {
        return this.launch;
    }

    @Override
    public void clearDebugger() {
        if (this.launch != null) {
            IDebugTarget debugTarget = this.launch.getDebugTarget();
            if (debugTarget != null && !debugTarget.isDisconnected()) {
                try {
                    debugTarget.disconnect();
                }
                catch (DebugException e) {
                    Logger.logError("An error occurred while disconnecting the debugger for project: " + this.name, e);
                }
            }
            ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
            launchManager.removeLaunch(this.launch);
            ILaunchConfiguration launchConfig = this.launch.getLaunchConfiguration();
            if (launchConfig != null) {
                try {
                    launchConfig.delete();
                }
                catch (CoreException e) {
                    Logger.logError("An error occurred while deleting the launch configuration for project: " + this.name, e);
                }
            }
        }
        this.setLaunch(null);
    }

    @Override
    public void connectDebugger() {
        final CodewindEclipseApplication app = this;
        Job job = new Job(Messages.ConnectDebugJob){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    if (app.projectLanguage == ProjectLanguage.LANGUAGE_JAVA) {
                        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
                        ILaunchConfigurationType launchConfigurationType = launchManager.getLaunchConfigurationType("org.eclipse.codewind.core.internal.launchConfigurationType");
                        ILaunchConfigurationWorkingCopy workingCopy = launchConfigurationType.newInstance((IContainer)null, app.name);
                        CodewindLaunchConfigDelegate.setConfigAttributes(workingCopy, app);
                        ILaunchConfiguration launchConfig = workingCopy.doSave();
                        ILaunch launch = launchConfig.launch("debug", monitor);
                        app.setLaunch(launch);
                        return Status.OK_STATUS;
                    }
                    IDebugLauncher launcher = CodewindCorePlugin.getDebugLauncher(app.projectLanguage);
                    if (launcher != null) {
                        return launcher.launchDebugger(app);
                    }
                }
                catch (Exception e) {
                    Logger.logError("An error occurred while trying to launch the debugger for project: " + app.name);
                    return new Status(4, "org.eclipse.codewind.core", NLS.bind((String)Messages.DebugLaunchError, (Object)app.name), (Throwable)e);
                }
                return Status.CANCEL_STATUS;
            }
        };
        job.setPriority(30);
        job.schedule();
    }

    @Override
    public void reconnectDebugger() {
        if (this.launch != null) {
            ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
            for (ILaunch launchItem : launchManager.getLaunches()) {
                IDebugTarget debugTarget;
                if (!this.launch.equals(launchItem) || (debugTarget = this.launch.getDebugTarget()) != null && !debugTarget.isDisconnected()) continue;
                this.clearDebugger();
                this.connectDebugger();
            }
        }
    }

    public boolean canAttachDebugger() {
        if (this.projectLanguage == ProjectLanguage.LANGUAGE_JAVA) {
            IDebugTarget debugTarget = this.getDebugTarget();
            return debugTarget == null || debugTarget.isDisconnected();
        }
        IDebugLauncher launcher = CodewindCorePlugin.getDebugLauncher(this.projectLanguage);
        if (launcher != null) {
            return launcher.canAttachDebugger(this);
        }
        return false;
    }

    public void attachDebugger() {
        if (this.launch != null) {
            IDebugTarget debugTarget = this.launch.getDebugTarget();
            if (debugTarget != null && !debugTarget.isDisconnected()) {
                return;
            }
            this.clearDebugger();
        }
        this.connectDebugger();
    }

    public IDebugTarget getDebugTarget() {
        if (this.launch != null) {
            ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
            for (ILaunch launchItem : launchManager.getLaunches()) {
                if (!this.launch.equals(launchItem)) continue;
                return this.launch.getDebugTarget();
            }
        }
        return null;
    }

    @Override
    public void dispose() {
        this.clearDebugger();
        ArrayList<SocketConsole> consoleList = new ArrayList<SocketConsole>(this.activeConsoles);
        if (!consoleList.isEmpty()) {
            IConsoleManager consoleManager = ConsolePlugin.getDefault().getConsoleManager();
            consoleManager.removeConsoles(consoleList.toArray(new IConsole[consoleList.size()]));
        }
        super.dispose();
    }

    @Override
    public void resetValidation() {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.name);
        if (project != null && project.isAccessible()) {
            try {
                project.deleteMarkers(MARKER_TYPE, true, 2);
            }
            catch (CoreException e) {
                Logger.logError("Failed to delete existing markers for the " + this.name + " project.", e);
            }
        }
    }

    @Override
    public void validationError(String filePath, String message, String quickFixId, String quickFixDescription) {
        this.validationEvent(2, filePath, message, quickFixId, quickFixDescription);
    }

    @Override
    public void validationWarning(String filePath, String message, String quickFixId, String quickFixDescription) {
        this.validationEvent(1, filePath, message, quickFixId, quickFixDescription);
    }

    private void validationEvent(int severity, String filePath, String message, String quickFixId, String quickFixDescription) {
        try {
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.name);
            if (project != null && project.isAccessible()) {
                IProject resource = project;
                if (filePath != null && !filePath.isEmpty()) {
                    IFile file;
                    Path path = new Path(filePath);
                    if (filePath.startsWith(project.getName())) {
                        path = path.removeFirstSegments(1);
                    }
                    if ((file = project.getFile((IPath)path)) != null && file.exists()) {
                        resource = file;
                    }
                }
                IMarker marker = resource.createMarker(MARKER_TYPE);
                marker.setAttribute("severity", 2);
                marker.setAttribute("message", (Object)message);
            }
        }
        catch (CoreException e) {
            Logger.logError("Failed to create a marker for the " + this.name + " application: " + message, e);
        }
    }

    @Override
    public boolean supportsDebug() {
        if (this.projectLanguage == ProjectLanguage.LANGUAGE_JAVA || this.projectLanguage == ProjectLanguage.LANGUAGE_NODEJS) {
            ProjectCapabilities capabilities = this.getProjectCapabilities();
            return (capabilities.supportsDebugMode() || capabilities.supportsDebugNoInitMode()) && capabilities.canRestart();
        }
        return false;
    }

    @Override
    public void buildComplete() {
        final IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.name);
        if (project != null && project.isAccessible()) {
            Job job = new Job(NLS.bind((String)Messages.RefreshResourceJobLabel, (Object)project.getName())){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        project.refreshLocal(2, monitor);
                        return Status.OK_STATUS;
                    }
                    catch (Exception e) {
                        Logger.logError("An error occurred while refreshing the resource: " + project.getLocation());
                        return new Status(4, "org.eclipse.codewind.core", NLS.bind((String)Messages.RefreshResourceError, (Object)project.getLocation()), (Throwable)e);
                    }
                }
            };
            job.setPriority(30);
            job.schedule();
        }
    }

    @Override
    public void onProjectDelete() {
        if (this.getDeleteContents()) {
            Job job = new Job(NLS.bind((String)Messages.DeleteProjectJobLabel, (Object)this.name)){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(CodewindEclipseApplication.this.name);
                        if (project != null && project.exists() && project.getLocation().toFile().equals(CodewindEclipseApplication.this.fullLocalPath.toFile())) {
                            project.delete(true, true, monitor);
                        } else if (CodewindEclipseApplication.this.fullLocalPath.toFile().exists()) {
                            FileUtil.deleteDirectory(CodewindEclipseApplication.this.fullLocalPath.toOSString(), true);
                        } else {
                            Logger.log("No project contents were found to delete for application: " + CodewindEclipseApplication.this.name);
                        }
                    }
                    catch (Exception e) {
                        Logger.logError("Error deleting project contents: " + CodewindEclipseApplication.this.name, e);
                        return new Status(4, "org.eclipse.codewind.core", NLS.bind((String)Messages.DeleteProjectError, (Object)CodewindEclipseApplication.this.name), (Throwable)e);
                    }
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
        }
    }
}

