/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.ui.internal.actions;

import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.core.internal.connection.CodewindConnection;
import org.eclipse.codewind.core.internal.connection.CodewindConnectionManager;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class RemoveConnectionAction
implements IObjectActionDelegate {
    protected CodewindConnection connection;

    public void selectionChanged(IAction action, ISelection selection) {
        Object obj;
        if (!(selection instanceof IStructuredSelection)) {
            action.setEnabled(false);
            return;
        }
        IStructuredSelection sel = (IStructuredSelection)selection;
        if (sel.size() == 1 && (obj = sel.getFirstElement()) instanceof CodewindConnection) {
            this.connection = (CodewindConnection)obj;
            action.setEnabled(true);
            return;
        }
        action.setEnabled(false);
    }

    public void run(IAction action) {
        if (this.connection == null) {
            Logger.logError((String)"RemoveConnectionAction ran but no connection was selected");
            return;
        }
        try {
            CodewindConnectionManager.removeConnection((String)this.connection.baseUrl.toString());
        }
        catch (Exception e) {
            Logger.logError((String)("Error removing connection: " + this.connection.baseUrl.toString()), (Throwable)e);
        }
    }

    public void setActivePart(IAction arg0, IWorkbenchPart arg1) {
    }
}

