/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.ui.internal.wizards;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.TimeoutException;
import java.util.regex.Pattern;
import org.eclipse.codewind.core.internal.CodewindManager;
import org.eclipse.codewind.core.internal.InstallStatus;
import org.eclipse.codewind.core.internal.InstallUtil;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.core.internal.ProcessHelper;
import org.eclipse.codewind.core.internal.connection.CodewindConnection;
import org.eclipse.codewind.core.internal.connection.ProjectTemplateInfo;
import org.eclipse.codewind.core.internal.constants.ProjectLanguage;
import org.eclipse.codewind.core.internal.constants.ProjectType;
import org.eclipse.codewind.ui.internal.messages.Messages;
import org.eclipse.codewind.ui.internal.prefs.RepositoryManagementDialog;
import org.eclipse.codewind.ui.internal.views.ViewHelper;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.SearchPattern;

public class NewCodewindProjectPage
extends WizardPage {
    private static final Pattern projectNamePattern = Pattern.compile("^[a-zA-Z0-9_.-]+$");
    private CodewindConnection connection;
    private List<ProjectTemplateInfo> templateList;
    private SearchPattern pattern = new SearchPattern(35);
    private Text filterText;
    private Table selectionTable;
    private Text descriptionLabel;
    private Text projectNameText;

    protected NewCodewindProjectPage(CodewindConnection connection, List<ProjectTemplateInfo> templateList) {
        super(Messages.NewProjectPage_ShellTitle);
        this.setTitle(Messages.NewProjectPage_WizardTitle);
        this.setDescription(Messages.NewProjectPage_WizardDescription);
        this.connection = connection;
        this.templateList = templateList;
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        if (this.connection == null) {
            this.setupConnection();
            if (this.connection == null) {
                this.setErrorMessage(Messages.NewProjectPage_CodewindConnectError);
                this.setControl((Control)composite);
                return;
            }
        }
        if (this.templateList == null || this.templateList.isEmpty()) {
            try {
                this.templateList = this.connection.requestProjectTemplates(true);
            }
            catch (Exception e) {
                Logger.logError((String)"An error occurred trying to get the list of templates", (Throwable)e);
                this.setErrorMessage(Messages.NewProjectPage_TemplateListError);
                this.setControl((Control)composite);
                return;
            }
        }
        if (this.templateList.isEmpty()) {
            this.setErrorMessage(Messages.NewProjectPage_EmptyTemplateList);
        } else {
            this.templateList.sort(new Comparator<ProjectTemplateInfo>(){

                @Override
                public int compare(ProjectTemplateInfo info1, ProjectTemplateInfo info2) {
                    return info1.getLabel().compareTo(info2.getLabel());
                }
            });
        }
        this.createContents(composite);
        this.setControl((Control)composite);
    }

    private void createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        Label label = new Label(composite, 0);
        label.setText(Messages.NewProjectPage_ProjectNameLabel);
        this.projectNameText = new Text(composite, 2048);
        this.projectNameText.setLayoutData((Object)new GridData(4, 4, true, false));
        Label spacer = new Label(composite, 0);
        spacer.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        Text templateText = new Text(composite, 8);
        templateText.setText(Messages.NewProjectPage_TemplateGroupLabel);
        templateText.setLayoutData((Object)new GridData(1, 2, false, false, 2, 1));
        templateText.setBackground(composite.getBackground());
        templateText.setForeground(composite.getForeground());
        Group templateGroup = new Group(composite, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 8;
        layout.marginWidth = 8;
        layout.horizontalSpacing = 7;
        layout.verticalSpacing = 7;
        templateGroup.setLayout((Layout)layout);
        templateGroup.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.filterText = new Text((Composite)templateGroup, 2048);
        this.filterText.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        this.filterText.setMessage(Messages.NewProjectPage_FilterMessage);
        this.selectionTable = new Table((Composite)templateGroup, 68352);
        GridData data = new GridData(4, 4, true, true, 2, 1);
        data.heightHint = 100;
        this.selectionTable.setLayoutData((Object)data);
        final TableColumn templateColumn = new TableColumn(this.selectionTable, 0);
        templateColumn.setText(Messages.NewProjectPage_TemplateColumn);
        templateColumn.setResizable(true);
        templateColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                NewCodewindProjectPage.sortTable(NewCodewindProjectPage.this.selectionTable, templateColumn);
            }
        });
        final TableColumn typeColumn = new TableColumn(this.selectionTable, 0);
        typeColumn.setText(Messages.NewProjectPage_TypeColumn);
        typeColumn.setResizable(true);
        typeColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                NewCodewindProjectPage.sortTable(NewCodewindProjectPage.this.selectionTable, typeColumn);
            }
        });
        final TableColumn languageColumn = new TableColumn(this.selectionTable, 0);
        languageColumn.setText(Messages.NewProjectPage_LanguageColumn);
        languageColumn.setResizable(true);
        languageColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                NewCodewindProjectPage.sortTable(NewCodewindProjectPage.this.selectionTable, languageColumn);
            }
        });
        this.selectionTable.setHeaderVisible(true);
        this.selectionTable.setLinesVisible(false);
        this.selectionTable.setSortDirection(1024);
        this.selectionTable.setSortColumn(templateColumn);
        this.createItems(this.selectionTable, "");
        this.resizeColumns(this.selectionTable);
        ScrolledComposite descriptionScroll = new ScrolledComposite((Composite)templateGroup, 512);
        this.descriptionLabel = new Text((Composite)descriptionScroll, 72);
        this.descriptionLabel.setText(NLS.bind((String)Messages.NewProjectPage_DescriptionLabel, (Object)""));
        this.descriptionLabel.setBackground(templateGroup.getBackground());
        this.descriptionLabel.setForeground(templateGroup.getForeground());
        descriptionScroll.setContent((Control)this.descriptionLabel);
        data = new GridData(4, 4, true, false);
        int lineHeight = this.filterText.computeSize((int)-1, (int)-1).y;
        data.heightHint = lineHeight * 2;
        data.horizontalSpan = 2;
        descriptionScroll.setLayoutData((Object)data);
        descriptionScroll.getVerticalBar().setPageIncrement(lineHeight);
        descriptionScroll.getVerticalBar().setIncrement(lineHeight);
        descriptionScroll.setBackground(templateGroup.getBackground());
        descriptionScroll.setForeground(templateGroup.getForeground());
        Composite manageReposComp = new Composite(composite, 0);
        manageReposComp.setLayout((Layout)new GridLayout(2, false));
        manageReposComp.setLayoutData((Object)new GridData(3, 4, false, false, 2, 1));
        Label manageRepoLabel = new Label(manageReposComp, 0);
        manageRepoLabel.setText(Messages.NewProjectPage_ManageRepoLabel);
        manageRepoLabel.setLayoutData((Object)new GridData(3, 2, false, false));
        Link manageRepoLink = new Link(manageReposComp, 0);
        manageRepoLink.setText("<a>" + Messages.NewProjectPage_ManageRepoLink + "</a>");
        manageRepoLink.setToolTipText(Messages.NewProjectPage_ManageRepoTooltip);
        manageRepoLink.setLayoutData((Object)new GridData(3, 2, false, false));
        manageRepoLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                block5: {
                    try {
                        List repoList = NewCodewindProjectPage.this.connection.requestRepositories();
                        final RepositoryManagementDialog repoDialog = new RepositoryManagementDialog(NewCodewindProjectPage.this.getShell(), NewCodewindProjectPage.this.connection, repoList);
                        if (repoDialog.open() != 0 || !repoDialog.hasChanges()) break block5;
                        IRunnableWithProgress runnable = new IRunnableWithProgress(){

                            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                                SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.RepoUpdateTask, (int)100);
                                IStatus status = repoDialog.updateRepos((IProgressMonitor)mon.split(75));
                                if (!status.isOK()) {
                                    throw new InvocationTargetException(status.getException(), status.getMessage());
                                }
                                if (mon.isCanceled()) {
                                    return;
                                }
                                try {
                                    mon = mon.split(25);
                                    mon.setTaskName(Messages.NewProjectPage_RefreshTemplatesTask);
                                    NewCodewindProjectPage.this.templateList = NewCodewindProjectPage.this.connection.requestProjectTemplates(true);
                                    mon.worked(25);
                                }
                                catch (Exception e) {
                                    throw new InvocationTargetException(e, Messages.NewProjectPage_RefreshTemplatesError);
                                }
                            }
                        };
                        try {
                            NewCodewindProjectPage.this.getWizard().getContainer().run(true, true, runnable);
                        }
                        catch (InvocationTargetException e) {
                            MessageDialog.openError((Shell)NewCodewindProjectPage.this.getShell(), (String)Messages.RepoUpdateErrorTitle, (String)e.getMessage());
                            return;
                        }
                        catch (InterruptedException e) {
                            return;
                        }
                        NewCodewindProjectPage.this.updateSelectionTable();
                    }
                    catch (Exception e) {
                        MessageDialog.openError((Shell)NewCodewindProjectPage.this.getShell(), (String)Messages.RepoListErrorTitle, (String)NLS.bind((String)Messages.RepoListErrorMsg, (Object)e));
                    }
                }
            }
        });
        this.filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                NewCodewindProjectPage.this.updateSelectionTable();
            }
        });
        this.filterText.addListener(1, new Listener(){

            public void handleEvent(Event event) {
                if (event.keyCode == 0x1000002) {
                    if (NewCodewindProjectPage.this.selectionTable.getItemCount() > 0) {
                        NewCodewindProjectPage.this.selectionTable.setSelection(0);
                        NewCodewindProjectPage.this.updateDescription();
                        NewCodewindProjectPage.this.selectionTable.setFocus();
                    }
                    event.doit = false;
                    NewCodewindProjectPage.this.setPageComplete(NewCodewindProjectPage.this.validate());
                }
            }
        });
        this.selectionTable.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                NewCodewindProjectPage.this.updateDescription();
                NewCodewindProjectPage.this.setPageComplete(NewCodewindProjectPage.this.validate());
            }
        });
        this.projectNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                NewCodewindProjectPage.this.setPageComplete(NewCodewindProjectPage.this.validate());
            }
        });
        if (this.selectionTable.getItemCount() > 0) {
            this.selectionTable.setSelection(0);
        }
        this.updateDescription();
        this.descriptionLabel.setSize(this.descriptionLabel.computeSize(-1, -1));
        this.projectNameText.setFocus();
    }

    private boolean validate() {
        if (this.templateList == null || this.templateList.isEmpty()) {
            this.setErrorMessage(Messages.NewProjectPage_EmptyTemplateList);
            return false;
        }
        String projectName = this.projectNameText.getText();
        if (projectName == null || projectName.isEmpty()) {
            this.setErrorMessage(Messages.NewProjectPage_EmptyProjectName);
            return false;
        }
        if (!projectNamePattern.matcher(projectName).matches()) {
            this.setErrorMessage(Messages.NewProjectPage_InvalidProjectName);
            return false;
        }
        if (this.connection.getAppByName(projectName) != null) {
            this.setErrorMessage(NLS.bind((String)Messages.NewProjectPage_ProjectExistsError, (Object)projectName));
            return false;
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (project != null && project.exists()) {
            this.setErrorMessage(NLS.bind((String)Messages.NewProjectPage_EclipseProjectExistsError, (Object)projectName));
            return false;
        }
        this.setErrorMessage(null);
        return this.selectionTable.getSelectionCount() == 1 && projectName != null && !projectName.isEmpty();
    }

    public ProjectTemplateInfo getProjectTemplateInfo() {
        int index;
        if (this.selectionTable != null && (index = this.selectionTable.getSelectionIndex()) >= 0) {
            TableItem item = this.selectionTable.getItem(index);
            return (ProjectTemplateInfo)item.getData();
        }
        return null;
    }

    public CodewindConnection getConnection() {
        return this.connection;
    }

    public String getProjectName() {
        if (this.projectNameText != null) {
            return this.projectNameText.getText();
        }
        return null;
    }

    private void createItems(Table table, String filter) {
        table.removeAll();
        this.pattern.setPattern("*" + filter + "*");
        for (ProjectTemplateInfo templateInfo : this.templateList) {
            String template = templateInfo.getLabel();
            String type = ProjectType.getDisplayName((String)templateInfo.getProjectType());
            String language = ProjectLanguage.getDisplayName((String)templateInfo.getLanguage());
            if (!this.pattern.matches(template) && (type == null || !this.pattern.matches(type)) && (language == null || !this.pattern.matches(language))) continue;
            TableItem item = new TableItem(table, 0);
            item.setForeground(table.getForeground());
            item.setBackground(table.getBackground());
            item.setText(0, template);
            if (type != null) {
                item.setText(1, type);
            }
            if (language != null) {
                item.setText(2, language);
            }
            item.setData((Object)templateInfo);
        }
    }

    public static void sortTable(Table table, TableColumn column) {
        int i;
        TableItem[] items = table.getItems();
        int rows = items.length;
        int dir = table.getSortDirection() == 1024 ? 1 : -1;
        TableColumn currentColumn = table.getSortColumn();
        int columnNum = 0;
        for (int j = 0; j < table.getColumnCount(); ++j) {
            if (!table.getColumn(j).equals(column)) continue;
            columnNum = j;
            break;
        }
        dir = column.equals(currentColumn) ? -dir : 1;
        int[] map = new int[rows];
        for (i = 0; i < rows; ++i) {
            map[i] = i;
        }
        for (i = 0; i < rows - 1; ++i) {
            for (int j = i + 1; j < rows; ++j) {
                TableItem a = items[map[i]];
                TableItem b = items[map[j]];
                if (a.getText(columnNum).toLowerCase().compareTo(b.getText(columnNum).toLowerCase()) * dir <= 0) continue;
                int t = map[i];
                map[i] = map[j];
                map[j] = t;
            }
        }
        for (i = 0; i < rows; ++i) {
            int n = map[i];
            TableItem item = new TableItem(table, 0);
            for (int j = 0; j < table.getColumnCount(); ++j) {
                item.setText(j, items[n].getText(j));
            }
            item.setImage(items[n].getImage());
            item.setForeground(items[n].getForeground());
            item.setBackground(items[n].getBackground());
            item.setGrayed(items[n].getGrayed());
            item.setChecked(items[n].getChecked());
            item.setData(items[n].getData());
            items[n].dispose();
        }
        table.setSortDirection(dir == 1 ? 1024 : 128);
        table.setSortColumn(column);
    }

    private void updateSelectionTable() {
        String text = this.filterText.getText();
        if (text == null) {
            text = "";
        }
        this.createItems(this.selectionTable, text);
        if (this.selectionTable.getItemCount() > 0) {
            this.selectionTable.select(0);
        }
        this.updateDescription();
        this.setPageComplete(this.validate());
    }

    public void updateDescription() {
        TableItem[] items = this.selectionTable.getSelection();
        String description = "";
        boolean enabled = false;
        if (items.length == 1) {
            enabled = true;
            description = ((ProjectTemplateInfo)items[0].getData()).getDescription();
            if (description == null || description.isEmpty()) {
                description = Messages.NewProjectPage_DescriptionNone;
            }
        }
        String text = NLS.bind((String)Messages.NewProjectPage_DescriptionLabel, (Object)description);
        this.descriptionLabel.setText(text);
        int width = this.descriptionLabel.getParent().getClientArea().width;
        this.descriptionLabel.setSize(width, this.descriptionLabel.computeSize((int)width, (int)-1).y);
        int newWidth = this.descriptionLabel.getParent().getClientArea().width;
        if (newWidth != width) {
            this.descriptionLabel.setSize(newWidth, this.descriptionLabel.computeSize((int)newWidth, (int)-1).y);
        }
        this.descriptionLabel.setEnabled(enabled);
    }

    public void resizeColumns(Table table) {
        int i;
        TableLayout tableLayout = new TableLayout();
        int numColumns = table.getColumnCount();
        for (i = 0; i < numColumns; ++i) {
            table.getColumn(i).pack();
        }
        for (i = 0; i < numColumns; ++i) {
            int w = Math.max(75, table.getColumn(i).getWidth());
            tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(w, w, true));
        }
        table.setLayout((Layout)tableLayout);
    }

    private void setupConnection() {
        final CodewindManager manager = CodewindManager.getManager();
        this.connection = manager.getLocalConnection();
        if (this.connection != null && this.connection.isConnected()) {
            return;
        }
        final InstallStatus status = manager.getInstallStatus();
        if (status.isStarted()) {
            this.connection = manager.createLocalConnection();
            return;
        }
        if (!status.isInstalled()) {
            Logger.logError((String)"In NewCodewindProjectPage setupConnection method and Codewind is not installed or has unknown status.");
            this.connection = null;
            return;
        }
        this.connection = null;
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    ProcessHelper.ProcessResult result = InstallUtil.startCodewind((String)status.getVersion(), (IProgressMonitor)monitor);
                    if (result.getExitValue() != 0) {
                        Logger.logError((String)("Installer start failed with return code: " + result.getExitValue() + ", output: " + result.getOutput() + ", error: " + result.getError()));
                        String errorText = result.getError() != null && !result.getError().isEmpty() ? result.getError() : result.getOutput();
                        throw new InvocationTargetException(null, "There was a problem while trying to start Codewind: " + errorText);
                    }
                    NewCodewindProjectPage.this.connection = manager.createLocalConnection();
                    ViewHelper.refreshCodewindExplorerView(null);
                }
                catch (IOException e) {
                    throw new InvocationTargetException(e, "An error occurred trying to start Codewind: " + e.getMessage());
                }
                catch (TimeoutException e) {
                    throw new InvocationTargetException(e, "Codewind did not start in the expected time: " + e.getMessage());
                }
            }
        };
        try {
            this.getWizard().getContainer().run(true, true, runnable);
        }
        catch (InvocationTargetException e) {
            Logger.logError((String)"An error occurred trying to start Codewind", (Throwable)e);
            return;
        }
        catch (InterruptedException e) {
            Logger.logError((String)"Codewind start was interrupted", (Throwable)e);
            return;
        }
        if (this.connection == null) {
            Logger.logError((String)("Failed to connect to Codewind at: " + manager.getLocalURI()));
        }
    }
}

