/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.ui.internal.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.codewind.core.internal.InstallUtil;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.core.internal.connection.CodewindConnection;
import org.eclipse.codewind.core.internal.connection.ProjectTemplateInfo;
import org.eclipse.codewind.core.internal.constants.ProjectInfo;
import org.eclipse.codewind.core.internal.constants.ProjectLanguage;
import org.eclipse.codewind.core.internal.constants.ProjectType;
import org.eclipse.codewind.ui.internal.messages.Messages;
import org.eclipse.codewind.ui.internal.prefs.RepositoryManagementDialog;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ProjectTypeSelectionPage
extends WizardPage {
    private CodewindConnection connection = null;
    private IProject project = null;
    private Map<String, Set<String>> typeMap;
    private String type = null;
    private String language = null;
    private Text languageLabel = null;
    private CheckboxTableViewer languageViewer = null;
    private Text typeLabel = null;
    private CheckboxTableViewer typeViewer = null;
    private ProjectInfo projectInfo = null;

    protected ProjectTypeSelectionPage(CodewindConnection connection, IProject project) {
        super(Messages.SelectProjectTypePageName);
        this.setTitle(Messages.SelectProjectTypePageTitle);
        this.setDescription(Messages.SelectProjectTypePageDescription);
        this.connection = connection;
        this.setProject(project);
        this.typeMap = this.getProjectTypeMap();
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.horizontalSpacing = 5;
        layout.verticalSpacing = 7;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        if (this.typeMap == null) {
            Text errorLabel = new Text(composite, 72);
            errorLabel.setText(Messages.SelectProjectTypeErrorLabel);
            this.setControl((Control)composite);
            return;
        }
        if (this.typeMap.isEmpty()) {
            this.setErrorMessage(Messages.SelectProjectTypeNoProjectTypes);
        }
        this.typeLabel = new Text(composite, 8);
        this.typeLabel.setText(Messages.SelectProjectTypePageProjectTypeLabel);
        this.typeLabel.setLayoutData((Object)new GridData(1, 2, false, false));
        this.typeLabel.setBackground(composite.getBackground());
        this.typeLabel.setForeground(composite.getForeground());
        this.typeViewer = CheckboxTableViewer.newCheckList((Composite)composite, (int)2816);
        this.typeViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.typeViewer.setLabelProvider((IBaseLabelProvider)new ProjectTypeLabelProvider());
        this.typeViewer.setInput((Object)this.getProjectTypeArray());
        GridData typeViewerData = new GridData(4, 4, true, true);
        typeViewerData.minimumHeight = 200;
        this.typeViewer.getTable().setLayoutData((Object)typeViewerData);
        this.languageLabel = new Text(composite, 8);
        this.languageLabel.setText(Messages.SelectProjectTypePageLanguageLabel);
        this.languageLabel.setLayoutData((Object)new GridData(1, 2, false, false));
        this.languageLabel.setBackground(composite.getBackground());
        this.languageLabel.setForeground(composite.getForeground());
        this.languageViewer = CheckboxTableViewer.newCheckList((Composite)composite, (int)2816);
        this.languageViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.languageViewer.setLabelProvider((IBaseLabelProvider)new LanguageLabelProvider());
        this.languageViewer.getTable().setLayoutData((Object)new GridData(4, 4, true, true));
        this.typeViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (event.getChecked()) {
                    ProjectTypeSelectionPage.this.typeViewer.setCheckedElements(new Object[]{event.getElement()});
                    ProjectTypeSelectionPage.this.type = (String)event.getElement();
                } else {
                    ProjectTypeSelectionPage.this.type = null;
                }
                String[] languages = ProjectTypeSelectionPage.this.getLanguageArray(ProjectTypeSelectionPage.this.type);
                if (languages != null && languages.length > 1) {
                    if (ProjectTypeSelectionPage.this.language != null) {
                        boolean found = false;
                        for (String lang : languages) {
                            if (!ProjectTypeSelectionPage.this.language.equals(lang)) continue;
                            ProjectTypeSelectionPage.this.languageViewer.setCheckedElements(new Object[]{ProjectTypeSelectionPage.this.language});
                            found = true;
                            break;
                        }
                        if (!found) {
                            ProjectTypeSelectionPage.this.language = null;
                        }
                    }
                    ProjectTypeSelectionPage.this.languageLabel.setVisible(true);
                    ProjectTypeSelectionPage.this.languageViewer.setInput((Object)languages);
                    ProjectTypeSelectionPage.this.languageViewer.getTable().setVisible(true);
                } else {
                    if (languages.length == 1) {
                        ProjectTypeSelectionPage.this.language = languages[0];
                    } else {
                        ProjectTypeSelectionPage.this.language = null;
                    }
                    ProjectTypeSelectionPage.this.languageLabel.setVisible(false);
                    ProjectTypeSelectionPage.this.languageViewer.getTable().setVisible(false);
                }
                ProjectTypeSelectionPage.this.getWizard().getContainer().updateButtons();
            }
        });
        this.languageViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (event.getChecked()) {
                    ProjectTypeSelectionPage.this.languageViewer.setCheckedElements(new Object[]{event.getElement()});
                    ProjectTypeSelectionPage.this.language = (String)event.getElement();
                } else {
                    ProjectTypeSelectionPage.this.language = null;
                }
                ProjectTypeSelectionPage.this.getWizard().getContainer().updateButtons();
            }
        });
        Composite manageReposComp = new Composite(composite, 0);
        manageReposComp.setLayout((Layout)new GridLayout(2, false));
        manageReposComp.setLayoutData((Object)new GridData(3, 4, false, false, 1, 1));
        Label manageRepoLabel = new Label(manageReposComp, 0);
        manageRepoLabel.setText(Messages.SelectProjectTypeManageRepoLabel);
        manageRepoLabel.setLayoutData((Object)new GridData(3, 2, false, false));
        Link manageRepoLink = new Link(manageReposComp, 0);
        manageRepoLink.setText("<a>" + Messages.SelectProjectTypeManageRepoLink + "</a>");
        manageRepoLink.setToolTipText(Messages.SelectProjectTypeManageRepoTooltip);
        manageRepoLink.setLayoutData((Object)new GridData(3, 2, false, false));
        manageRepoLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                block5: {
                    try {
                        List repoList = ProjectTypeSelectionPage.this.connection.requestRepositories();
                        final RepositoryManagementDialog repoDialog = new RepositoryManagementDialog(ProjectTypeSelectionPage.this.getShell(), ProjectTypeSelectionPage.this.connection, repoList);
                        if (repoDialog.open() != 0 || !repoDialog.hasChanges()) break block5;
                        IRunnableWithProgress runnable = new IRunnableWithProgress(){

                            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                                SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.RepoUpdateTask, (int)100);
                                IStatus status = repoDialog.updateRepos((IProgressMonitor)mon.split(75));
                                if (!status.isOK()) {
                                    throw new InvocationTargetException(status.getException(), status.getMessage());
                                }
                                if (mon.isCanceled()) {
                                    return;
                                }
                                try {
                                    mon = mon.split(25);
                                    mon.setTaskName(Messages.SelectProjectTypeRefreshTypesTask);
                                    ProjectTypeSelectionPage.this.typeMap = ProjectTypeSelectionPage.this.getProjectTypeMap();
                                    mon.worked(25);
                                }
                                catch (Exception e) {
                                    throw new InvocationTargetException(e, Messages.SelectProjectTypeRefreshTypesError);
                                }
                            }
                        };
                        try {
                            ProjectTypeSelectionPage.this.getWizard().getContainer().run(true, true, runnable);
                        }
                        catch (InvocationTargetException e) {
                            MessageDialog.openError((Shell)ProjectTypeSelectionPage.this.getShell(), (String)Messages.RepoUpdateErrorTitle, (String)e.getMessage());
                            return;
                        }
                        catch (InterruptedException e) {
                            return;
                        }
                        ProjectTypeSelectionPage.this.updateTables();
                    }
                    catch (Exception e) {
                        MessageDialog.openError((Shell)ProjectTypeSelectionPage.this.getShell(), (String)Messages.RepoListErrorTitle, (String)NLS.bind((String)Messages.RepoListErrorMsg, (Object)e));
                    }
                }
            }
        });
        this.languageLabel.setVisible(false);
        this.languageViewer.getTable().setVisible(false);
        this.updateTables();
        this.typeViewer.getTable().setFocus();
        this.setControl((Control)composite);
    }

    public boolean canFinish() {
        return this.type != null;
    }

    private String[] getProjectTypeArray() {
        Set<String> typeSet = this.typeMap.keySet();
        String[] types = typeSet.toArray(new String[typeSet.size()]);
        Arrays.sort(types, new Comparator<String>(){

            @Override
            public int compare(String t1, String t2) {
                return ProjectType.getDisplayName((String)t1).compareToIgnoreCase(ProjectType.getDisplayName((String)t2));
            }
        });
        return types;
    }

    private String[] getLanguageArray(String type) {
        Set<String> languageSet = this.typeMap.get(type);
        if (languageSet == null || languageSet.isEmpty()) {
            return new String[0];
        }
        String[] languages = languageSet.toArray(new String[languageSet.size()]);
        Arrays.sort(languages, new Comparator<String>(){

            @Override
            public int compare(String l1, String l2) {
                return ProjectLanguage.getDisplayName((String)l1).compareToIgnoreCase(ProjectLanguage.getDisplayName((String)l2));
            }
        });
        return languages;
    }

    public void setProject(final IProject project) {
        this.project = project;
        this.projectInfo = null;
        if (project == null) {
            return;
        }
        if (this.getWizard() != null && this.getWizard().getContainer() != null) {
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException {
                    SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (String)NLS.bind((String)Messages.SelectProjectTypeValidateTask, (Object)project.getName()), (int)100);
                    ProjectTypeSelectionPage.this.projectInfo = ProjectTypeSelectionPage.this.getProjectInfo((IProgressMonitor)mon.split(100));
                }
            };
            try {
                this.getContainer().run(true, true, runnable);
            }
            catch (InvocationTargetException e) {
                Logger.logError((String)("An error occurred getting the project info for: " + project.getName()), (Throwable)e);
                return;
            }
            catch (InterruptedException e) {
                return;
            }
        } else {
            this.projectInfo = this.getProjectInfo((IProgressMonitor)new NullProgressMonitor());
        }
        this.updateTables();
    }

    public CodewindConnection getConnection() {
        return this.connection;
    }

    public String getType() {
        if (this.type == null) {
            Logger.logError((String)"The project type is null on the project type selection page");
            return ProjectType.TYPE_UNKNOWN.getId();
        }
        return this.type;
    }

    public String getLanguage() {
        if (this.language == null) {
            return ProjectLanguage.LANGUAGE_UNKNOWN.getId();
        }
        return this.language;
    }

    private void updateTables() {
        if (this.typeViewer == null || this.typeViewer.getTable().isDisposed()) {
            return;
        }
        String[] projectTypes = this.getProjectTypeArray();
        this.typeViewer.setInput((Object)projectTypes);
        if (projectTypes.length == 0) {
            this.setErrorMessage(Messages.SelectProjectTypeNoProjectTypes);
            this.updateLanguages(null, null);
            return;
        }
        this.setErrorMessage(null);
        if (this.type != null && this.typeMap.containsKey(this.type)) {
            this.typeViewer.setCheckedElements(new Object[]{this.type});
            String[] languages = this.getLanguageArray(this.type);
            this.updateLanguages(languages, this.language);
        } else if (this.projectInfo != null) {
            this.type = this.projectInfo.type.getId();
            this.language = this.projectInfo.language.getId();
            if (this.typeMap.containsKey(this.type)) {
                this.typeViewer.setCheckedElements(new Object[]{this.type});
                String[] languages = this.getLanguageArray(this.type);
                this.updateLanguages(languages, this.language);
            }
        }
    }

    private void updateLanguages(String[] languages, String language) {
        if (this.languageViewer == null || this.languageViewer.getTable().isDisposed()) {
            return;
        }
        if (languages != null && languages.length > 1) {
            this.languageLabel.setVisible(true);
            this.languageViewer.setInput((Object)languages);
            this.languageViewer.getTable().setVisible(true);
            if (language != null) {
                for (String lang : languages) {
                    if (!language.equals(lang)) continue;
                    this.languageViewer.setCheckedElements(new Object[]{language});
                    break;
                }
            }
            this.languageViewer.getTable().setVisible(true);
        } else {
            this.languageLabel.setVisible(false);
            this.languageViewer.getTable().setVisible(false);
        }
    }

    private ProjectInfo getProjectInfo(IProgressMonitor monitor) {
        if (this.connection == null || this.project == null) {
            return null;
        }
        try {
            return InstallUtil.validateProject((String)this.project.getName(), (String)this.project.getLocation().toFile().getAbsolutePath(), (IProgressMonitor)monitor);
        }
        catch (Exception e) {
            Logger.logError((String)("An error occurred trying to get the project type for project: " + this.project.getName()), (Throwable)e);
            return null;
        }
    }

    private Map<String, Set<String>> getProjectTypeMap() {
        List templates = null;
        HashMap<String, Set<String>> typeMap = new HashMap<String, Set<String>>();
        try {
            templates = this.connection.requestProjectTemplates(true);
        }
        catch (Exception e) {
            Logger.logError((String)("An error occurred trying to get the list of templates for connection: " + this.connection.baseUrl), (Throwable)e);
            return null;
        }
        if (templates == null || templates.isEmpty()) {
            Logger.log((String)("The list of templates is empty for connection: " + this.connection.baseUrl));
            return typeMap;
        }
        for (ProjectTemplateInfo template : templates) {
            HashSet<String> languages = (HashSet<String>)typeMap.get(template.getProjectType());
            if (languages == null) {
                languages = new HashSet<String>();
                typeMap.put(template.getProjectType(), languages);
            }
            if (template.getLanguage() == null || template.getLanguage().isEmpty()) continue;
            languages.add(template.getLanguage());
        }
        return typeMap;
    }

    private class LanguageLabelProvider
    extends LabelProvider {
        private LanguageLabelProvider() {
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            return ProjectLanguage.getDisplayName((String)((String)element));
        }
    }

    private class ProjectTypeLabelProvider
    extends LabelProvider {
        private ProjectTypeLabelProvider() {
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            return ProjectType.getDisplayName((String)((String)element));
        }
    }
}

