/*******************************************************************************
* Copyright (c) 2019 IBM Corporation and others.
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v2.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v20.html
*
* Contributors:
*     IBM Corporation - initial API and implementation
*******************************************************************************/
/** Ensure that the drive is lowercase for Unix-style paths from Windows. */
export declare function normalizeDriveLetter(absolutePath: string): string;
/** C:\helloThere -> /c/helloThere */
export declare function convertFromWindowsDriveLetter(absolutePath: string): string;
/** Same as below, but determine behaviour based on OS. */
export declare function convertAbsoluteUnixStyleNormalizedPathToLocalFile(str: string): string;
export declare function stripTrailingSlash(str: string): string;
export declare function convertAbsolutePathWithUnixSeparatorsToProjectRelativePath(path: string, rootPath: string): string;
/**  C:\helloThere -> /c/helloThere */
export declare function normalizePath(pathParam: string): string;
