"use strict";
/*******************************************************************************
* Copyright (c) 2019 IBM Corporation and others.
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v2.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v20.html
*
* Contributors:
*     IBM Corporation - initial API and implementation
*******************************************************************************/
Object.defineProperty(exports, "__esModule", { value: true });
class ExponentialBackoffUtil {
    static getDefaultBackoffUtil(maxFailureDelay) {
        return new ExponentialBackoffUtil(500, maxFailureDelay, 1.5);
    }
    constructor(minFailureDelay, maxFailureDelay, backoffExponent) {
        this._minFailureDelay = minFailureDelay;
        this._maxFailureDelay = maxFailureDelay;
        this._failureDelay = minFailureDelay;
        this._backoffExponent = backoffExponent;
    }
    async sleepAsync() {
        await new Promise((resolve) => setTimeout(resolve, this._failureDelay));
    }
    failIncrease() {
        this._failureDelay *= this._backoffExponent;
        if (this._failureDelay > this._maxFailureDelay) {
            this._failureDelay = this._maxFailureDelay;
        }
    }
    successReset() {
        this._failureDelay = this._minFailureDelay;
    }
}
exports.ExponentialBackoffUtil = ExponentialBackoffUtil;
