/*******************************************************************************
* Copyright (c) 2019 IBM Corporation and others.
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v2.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v20.html
*
* Contributors:
*     IBM Corporation - initial API and implementation
*******************************************************************************/
import * as models from "./Models";
export declare class ProjectToWatch {
    /**
     * The contents of this class are immutable after creation, and should not be changed.
     * Do not add non-readonly fields to this class.
     */
    private readonly _projectId;
    private readonly _pathToMonitor;
    private readonly _ignoredPaths;
    private readonly _ignoredFilenames;
    private readonly _projectWatchStateId;
    constructor(json: models.IWatchedProjectJson, deleteChangeType: boolean);
    private validatePathToMonitor;
    readonly projectId: string;
    readonly pathToMonitor: string;
    readonly ignoredPaths: string[];
    readonly ignoredFilenames: string[];
    readonly projectWatchStateId: string;
}
