"use strict";
/*******************************************************************************
* Copyright (c) 2019 IBM Corporation and others.
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v2.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v20.html
*
* Contributors:
*     IBM Corporation - initial API and implementation
*******************************************************************************/
Object.defineProperty(exports, "__esModule", { value: true });
const PathUtils = require("./PathUtils");
class ProjectToWatch {
    constructor(json, deleteChangeType) {
        // Delete event from WebSocket only has these fields.
        if (deleteChangeType) {
            this._projectId = json.projectID;
            this._pathToMonitor = null;
            this._projectWatchStateId = null;
            return;
        }
        this._projectId = json.projectID;
        this._pathToMonitor = PathUtils.normalizeDriveLetter(json.pathToMonitor);
        this.validatePathToMonitor();
        const ignoredPaths = [];
        if (json.ignoredPaths && json.ignoredPaths.length > 0) {
            json.ignoredPaths.forEach((e) => { ignoredPaths.push(e); });
        }
        this._ignoredPaths = ignoredPaths;
        const ignoredFilenames = [];
        if (json.ignoredFilenames && json.ignoredFilenames.length > 0) {
            json.ignoredFilenames.forEach((e) => { ignoredFilenames.push(e); });
        }
        this._ignoredFilenames = ignoredFilenames;
        this._projectWatchStateId = json.projectWatchStateId;
    }
    validatePathToMonitor() {
        if (this._pathToMonitor.indexOf("\\") !== -1) {
            throw new Error("Path to monitor should not contain Windows-style path separators: " + this._pathToMonitor);
        }
        if (!this._pathToMonitor.startsWith("/")) {
            throw new Error("Path to monitor should always begin with a forward slash: " + this._pathToMonitor);
        }
        if (this._pathToMonitor.endsWith("/") || this._pathToMonitor.endsWith("\\")) {
            throw new Error("Path to monitor may not end with path separator: " + this._pathToMonitor);
        }
    }
    get projectId() {
        return this._projectId;
    }
    get pathToMonitor() {
        return this._pathToMonitor;
    }
    get ignoredPaths() {
        return this._ignoredPaths;
    }
    get ignoredFilenames() {
        return this._ignoredFilenames;
    }
    get projectWatchStateId() {
        return this._projectWatchStateId;
    }
}
exports.ProjectToWatch = ProjectToWatch;
