/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.ui.internal.views;

import java.util.List;
import org.eclipse.codewind.core.internal.CodewindApplication;
import org.eclipse.codewind.core.internal.CodewindManager;
import org.eclipse.codewind.core.internal.connection.CodewindConnection;
import org.eclipse.codewind.core.internal.connection.CodewindConnectionManager;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.viewers.ITreeContentProvider;

public class CodewindNavigatorContentProvider
implements ITreeContentProvider {
    public Object[] getChildren(Object obj) {
        if (obj instanceof CodewindManager) {
            List connections = CodewindConnectionManager.activeConnections();
            return connections.toArray(new CodewindConnection[connections.size()]);
        }
        if (obj instanceof CodewindConnection) {
            CodewindConnection connection = (CodewindConnection)obj;
            List apps = connection.getApps();
            return apps.toArray(new CodewindApplication[apps.size()]);
        }
        return null;
    }

    public Object[] getElements(Object obj) {
        return new Object[]{CodewindManager.getManager()};
    }

    public Object getParent(Object obj) {
        if (obj instanceof CodewindManager) {
            return ResourcesPlugin.getWorkspace().getRoot();
        }
        if (obj instanceof CodewindConnection) {
            return CodewindManager.getManager();
        }
        if (obj instanceof CodewindApplication) {
            CodewindApplication app = (CodewindApplication)obj;
            return app.connection;
        }
        return null;
    }

    public boolean hasChildren(Object obj) {
        if (obj instanceof CodewindManager) {
            CodewindManager manager = (CodewindManager)obj;
            if (manager.getInstallStatus().isStarted()) {
                if (manager.getLocalConnection() == null) {
                    manager.createLocalConnection();
                }
                return !CodewindConnectionManager.activeConnections().isEmpty();
            }
        } else if (obj instanceof CodewindConnection) {
            CodewindConnection connection = (CodewindConnection)obj;
            return !connection.getApps().isEmpty();
        }
        return false;
    }
}

