/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.ui.internal.views;

import org.eclipse.codewind.core.internal.CodewindApplication;
import org.eclipse.codewind.core.internal.CodewindManager;
import org.eclipse.codewind.core.internal.InstallStatus;
import org.eclipse.codewind.core.internal.InstallUtil;
import org.eclipse.codewind.core.internal.connection.CodewindConnection;
import org.eclipse.codewind.core.internal.constants.AppStatus;
import org.eclipse.codewind.core.internal.constants.BuildStatus;
import org.eclipse.codewind.core.internal.constants.ProjectLanguage;
import org.eclipse.codewind.core.internal.constants.ProjectType;
import org.eclipse.codewind.ui.CodewindUIPlugin;
import org.eclipse.codewind.ui.internal.messages.Messages;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.navigator.IDescriptionProvider;

public class CodewindNavigatorLabelProvider
extends LabelProvider
implements DelegatingStyledCellLabelProvider.IStyledLabelProvider,
IDescriptionProvider {
    static final StyledString.Styler BOLD_FONT_STYLER = new BoldFontStyler();
    public static final StyledString.Styler ERROR_STYLER = StyledString.createColorRegistryStyler((String)"ERROR_COLOR", null);
    public static StyledString.Styler LINK_STYLER = new StyledString.Styler(){

        public void applyStyles(TextStyle textStyle) {
            textStyle.underline = true;
        }
    };

    /*
     * Enabled aggressive block sorting
     */
    public String getText(Object element) {
        if (element instanceof CodewindManager) {
            CodewindManager manager = (CodewindManager)element;
            if (manager.getInstallerStatus() != null) {
                switch (manager.getInstallerStatus()) {
                    case INSTALLING: {
                        return Messages.CodewindLabel + "[" + Messages.CodewindInstallingQualifier + "]";
                    }
                    case UNINSTALLING: {
                        return Messages.CodewindLabel + "[" + Messages.CodewindUninstallingQualifier + "]";
                    }
                    case STARTING: {
                        return Messages.CodewindLabel + "[" + Messages.CodewindStartingQualifier + "]";
                    }
                    case STOPPING: {
                        return Messages.CodewindLabel + "[" + Messages.CodewindStoppingQualifier + "]";
                    }
                }
                return super.getText(element);
            }
            InstallStatus status = manager.getInstallStatus();
            if (status.isStarted()) {
                return Messages.CodewindLabel + " [" + Messages.CodewindRunningQualifier + "]";
            }
            if (status.isInstalled()) {
                if (!status.hasStartedVersions()) return Messages.CodewindLabel + " [" + Messages.CodewindNotStartedQualifier + "] (" + Messages.CodewindNotStartedMsg + ")";
                return Messages.CodewindLabel + "[" + NLS.bind((String)Messages.CodewindWrongVersionQualifier, (Object)status.getStartedVersions()) + "] (" + NLS.bind((String)Messages.CodewindWrongVersionMsg, (Object)InstallUtil.getVersion());
            }
            if (status.hasInstalledVersions()) {
                return Messages.CodewindLabel + "[" + NLS.bind((String)Messages.CodewindWrongVersionQualifier, (Object)status.getInstalledVersions()) + "] (" + NLS.bind((String)Messages.CodewindWrongVersionMsg, (Object)InstallUtil.getVersion());
            }
            if (!status.isUnknown()) return Messages.CodewindLabel + " [" + Messages.CodewindErrorQualifier + "] (" + Messages.CodewindErrorMsg + ")";
            return Messages.CodewindLabel + " [" + Messages.CodewindErrorQualifier + "] (" + Messages.CodewindErrorMsg + ")";
        }
        if (element instanceof CodewindConnection) {
            CodewindConnection connection = (CodewindConnection)element;
            String text = null;
            text = connection.baseUrl.equals(CodewindManager.getManager().getLocalURI()) ? Messages.CodewindLocalProjects : Messages.CodewindConnectionLabel + " " + connection.baseUrl;
            if (connection.isConnected()) {
                if (connection.getApps().size() != 0) return text;
                return text + " (" + Messages.CodewindConnectionNoProjects + ")";
            }
            String errorMsg = connection.getConnectionErrorMsg();
            if (errorMsg != null) return text + " (" + errorMsg + ")";
            errorMsg = Messages.CodewindDisconnected;
            return text + " (" + errorMsg + ")";
        }
        if (!(element instanceof CodewindApplication)) return super.getText(element);
        CodewindApplication app = (CodewindApplication)element;
        StringBuilder builder = new StringBuilder(app.name);
        if (!app.isEnabled()) {
            builder.append(" [" + Messages.CodewindProjectDisabled + "]");
            return builder.toString();
        }
        AppStatus appStatus = app.getAppStatus();
        String displayString = appStatus.getDisplayString(app.getStartMode());
        builder.append(" [" + displayString + "]");
        BuildStatus buildStatus = app.getBuildStatus();
        String buildDetails = app.getBuildDetails();
        if (buildDetails != null && !buildDetails.isEmpty()) {
            builder.append(" [" + buildStatus.getDisplayString() + ": " + buildDetails + "]");
            return builder.toString();
        }
        builder.append(" [" + buildStatus.getDisplayString() + "]");
        return builder.toString();
    }

    public StyledString getStyledText(Object element) {
        StyledString styledString;
        if (element instanceof CodewindManager) {
            CodewindManager manager = (CodewindManager)element;
            styledString = new StyledString(Messages.CodewindLabel);
            if (manager.getInstallerStatus() != null) {
                switch (manager.getInstallerStatus()) {
                    case INSTALLING: {
                        styledString.append(" [" + Messages.CodewindInstallingQualifier + "]", StyledString.DECORATIONS_STYLER);
                        break;
                    }
                    case UNINSTALLING: {
                        styledString.append(" [" + Messages.CodewindUninstallingQualifier + "]", StyledString.DECORATIONS_STYLER);
                        break;
                    }
                    case STARTING: {
                        styledString.append(" [" + Messages.CodewindStartingQualifier + "]", StyledString.DECORATIONS_STYLER);
                        break;
                    }
                    case STOPPING: {
                        styledString.append(" [" + Messages.CodewindStoppingQualifier + "]", StyledString.DECORATIONS_STYLER);
                    }
                }
            } else {
                InstallStatus status = manager.getInstallStatus();
                if (status.isStarted()) {
                    styledString.append(" [" + Messages.CodewindRunningQualifier + "]", StyledString.DECORATIONS_STYLER);
                } else if (status.isInstalled()) {
                    if (status.hasStartedVersions()) {
                        styledString.append(" [" + NLS.bind((String)Messages.CodewindWrongVersionQualifier, (Object)status.getStartedVersions()) + "]", StyledString.DECORATIONS_STYLER);
                        styledString.append(" (" + NLS.bind((String)Messages.CodewindWrongVersionMsg, (Object)InstallUtil.getVersion()) + ")", StyledString.QUALIFIER_STYLER);
                    } else {
                        styledString.append(" [" + Messages.CodewindNotStartedQualifier + "]", StyledString.DECORATIONS_STYLER);
                        styledString.append(" (" + Messages.CodewindNotStartedMsg + ")", StyledString.QUALIFIER_STYLER);
                    }
                } else if (status.hasInstalledVersions()) {
                    styledString.append(" [" + NLS.bind((String)Messages.CodewindWrongVersionQualifier, (Object)status.getInstalledVersions()) + "]", StyledString.DECORATIONS_STYLER);
                    styledString.append(" (" + NLS.bind((String)Messages.CodewindWrongVersionMsg, (Object)InstallUtil.getVersion()) + ")", StyledString.QUALIFIER_STYLER);
                } else if (status.isUnknown()) {
                    styledString.append(" [" + Messages.CodewindErrorQualifier + "]", StyledString.DECORATIONS_STYLER);
                    styledString.append(" (" + Messages.CodewindErrorMsg + ")", ERROR_STYLER);
                } else {
                    styledString.append(" [" + Messages.CodewindNotInstalledQualifier + "]", StyledString.DECORATIONS_STYLER);
                    styledString.append(" (" + Messages.CodewindNotInstalledMsg + ")", StyledString.QUALIFIER_STYLER);
                }
            }
        } else if (element instanceof CodewindConnection) {
            CodewindConnection connection = (CodewindConnection)element;
            if (connection.baseUrl.equals(CodewindManager.getManager().getLocalURI())) {
                styledString = new StyledString(Messages.CodewindLocalProjects);
            } else {
                styledString = new StyledString(Messages.CodewindConnectionLabel + " ");
                styledString.append(connection.baseUrl.toString(), StyledString.QUALIFIER_STYLER);
            }
            if (!connection.isConnected()) {
                String errorMsg = connection.getConnectionErrorMsg();
                if (errorMsg == null) {
                    errorMsg = Messages.CodewindDisconnected;
                }
                styledString.append(" (" + errorMsg + ")", ERROR_STYLER);
            } else if (connection.getApps().size() == 0) {
                styledString.append(" (" + Messages.CodewindConnectionNoProjects + ")", StyledString.DECORATIONS_STYLER);
            }
        } else if (element instanceof CodewindApplication) {
            CodewindApplication app = (CodewindApplication)element;
            styledString = new StyledString(app.name);
            if (app.isEnabled()) {
                AppStatus appStatus = app.getAppStatus();
                String displayString = appStatus.getDisplayString(app.getStartMode());
                styledString.append(" [" + displayString + "]", StyledString.DECORATIONS_STYLER);
                BuildStatus buildStatus = app.getBuildStatus();
                String buildDetails = app.getBuildDetails();
                if (buildDetails != null) {
                    styledString.append(" [" + buildStatus.getDisplayString() + ": ", StyledString.DECORATIONS_STYLER);
                    styledString.append(buildDetails, StyledString.QUALIFIER_STYLER);
                    styledString.append("]", StyledString.DECORATIONS_STYLER);
                } else {
                    styledString.append(" [" + buildStatus.getDisplayString() + "]", StyledString.DECORATIONS_STYLER);
                }
            } else {
                styledString.append(" [" + Messages.CodewindProjectDisabled + "]", StyledString.DECORATIONS_STYLER);
            }
        } else {
            styledString = new StyledString(this.getText(element));
        }
        return styledString;
    }

    public Image getImage(Object element) {
        if (element instanceof CodewindManager) {
            return CodewindUIPlugin.getImage("codewind.ico");
        }
        if (element instanceof CodewindConnection) {
            return CodewindUIPlugin.getImage("obj16/projects.png");
        }
        if (element instanceof CodewindApplication) {
            ProjectType type = ((CodewindApplication)element).projectType;
            if (type == ProjectType.TYPE_LIBERTY) {
                return CodewindUIPlugin.getImage("obj16/microprofile.png");
            }
            if (type == ProjectType.TYPE_NODEJS) {
                return CodewindUIPlugin.getImage("obj16/nodejs.png");
            }
            if (type == ProjectType.TYPE_SPRING) {
                return CodewindUIPlugin.getImage("obj16/spring.png");
            }
            if (type == ProjectType.TYPE_SWIFT) {
                return CodewindUIPlugin.getImage("obj16/swift.png");
            }
            ProjectLanguage lang = ((CodewindApplication)element).projectLanguage;
            switch (lang) {
                case LANGUAGE_GO: {
                    return CodewindUIPlugin.getImage("obj16/go.png");
                }
                case LANGUAGE_JAVA: {
                    return CodewindUIPlugin.getImage("obj16/java.png");
                }
                case LANGUAGE_NODEJS: {
                    return CodewindUIPlugin.getImage("obj16/nodejs.png");
                }
                case LANGUAGE_PYTHON: {
                    return CodewindUIPlugin.getImage("obj16/python.png");
                }
            }
            return CodewindUIPlugin.getImage("obj16/cloud.png");
        }
        return null;
    }

    public String getDescription(Object element) {
        if (element instanceof CodewindApplication) {
            CodewindApplication app = (CodewindApplication)element;
            if (app.getAppStatusDetails() != null) {
                return app.getAppStatusDetails();
            }
            if (app.getRootUrl() != null && (app.getAppStatus() == AppStatus.STARTING || app.getAppStatus() == AppStatus.STARTED)) {
                return NLS.bind((String)Messages.CodewindDescriptionContextRoot, (Object)app.getRootUrl());
            }
        }
        return null;
    }

    static class BoldFontStyler
    extends StyledString.Styler {
        BoldFontStyler() {
        }

        public void applyStyles(TextStyle textStyle) {
            Font boldFont;
            FontDescriptor boldDescriptor = FontDescriptor.createFrom((FontData)new FontData()).setStyle(1);
            textStyle.font = boldFont = boldDescriptor.createFont((Device)Display.getCurrent());
        }
    }
}

