/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.ui.internal.views;

import java.util.HashMap;
import java.util.List;
import org.eclipse.codewind.core.internal.CodewindApplication;
import org.eclipse.codewind.core.internal.IUpdateHandler;
import org.eclipse.codewind.core.internal.connection.CodewindConnection;
import org.eclipse.codewind.ui.internal.views.ViewHelper;

public class UpdateHandler
implements IUpdateHandler {
    private HashMap<AppKey, AppUpdateListener> appListeners = new HashMap();

    public void updateAll() {
        ViewHelper.refreshCodewindExplorerView(null);
    }

    public void updateConnection(CodewindConnection connection) {
        ViewHelper.refreshCodewindExplorerView(connection);
        ViewHelper.expandConnection(connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateApplication(CodewindApplication app) {
        ViewHelper.refreshCodewindExplorerView(app);
        ViewHelper.expandConnection(app.connection);
        HashMap<AppKey, AppUpdateListener> hashMap = this.appListeners;
        synchronized (hashMap) {
            AppUpdateListener listener = this.appListeners.get(new AppKey(app));
            if (listener != null) {
                listener.update();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnection(List<CodewindApplication> apps) {
        ViewHelper.refreshCodewindExplorerView(null);
        HashMap<AppKey, AppUpdateListener> hashMap = this.appListeners;
        synchronized (hashMap) {
            for (CodewindApplication app : apps) {
                AppUpdateListener listener = this.appListeners.get(new AppKey(app));
                if (listener == null) continue;
                listener.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeApplication(CodewindApplication app) {
        ViewHelper.refreshCodewindExplorerView(app.connection);
        ViewHelper.expandConnection(app.connection);
        HashMap<AppKey, AppUpdateListener> hashMap = this.appListeners;
        synchronized (hashMap) {
            AppUpdateListener listener = this.appListeners.get(new AppKey(app));
            if (listener != null) {
                listener.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAppUpdateListener(CodewindConnection conn, String projectID, AppUpdateListener listener) {
        HashMap<AppKey, AppUpdateListener> hashMap = this.appListeners;
        synchronized (hashMap) {
            this.appListeners.put(new AppKey(conn, projectID), listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAppUpdateListener(CodewindConnection conn, String projectID) {
        HashMap<AppKey, AppUpdateListener> hashMap = this.appListeners;
        synchronized (hashMap) {
            this.appListeners.remove(new AppKey(conn, projectID));
        }
    }

    private class AppKey {
        public final String connectionURI;
        public final String projectID;

        public AppKey(CodewindApplication app) {
            this(app.connection, app.projectID);
        }

        public AppKey(CodewindConnection conn, String projectID) {
            this.connectionURI = conn.baseUrl.toString();
            this.projectID = projectID;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof AppKey)) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            AppKey key = (AppKey)obj;
            return this.connectionURI.equals(key.connectionURI) && this.projectID.equals(key.projectID);
        }

        public int hashCode() {
            return this.connectionURI.hashCode() * this.projectID.hashCode();
        }
    }

    public static interface AppUpdateListener {
        public void update();

        public void remove();
    }
}

