/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.ui.internal.wizards;

import org.eclipse.codewind.core.CodewindCorePlugin;
import org.eclipse.codewind.core.internal.CodewindApplication;
import org.eclipse.codewind.core.internal.InstallUtil;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.core.internal.connection.CodewindConnection;
import org.eclipse.codewind.core.internal.connection.ProjectTypeInfo;
import org.eclipse.codewind.core.internal.constants.ProjectInfo;
import org.eclipse.codewind.ui.CodewindUIPlugin;
import org.eclipse.codewind.ui.internal.actions.ImportProjectAction;
import org.eclipse.codewind.ui.internal.actions.OpenAppOverviewAction;
import org.eclipse.codewind.ui.internal.messages.Messages;
import org.eclipse.codewind.ui.internal.wizards.ProjectSelectionPage;
import org.eclipse.codewind.ui.internal.wizards.ProjectTypeSelectionPage;
import org.eclipse.codewind.ui.internal.wizards.ProjectValidationPage;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class BindProjectWizard
extends Wizard
implements INewWizard {
    private ProjectSelectionPage projectPage;
    private ProjectValidationPage projectValidationPage;
    private ProjectTypeSelectionPage projectTypePage;
    private final CodewindConnection connection;
    private IPath projectPath = null;

    public BindProjectWizard(CodewindConnection connection) {
        this(connection, null);
    }

    public BindProjectWizard(CodewindConnection connection, IPath projectPath) {
        this.connection = connection;
        this.projectPath = projectPath;
        this.setNeedsProgressMonitor(true);
        this.setDefaultPageImageDescriptor(CodewindUIPlugin.getImageDescriptor("codewindBanner.png"));
        this.setHelpAvailable(false);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public void addPages() {
        this.setWindowTitle(Messages.BindProjectWizardTitle);
        if (this.projectPath == null) {
            this.projectPage = new ProjectSelectionPage(this, this.connection);
            this.addPage((IWizardPage)this.projectPage);
        }
        this.projectValidationPage = new ProjectValidationPage(this, this.connection, this.projectPath);
        this.projectTypePage = new ProjectTypeSelectionPage(this.connection);
        this.addPage((IWizardPage)this.projectValidationPage);
        this.addPage((IWizardPage)this.projectTypePage);
    }

    public boolean canFinish() {
        if (this.projectPage != null && !this.projectPage.canFinish()) {
            return false;
        }
        if (this.projectValidationPage.isActivePage() && this.projectValidationPage.canFinish()) {
            return true;
        }
        return this.projectTypePage.isActivePage() && this.projectTypePage.canFinish();
    }

    public boolean performCancel() {
        return true;
    }

    public boolean performFinish() {
        if (!this.canFinish()) {
            return false;
        }
        if (this.projectPage != null) {
            this.projectPath = this.projectPage.getProjectPath();
        }
        final String name = this.projectPath.lastSegment();
        final ProjectInfo projectInfo = this.projectValidationPage.isActivePage() ? this.projectValidationPage.getProjectInfo() : null;
        final ProjectTypeInfo type = this.projectTypePage.getType();
        final ProjectTypeInfo.ProjectSubtypeInfo projectSubtype = this.projectTypePage.getSubtype();
        final String language = this.projectTypePage.getLanguage();
        Job job = new Job(NLS.bind((String)Messages.BindProjectWizardJobLabel, (Object)name)){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    String path = BindProjectWizard.this.projectPath.toFile().getAbsolutePath();
                    if (projectInfo != null) {
                        BindProjectWizard.this.connection.requestProjectBind(name, path, projectInfo.language.getId(), projectInfo.type.getId());
                    } else {
                        if (projectSubtype != null) {
                            InstallUtil.validateProject((String)name, (String)path, (String)(type + ":" + projectSubtype.id), (IProgressMonitor)monitor);
                        }
                        BindProjectWizard.this.connection.requestProjectBind(name, path, language, type.getId());
                    }
                    BindProjectWizard.this.connection.refreshApps(null);
                    CodewindApplication app = BindProjectWizard.this.connection.getAppByName(name);
                    if (app != null) {
                        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
                        if (project == null || !project.exists()) {
                            ImportProjectAction.importProject(app);
                        }
                        if (CodewindCorePlugin.getDefault().getPreferenceStore().getBoolean("autoOpenOverviewPage")) {
                            Display.getDefault().asyncExec(() -> OpenAppOverviewAction.openAppOverview(app));
                        }
                    }
                    return Status.OK_STATUS;
                }
                catch (Exception e) {
                    Logger.logError((String)("An error occured trying to add the project to Codewind: " + BindProjectWizard.this.projectPath.toOSString()), (Throwable)e);
                    return new Status(4, "org.eclipse.codewind.ui", NLS.bind((String)Messages.BindProjectWizardError, (Object)BindProjectWizard.this.projectPath.toOSString()), (Throwable)e);
                }
            }
        };
        job.schedule();
        return true;
    }

    public void setProjectInfo(ProjectInfo projectInfo) {
        if (this.projectTypePage != null) {
            this.projectTypePage.setProjectInfo(projectInfo);
        }
    }

    public void setProjectPath(IPath projectPath) {
        if (this.projectValidationPage != null) {
            this.projectValidationPage.setProjectPath(projectPath, true);
        }
    }
}

