/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.openapi.ui.handlers;

import java.lang.reflect.Field;
import org.eclipse.codewind.openapi.ui.Activator;
import org.eclipse.codewind.openapi.ui.Constants;
import org.eclipse.codewind.openapi.ui.Messages;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;

public abstract class AbstractGenerateCommandHandler
extends AbstractHandler {
    protected abstract IWizardPage getWizardPage(ISelection var1);

    protected abstract INewWizard getWizard(ISelection var1);

    protected IProject getIProject(ExecutionEvent event) {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        String projectName = null;
        if (selection instanceof TreeSelection) {
            TreeSelection ts = (TreeSelection)selection;
            Object obj = ts.getFirstElement();
            Class<?> clazz = obj.getClass();
            try {
                Field field = clazz.getField("name");
                Object object = field.get(obj);
                if (object instanceof String) {
                    projectName = (String)object;
                }
            }
            catch (Exception e) {
                Activator.log(1, e.getMessage());
            }
        }
        if (projectName != null) {
            return ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        }
        return null;
    }

    protected Object invokeWizard(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event);
        ISelection currentSelection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        String activePartId = HandlerUtil.getActivePartId((ExecutionEvent)event);
        if (activePartId.equals(Constants.CODEWIND_EXPLORER_VIEW)) {
            IProject codewindProject = this.getIProject(event);
            if (codewindProject == null || !codewindProject.exists() && activePartId.equals(Constants.CODEWIND_EXPLORER_VIEW)) {
                MessageDialog.openInformation((Shell)window.getShell(), (String)Messages.INFO_OPENAPI_TITLE, (String)Messages.INFO_PROJECT_NOT_IMPORTED);
                return null;
            }
            if (currentSelection instanceof TreeSelection) {
                TreeSelection ts = (TreeSelection)currentSelection;
                currentSelection = new StructuredSelection(ts.getFirstElement());
            }
        }
        if (currentSelection == null) {
            MessageDialog.openInformation((Shell)window.getShell(), (String)Messages.INFO_OPENAPI_TITLE, (String)Messages.INFO_INVALID_SELECTION);
            return null;
        }
        INewWizard wiz = this.getWizard(currentSelection);
        WizardDialog wizardDialog = new WizardDialog(window.getShell(), (IWizard)wiz);
        wizardDialog.open();
        return null;
    }
}

