/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.openapi.core.util;

import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.eclipse.codewind.openapi.core.Activator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.json.JSONObject;
import org.json.JSONTokener;

public class Util {
    private static String UNKNOWN_LANGUAGE = "unknown";

    public static boolean isCodewindProject(IProject project) {
        return project.getFile(".cw-settings").exists();
    }

    public static String getProjectLanguage(IProject project) {
        String projectName;
        IPath location = project.getLocation();
        IPath dotProjectFolder = location.append("../.projects");
        IPath projectInfFile = dotProjectFolder.append((projectName = project.getName()) + ".inf");
        File f = projectInfFile.toFile();
        if (f.exists()) {
            try {
                JSONTokener tokenizer = new JSONTokener((Reader)new FileReader(f));
                JSONObject jobj = new JSONObject(tokenizer);
                Object object = jobj.get("language");
                if (object != null) {
                    String lang = object.toString();
                    if (UNKNOWN_LANGUAGE.equals(lang)) {
                        lang = "";
                    }
                    return lang;
                }
            }
            catch (Exception e) {
                Activator.log(1, "Cannot find the metadata file for the project");
            }
        } else {
            File dotProjectFolderFile = dotProjectFolder.toFile();
            if (dotProjectFolderFile.isDirectory()) {
                for (File aFile : dotProjectFolderFile.listFiles()) {
                    try {
                        Object object;
                        String name;
                        JSONTokener tokenizer;
                        JSONObject jobj;
                        Object nameObject;
                        if (aFile.isFile() && (nameObject = (jobj = new JSONObject(tokenizer = new JSONTokener((Reader)new FileReader(aFile)))).get("name")) != null && projectName.contentEquals(name = nameObject.toString()) && (object = jobj.get("language")) != null) {
                            String lang = object.toString();
                            if (UNKNOWN_LANGUAGE.equals(lang)) {
                                lang = "";
                            }
                            return lang;
                        }
                    }
                    catch (Exception e) {
                        Activator.log(1, "Cannot find language for the project");
                    }
                }
            }
        }
        return "";
    }

    public static boolean isImported(Object obj) {
        Class<?> clazz = obj.getClass();
        try {
            Field field = clazz.getField("fullLocalPath");
            Field nameField = clazz.getField("name");
            Object object = field.get(obj);
            Object nObj = nameField.get(obj);
            if (nObj instanceof String) {
                String pName = (String)nObj;
                IResource proj = ResourcesPlugin.getWorkspace().getRoot().findMember(pName);
                if (proj == null) {
                    return false;
                }
                IPath location = proj.getLocation();
                if (object instanceof IPath) {
                    IPath pat = (IPath)object;
                    if (location.toString().equals(pat.toString())) {
                        return proj.isAccessible();
                    }
                }
            }
        }
        catch (Exception e) {
            Activator.log(1, e);
        }
        return false;
    }

    public static String getProjectLanguage(Object obj) {
        Class<?> clazz = obj.getClass();
        try {
            Field field = clazz.getField("projectLanguage");
            Object projectLanguageObject = field.get(obj);
            Class<?> projectLanguageClass = projectLanguageObject.getClass();
            Method getIdMethod = projectLanguageClass.getMethod("getId", new Class[0]);
            Object languageObject = getIdMethod.invoke(projectLanguageObject, new Object[0]);
            if (languageObject instanceof String) {
                String language = (String)languageObject;
                if (UNKNOWN_LANGUAGE.equals(language)) {
                    language = "";
                }
                return language;
            }
        }
        catch (Exception e) {
            Activator.log(4, e);
        }
        return "";
    }

    public static IProject getProject(Object obj) {
        Class<?> clazz = obj.getClass();
        String projectName = null;
        try {
            Field field = clazz.getField("name");
            Object object = field.get(obj);
            if (object instanceof String) {
                projectName = (String)object;
            }
        }
        catch (Exception e) {
            Activator.log(4, e);
        }
        if (projectName != null) {
            return ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        }
        return null;
    }
}

