/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.core.internal.connection;

import java.net.URI;
import org.eclipse.codewind.core.internal.CodewindObjectFactory;
import org.eclipse.codewind.core.internal.CoreUtil;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.core.internal.connection.CodewindConnection;
import org.eclipse.codewind.core.internal.connection.CodewindConnectionException;
import org.eclipse.codewind.core.internal.connection.CodewindConnectionManager;
import org.eclipse.codewind.core.internal.messages.Messages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ICoreRunnable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;

public class CodewindReconnectJob {
    static void createAndStart(final URI url) {
        final String msg = NLS.bind((String)Messages.ReconnectJob_ReconnectJobName, (Object)url);
        Job reconnectJob = Job.create((String)msg, (ICoreRunnable)new ICoreRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                monitor.beginTask(msg, 100);
                while (!monitor.isCanceled() && CodewindConnectionManager.brokenConnections().contains(url.toString())) {
                    boolean deleted;
                    this.tryReconnect(monitor);
                    if (!monitor.isCanceled() || (deleted = CodewindConnectionManager.removeConnection(url.toString()))) continue;
                    CodewindReconnectJob.createAndStart(url);
                }
                Logger.log("Done waiting for Codewind reconnect - monitor is canceled? " + monitor.isCanceled());
                monitor.done();
            }

            private void tryReconnect(IProgressMonitor monitor) {
                int delay = 5000;
                try {
                    Thread.sleep(5000L);
                    Logger.log("Trying to reconnect to Codewind at " + url);
                    CodewindConnection newConnection = CodewindObjectFactory.createCodewindConnection(url);
                    if (newConnection != null) {
                        Logger.log("Successfully re-connected to Codewind at " + url);
                        CodewindConnectionManager.remove(url.toString());
                        CodewindConnectionManager.add(newConnection);
                        return;
                    }
                }
                catch (InterruptedException e) {
                    Logger.logError(e);
                }
                catch (CodewindConnectionException e) {
                }
                catch (Exception e) {
                    Logger.logError(e);
                    monitor.setCanceled(true);
                    CoreUtil.openDialog(true, Messages.ReconnectJob_ReconnectErrorDialogTitle, NLS.bind((String)Messages.ReconnectJob_ReconnectErrorDialogMsg, (Object)url));
                }
            }
        });
        reconnectJob.schedule();
    }
}

