/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.core.internal.console;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.eclipse.codewind.core.CodewindCorePlugin;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.core.internal.console.FileConsoleMonitorThread;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ui.console.IOConsole;
import org.eclipse.ui.console.IOConsoleOutputStream;

public class FileConsole
extends IOConsole {
    private final FileConsoleMonitorThread logMonitorThread;
    private final IOConsoleOutputStream outputStream;

    public FileConsole(String consoleName, IPath logFilePath) throws FileNotFoundException {
        super(consoleName, "codewind-console", CodewindCorePlugin.getIcon("icons/codewind.ico"), true);
        File logFile = new File(logFilePath.toOSString());
        if (!logFile.exists()) {
            throw new FileNotFoundException(logFile.getAbsolutePath() + " does not exist");
        }
        this.outputStream = this.newOutputStream();
        this.logMonitorThread = new FileConsoleMonitorThread(consoleName, logFile, this.outputStream);
        this.logMonitorThread.start();
    }

    protected void dispose() {
        Logger.log("Dispose console " + this.getName());
        this.logMonitorThread.disable();
        this.logMonitorThread.interrupt();
        try {
            this.outputStream.close();
        }
        catch (IOException e) {
            Logger.logError("Error closing console output stream", e);
        }
        super.dispose();
    }
}

