/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.core.internal.launch;

import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import java.io.IOException;
import org.eclipse.codewind.core.internal.CodewindApplication;
import org.eclipse.codewind.core.internal.CoreUtil;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.core.internal.launch.CodewindDebugConnector;
import org.eclipse.codewind.core.internal.messages.Messages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.jdt.launching.AbstractJavaLaunchConfigurationDelegate;

public class CodewindLaunchConfigDelegate
extends AbstractJavaLaunchConfigurationDelegate {
    public static final String LAUNCH_CONFIG_ID = "org.eclipse.codewind.core.internal.launchConfigurationType";
    public static final String PROJECT_NAME_ATTR = "org.eclipse.codewind.core.internal.projectNameAttr";
    public static final String HOST_ATTR = "org.eclipse.codewind.core.internal.hostAttr";
    public static final String DEBUG_PORT_ATTR = "org.eclipse.codewind.core.internal.debugPort";

    public void launch(ILaunchConfiguration config, String launchMode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        try {
            this.launchInner(config, launchMode, launch, monitor);
        }
        catch (CoreException e) {
            monitor.setCanceled(true);
            this.getLaunchManager().removeLaunch(launch);
            throw e;
        }
    }

    private void launchInner(ILaunchConfiguration config, String launchMode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        String projectName = config.getAttribute(PROJECT_NAME_ATTR, (String)null);
        String host = config.getAttribute(HOST_ATTR, (String)null);
        int debugPort = config.getAttribute(DEBUG_PORT_ATTR, -1);
        if (projectName == null || host == null || debugPort <= 0) {
            String msg = "The launch configuration did not contain the required attributes: " + config.getName();
            Logger.logError(msg);
            this.abort(msg, null, 4);
        }
        this.setDefaultSourceLocator(launch, config);
        Logger.log("Connecting the debugger");
        try {
            IDebugTarget debugTarget = CodewindDebugConnector.connectDebugger(launch, monitor);
            if (debugTarget != null) {
                Logger.log("Debugger connect success. Application should go into Debugging state soon.");
                launch.addDebugTarget(debugTarget);
            } else {
                Logger.logError("Debugger connect failure");
                CoreUtil.openDialog(true, Messages.DebuggerConnectFailureDialogTitle, Messages.DebuggerConnectFailureDialogMsg);
            }
        }
        catch (IllegalConnectorArgumentsException | IOException | CoreException e) {
            Logger.logError(e);
        }
        monitor.done();
    }

    public static void setConfigAttributes(ILaunchConfigurationWorkingCopy config, CodewindApplication app) {
        config.setAttribute(PROJECT_NAME_ATTR, app.name);
        config.setAttribute(HOST_ATTR, app.host);
        config.setAttribute(DEBUG_PORT_ATTR, app.getDebugPort());
    }
}

