/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.ui.internal.actions;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.TimeoutException;
import org.eclipse.codewind.core.internal.CodewindManager;
import org.eclipse.codewind.core.internal.CoreUtil;
import org.eclipse.codewind.core.internal.InstallStatus;
import org.eclipse.codewind.core.internal.InstallUtil;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.core.internal.PlatformUtil;
import org.eclipse.codewind.core.internal.ProcessHelper;
import org.eclipse.codewind.core.internal.connection.CodewindConnection;
import org.eclipse.codewind.core.internal.connection.CodewindConnectionManager;
import org.eclipse.codewind.ui.internal.actions.CodewindInstall;
import org.eclipse.codewind.ui.internal.messages.Messages;
import org.eclipse.codewind.ui.internal.views.ViewHelper;
import org.eclipse.codewind.ui.internal.wizards.BindProjectWizard;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class BindProjectAction
implements IObjectActionDelegate {
    private IWorkbenchPart part;
    private IProject project;

    public void run(IAction action) {
        CodewindConnection connection = null;
        if (this.project == null) {
            Logger.logError((String)"BindProjectAction ran but no project was selected");
            return;
        }
        final CodewindManager.InstallerStatus installerStatus = CodewindManager.getManager().getInstallerStatus();
        if (installerStatus != null) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    CodewindInstall.installerActiveDialog(installerStatus);
                }
            });
            return;
        }
        if (!CodewindManager.getManager().getInstallStatus().isInstalled()) {
            CodewindInstall.codewindInstallerDialog(this.project);
            return;
        }
        connection = this.setupConnection();
        if (connection == null || !connection.isConnected()) {
            CoreUtil.openDialog((boolean)true, (String)Messages.BindProjectErrorTitle, (String)Messages.BindProjectConnectionError);
            return;
        }
        String projectError = this.getProjectError(connection, this.project);
        if (projectError != null) {
            CoreUtil.openDialog((boolean)true, (String)Messages.BindProjectErrorTitle, (String)projectError);
            if (CodewindConnectionManager.getActiveConnection((String)connection.baseUrl.toString()) == null) {
                connection.close();
            }
            return;
        }
        BindProjectWizard wizard = new BindProjectWizard(connection, this.project.getLocation());
        WizardDialog dialog = new WizardDialog(Display.getDefault().getActiveShell(), (IWizard)wizard);
        if (dialog.open() == 1) {
            if (CodewindConnectionManager.getActiveConnection((String)connection.baseUrl.toString()) == null) {
                connection.close();
            }
        } else {
            if (CodewindConnectionManager.getActiveConnection((String)connection.baseUrl.toString()) == null) {
                CodewindConnectionManager.add((CodewindConnection)connection);
            }
            ViewHelper.openCodewindExplorerView();
            ViewHelper.refreshCodewindExplorerView(null);
            ViewHelper.expandConnection(connection);
        }
    }

    private String getProjectError(CodewindConnection connection, IProject project) {
        if (connection.getAppByName(project.getName()) != null) {
            return NLS.bind((String)Messages.BindProjectAlreadyExistsError, (Object)project.getName());
        }
        IPath workspacePath = connection.getWorkspacePath();
        IPath projectPath = project.getLocation();
        if (PlatformUtil.getOS() == PlatformUtil.OperatingSystem.WINDOWS) {
            workspacePath = new Path(workspacePath.toPortableString().toLowerCase());
            projectPath = new Path(projectPath.toPortableString().toLowerCase());
        }
        if (!workspacePath.isPrefixOf(projectPath)) {
            return NLS.bind((String)Messages.BindProjectBadLocationError, (Object)project.getName(), (Object)connection.getWorkspacePath().toOSString());
        }
        return null;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        Object obj;
        if (!(selection instanceof IStructuredSelection)) {
            action.setEnabled(false);
            return;
        }
        IStructuredSelection sel = (IStructuredSelection)selection;
        if (sel.size() == 1 && (obj = sel.getFirstElement()) instanceof IProject) {
            this.project = (IProject)obj;
            action.setEnabled(this.project.isAccessible());
            return;
        }
        action.setEnabled(false);
    }

    public void setActivePart(IAction action, IWorkbenchPart part) {
        this.part = part;
    }

    private CodewindConnection setupConnection() {
        final CodewindManager manager = CodewindManager.getManager();
        CodewindConnection connection = manager.getLocalConnection();
        if (connection != null && connection.isConnected()) {
            return connection;
        }
        final InstallStatus status = manager.getInstallStatus();
        if (status.isStarted()) {
            return manager.createLocalConnection();
        }
        if (!status.isInstalled()) {
            Logger.logError((String)"In BindProjectAction run method and Codewind is not installed or has unknown status.");
            return null;
        }
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    ProcessHelper.ProcessResult result = InstallUtil.startCodewind((String)status.getVersion(), (IProgressMonitor)monitor);
                    if (result.getExitValue() != 0) {
                        Logger.logError((String)("Installer start failed with return code: " + result.getExitValue() + ", output: " + result.getOutput() + ", error: " + result.getError()));
                        String errorText = result.getError() != null && !result.getError().isEmpty() ? result.getError() : result.getOutput();
                        throw new InvocationTargetException(null, "There was a problem trying to start Codewind: " + errorText);
                    }
                    manager.createLocalConnection();
                    ViewHelper.refreshCodewindExplorerView(null);
                }
                catch (IOException e) {
                    throw new InvocationTargetException(e, "An error occurred trying to start Codewind: " + e.getMessage());
                }
                catch (TimeoutException e) {
                    throw new InvocationTargetException(e, "Codewind did not start in the expected time: " + e.getMessage());
                }
            }
        };
        try {
            ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.part.getSite().getShell());
            dialog.run(true, true, runnable);
        }
        catch (InvocationTargetException e) {
            Logger.logError((String)"An error occurred trying to start Codewind", (Throwable)e);
            return null;
        }
        catch (InterruptedException e) {
            Logger.logError((String)"Codewind start was interrupted", (Throwable)e);
            return null;
        }
        return manager.getLocalConnection();
    }
}

