/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.ui.internal.actions;

import java.io.IOException;
import java.util.concurrent.TimeoutException;
import org.eclipse.codewind.core.CodewindCorePlugin;
import org.eclipse.codewind.core.internal.CodewindManager;
import org.eclipse.codewind.core.internal.InstallStatus;
import org.eclipse.codewind.core.internal.InstallUtil;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.core.internal.ProcessHelper;
import org.eclipse.codewind.core.internal.connection.CodewindConnection;
import org.eclipse.codewind.ui.internal.messages.Messages;
import org.eclipse.codewind.ui.internal.views.ViewHelper;
import org.eclipse.codewind.ui.internal.wizards.BindProjectWizard;
import org.eclipse.codewind.ui.internal.wizards.NewCodewindProjectWizard;
import org.eclipse.codewind.ui.internal.wizards.WizardLauncher;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class CodewindInstall {
    public static boolean ENABLE_STOP_APPS_OPTION = false;

    public static void codewindInstallerDialog() {
        CodewindInstall.codewindInstallerDialog(CodewindInstall.getNewProjectPrompt());
    }

    public static void codewindInstallerDialog(IProject project) {
        CodewindInstall.codewindInstallerDialog(CodewindInstall.addExistingProjectPrompt(project));
    }

    private static void codewindInstallerDialog(Runnable prompt) {
        InstallStatus status = CodewindManager.getManager().getInstallStatus();
        Shell shell = Display.getDefault().getActiveShell();
        if (status.hasInstalledVersions()) {
            if (MessageDialog.openQuestion((Shell)shell, (String)Messages.InstallCodewindDialogTitle, (String)Messages.UpgradeCodewindDialogMessage)) {
                CodewindInstall.updateCodewind(InstallUtil.getVersion(), true, prompt);
            }
        } else if (MessageDialog.openQuestion((Shell)shell, (String)Messages.InstallCodewindDialogTitle, (String)Messages.InstallCodewindDialogMessage)) {
            CodewindInstall.installCodewind(InstallUtil.getVersion(), prompt);
        }
    }

    public static void installerActiveDialog(CodewindManager.InstallerStatus status) {
        if (status == null) {
            Logger.logError((String)"The installerActiveDialog method is invoked but the installer status is null");
            return;
        }
        String msg = null;
        switch (status) {
            case INSTALLING: 
            case STARTING: {
                msg = Messages.InstallCodewindInstallingMessage;
                break;
            }
            case UNINSTALLING: 
            case STOPPING: {
                msg = Messages.InstallCodewindUninstallingMessage;
                break;
            }
            default: {
                Logger.logError((String)("The installerActiveDialog method is invoked but the installer status is not recognized: " + status));
                return;
            }
        }
        MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.InstallCodewindDialogTitle, (String)msg);
    }

    public static void installCodewind(final String version, final Runnable prompt) {
        try {
            Job job = new Job(Messages.InstallCodewindJobLabel){

                protected IStatus run(IProgressMonitor progressMon) {
                    try {
                        ProcessHelper.ProcessResult result;
                        SubMonitor mon = SubMonitor.convert((IProgressMonitor)progressMon, (int)100);
                        mon.setTaskName(Messages.InstallingCodewindTask);
                        try {
                            result = InstallUtil.installCodewind((String)version, (IProgressMonitor)mon.split(95));
                            if (mon.isCanceled()) {
                                CodewindInstall.removeCodewind(version);
                                return Status.CANCEL_STATUS;
                            }
                            if (result.getExitValue() != 0) {
                                return CodewindInstall.getErrorStatus(result, Messages.CodewindInstallFail);
                            }
                        }
                        catch (TimeoutException e) {
                            return CodewindInstall.getErrorStatus(Messages.CodewindInstallTimeout, e);
                        }
                        mon.setTaskName(Messages.StartingCodewindJobLabel);
                        try {
                            result = InstallUtil.startCodewind((String)version, (IProgressMonitor)mon.split(5));
                            if (mon.isCanceled()) {
                                CodewindInstall.removeCodewind(version);
                                return Status.CANCEL_STATUS;
                            }
                            if (result.getExitValue() != 0) {
                                return CodewindInstall.getErrorStatus(result, Messages.CodewindStartFail);
                            }
                        }
                        catch (TimeoutException e) {
                            return CodewindInstall.getErrorStatus(Messages.CodewindStartTimeout, e);
                        }
                        if (prompt != null) {
                            Display.getDefault().asyncExec(prompt);
                        }
                    }
                    catch (IOException e) {
                        return CodewindInstall.getErrorStatus(Messages.CodewindInstallError, e);
                    }
                    ViewHelper.refreshCodewindExplorerView(null);
                    return Status.OK_STATUS;
                }
            };
            job.setPriority(30);
            job.schedule();
        }
        catch (Exception e) {
            Logger.logError((String)"An error occurred installing Codewind: ", (Throwable)e);
        }
    }

    public static void startCodewind(final String version, final Runnable prompt) {
        try {
            Job job = new Job(Messages.StartingCodewindJobLabel){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        ProcessHelper.ProcessResult result = InstallUtil.startCodewind((String)version, (IProgressMonitor)monitor);
                        if (monitor.isCanceled()) {
                            return Status.CANCEL_STATUS;
                        }
                        if (result.getExitValue() != 0) {
                            return CodewindInstall.getErrorStatus(result, Messages.CodewindStartFail);
                        }
                        if (prompt != null) {
                            Display.getDefault().asyncExec(prompt);
                        }
                    }
                    catch (IOException e) {
                        return CodewindInstall.getErrorStatus(Messages.CodewindStartError, e);
                    }
                    catch (TimeoutException e) {
                        return CodewindInstall.getErrorStatus(Messages.CodewindStartTimeout, e);
                    }
                    ViewHelper.refreshCodewindExplorerView(null);
                    return Status.OK_STATUS;
                }
            };
            job.setPriority(30);
            job.schedule();
        }
        catch (Exception e) {
            Logger.logError((String)"An error occurred starting Codewind: ", (Throwable)e);
        }
    }

    public static void stopCodewind() {
        try {
            Job job = new Job(Messages.StoppingCodewindJobLabel){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        boolean stopAll = CodewindInstall.getStopAll(monitor);
                        if (monitor.isCanceled()) {
                            return Status.CANCEL_STATUS;
                        }
                        ProcessHelper.ProcessResult result = InstallUtil.stopCodewind((boolean)stopAll, (IProgressMonitor)monitor);
                        if (monitor.isCanceled()) {
                            return Status.CANCEL_STATUS;
                        }
                        if (result.getExitValue() != 0) {
                            return CodewindInstall.getErrorStatus(result, Messages.CodewindStopFail);
                        }
                    }
                    catch (IOException e) {
                        return CodewindInstall.getErrorStatus(Messages.CodewindStopError, e);
                    }
                    catch (TimeoutException e) {
                        return CodewindInstall.getErrorStatus(Messages.CodewindStopTimeout, e);
                    }
                    ViewHelper.refreshCodewindExplorerView(null);
                    return Status.OK_STATUS;
                }
            };
            job.setPriority(30);
            job.schedule();
        }
        catch (Exception e) {
            Logger.logError((String)"An error occurred stopping Codewind: ", (Throwable)e);
        }
    }

    public static Runnable getNewProjectPrompt() {
        return new Runnable(){

            @Override
            public void run() {
                Shell shell = Display.getDefault().getActiveShell();
                if (MessageDialog.openQuestion((Shell)shell, (String)Messages.InstallCodewindDialogTitle, (String)Messages.InstallCodewindNewProjectMessage)) {
                    NewCodewindProjectWizard wizard = new NewCodewindProjectWizard();
                    WizardLauncher.launchWizardWithoutSelection(wizard);
                }
            }
        };
    }

    public static Runnable addExistingProjectPrompt(final IProject project) {
        return new Runnable(){

            @Override
            public void run() {
                Shell shell = Display.getDefault().getActiveShell();
                if (MessageDialog.openQuestion((Shell)shell, (String)Messages.InstallCodewindDialogTitle, (String)NLS.bind((String)Messages.InstallCodewindAddProjectMessage, (Object)project.getName()))) {
                    CodewindManager manager = CodewindManager.getManager();
                    CodewindConnection connection = manager.createLocalConnection();
                    if (connection != null && connection.isConnected()) {
                        BindProjectWizard wizard = new BindProjectWizard(connection, project.getLocation());
                        WizardLauncher.launchWizardWithoutSelection(wizard);
                    } else {
                        Logger.logError((String)("Codewind not installed or has unknown status when trying to bind project: " + project.getName()));
                        return;
                    }
                }
            }
        };
    }

    public static void updateCodewind(final String version, final boolean removeOldVersion, final Runnable prompt) {
        try {
            Job job = new Job(Messages.UpdatingCodewindJobLabel){

                protected IStatus run(IProgressMonitor progressMon) {
                    SubMonitor mon = SubMonitor.convert((IProgressMonitor)progressMon, (int)200);
                    try {
                        ProcessHelper.ProcessResult result;
                        InstallStatus status = CodewindManager.getManager().getInstallStatus();
                        if (status.hasStartedVersions()) {
                            mon.setTaskName(Messages.StoppingCodewindJobLabel);
                            try {
                                result = InstallUtil.stopCodewind((boolean)true, (IProgressMonitor)mon.split(80));
                                if (mon.isCanceled()) {
                                    return Status.CANCEL_STATUS;
                                }
                                if (result.getExitValue() != 0) {
                                    return CodewindInstall.getErrorStatus(result, Messages.CodewindStopFail);
                                }
                            }
                            catch (TimeoutException e) {
                                return CodewindInstall.getErrorStatus(Messages.CodewindStopTimeout, e);
                            }
                        }
                        mon.setWorkRemaining(120);
                        if (removeOldVersion) {
                            mon.setTaskName(Messages.UninstallingCodewindTask);
                            try {
                                result = InstallUtil.removeCodewind(null, (IProgressMonitor)mon.split(20));
                                if (mon.isCanceled()) {
                                    return Status.CANCEL_STATUS;
                                }
                                if (result.getExitValue() != 0) {
                                    return CodewindInstall.getErrorStatus(result, Messages.CodewindUninstallFail);
                                }
                            }
                            catch (TimeoutException e) {
                                return CodewindInstall.getErrorStatus(Messages.CodewindUninstallTimeout, e);
                            }
                        }
                        mon.setWorkRemaining(100);
                        mon.setTaskName(Messages.InstallingCodewindTask);
                        try {
                            result = InstallUtil.installCodewind((String)version, (IProgressMonitor)mon.split(95));
                            if (mon.isCanceled()) {
                                CodewindInstall.removeCodewind(version);
                                return Status.CANCEL_STATUS;
                            }
                            if (result.getExitValue() != 0) {
                                return CodewindInstall.getErrorStatus(result, Messages.CodewindInstallFail);
                            }
                        }
                        catch (TimeoutException e) {
                            return CodewindInstall.getErrorStatus(Messages.CodewindInstallTimeout, e);
                        }
                        mon.setTaskName(Messages.StartingCodewindJobLabel);
                        try {
                            result = InstallUtil.startCodewind((String)version, (IProgressMonitor)mon.split(5));
                            if (mon.isCanceled()) {
                                CodewindInstall.removeCodewind(version);
                                return Status.CANCEL_STATUS;
                            }
                            if (result.getExitValue() != 0) {
                                return CodewindInstall.getErrorStatus(result, Messages.CodewindStartFail);
                            }
                        }
                        catch (TimeoutException e) {
                            return CodewindInstall.getErrorStatus(Messages.CodewindStartTimeout, e);
                        }
                        if (prompt != null) {
                            Display.getDefault().asyncExec(prompt);
                        }
                    }
                    catch (Exception e) {
                        return CodewindInstall.getErrorStatus(Messages.CodewindUpdateError, e);
                    }
                    ViewHelper.refreshCodewindExplorerView(null);
                    return Status.OK_STATUS;
                }
            };
            job.setPriority(30);
            job.schedule();
        }
        catch (Exception e) {
            Logger.logError((String)"An error occurred updating Codewind images: ", (Throwable)e);
        }
    }

    public static void removeCodewind(final String version) {
        try {
            Job job = new Job(Messages.RemovingCodewindJobLabel){

                protected IStatus run(IProgressMonitor progressMon) {
                    SubMonitor mon = SubMonitor.convert((IProgressMonitor)progressMon, (int)100);
                    try {
                        ProcessHelper.ProcessResult result;
                        InstallStatus status = CodewindManager.getManager().getInstallStatus();
                        if (status.isStarted()) {
                            mon.setTaskName(Messages.StoppingCodewindJobLabel);
                            try {
                                result = InstallUtil.stopCodewind((boolean)true, (IProgressMonitor)mon.split(80));
                                if (mon.isCanceled()) {
                                    return Status.CANCEL_STATUS;
                                }
                                if (result.getExitValue() != 0) {
                                    return CodewindInstall.getErrorStatus(result, Messages.CodewindStopFail);
                                }
                            }
                            catch (TimeoutException e) {
                                return CodewindInstall.getErrorStatus(Messages.CodewindStopTimeout, e);
                            }
                        }
                        if (mon.isCanceled()) {
                            return Status.CANCEL_STATUS;
                        }
                        mon.setTaskName(Messages.UninstallingCodewindTask);
                        mon.setWorkRemaining(20);
                        result = InstallUtil.removeCodewind((String)version, (IProgressMonitor)mon.split(20));
                        if (mon.isCanceled()) {
                            return Status.CANCEL_STATUS;
                        }
                        if (result.getExitValue() != 0) {
                            return CodewindInstall.getErrorStatus(result, Messages.CodewindUninstallFail);
                        }
                    }
                    catch (TimeoutException e) {
                        return CodewindInstall.getErrorStatus(Messages.CodewindUninstallTimeout, e);
                    }
                    catch (Exception e) {
                        return CodewindInstall.getErrorStatus(Messages.CodewindUninstallError, e);
                    }
                    ViewHelper.refreshCodewindExplorerView(null);
                    return Status.OK_STATUS;
                }
            };
            job.setPriority(30);
            job.schedule();
        }
        catch (Exception e) {
            Logger.logError((String)"An error occurred removing Codewind images: ", (Throwable)e);
        }
    }

    private static IStatus getErrorStatus(ProcessHelper.ProcessResult result, String msg) {
        String errorText;
        Logger.logError((String)("Installer failed with return code: " + result.getExitValue() + ", output: " + result.getOutput() + ", error: " + result.getError()));
        String string = errorText = result.getError() != null && !result.getError().isEmpty() ? result.getError() : result.getOutput();
        if (errorText == null || errorText.trim().isEmpty()) {
            errorText = NLS.bind((String)Messages.InstallCodewindFailNoMessage, (Object)result.getExitValue());
        }
        return CodewindInstall.getErrorStatus(NLS.bind((String)msg, (Object)errorText), null);
    }

    private static IStatus getErrorStatus(String msg, Throwable t) {
        Logger.logError((String)msg, (Throwable)t);
        ViewHelper.refreshCodewindExplorerView(null);
        return new Status(4, "org.eclipse.codewind.ui", msg, t);
    }

    private static boolean getStopAll(final IProgressMonitor monitor) {
        if (!ENABLE_STOP_APPS_OPTION) {
            return true;
        }
        final IPreferenceStore prefs = CodewindCorePlugin.getDefault().getPreferenceStore();
        if ("stopAppContainersPrompt".contentEquals(prefs.getString("stopAppContainers"))) {
            if (!CodewindManager.getManager().hasActiveApplications()) {
                return false;
            }
            final boolean[] stopApps = new boolean[]{false};
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialogWithToggle stopAppsQuestion = MessageDialogWithToggle.openYesNoCancelQuestion((Shell)Display.getDefault().getActiveShell(), (String)Messages.StopAllDialog_Title, (String)Messages.StopAllDialog_Message, (String)Messages.StopAllDialog_ToggleMessage, (boolean)false, null, null);
                    switch (stopAppsQuestion.getReturnCode()) {
                        case 2: {
                            stopApps[0] = true;
                            break;
                        }
                        case 1: {
                            monitor.setCanceled(true);
                            break;
                        }
                    }
                    if (!monitor.isCanceled() && stopAppsQuestion.getToggleState()) {
                        prefs.setValue("stopAppContainers", stopApps[0] ? "stopAppContainersAlways" : "stopAppContainersNever");
                    }
                }
            });
            return stopApps[0];
        }
        return "stopAppContainersAlways".contentEquals(prefs.getString("stopAppContainers"));
    }
}

