/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.core.internal.connection;

import java.io.File;
import java.io.IOException;
import java.net.ConnectException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.eclipse.codewind.core.internal.CodewindApplication;
import org.eclipse.codewind.core.internal.CodewindApplicationFactory;
import org.eclipse.codewind.core.internal.CoreUtil;
import org.eclipse.codewind.core.internal.HttpUtil;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.core.internal.cli.AuthToken;
import org.eclipse.codewind.core.internal.cli.CLIUtil;
import org.eclipse.codewind.core.internal.cli.ConnectionUtil;
import org.eclipse.codewind.core.internal.connection.CodewindConnectionException;
import org.eclipse.codewind.core.internal.connection.CodewindSocket;
import org.eclipse.codewind.core.internal.connection.ConnectionEnv;
import org.eclipse.codewind.core.internal.connection.ProjectTemplateInfo;
import org.eclipse.codewind.core.internal.connection.ProjectTypeInfo;
import org.eclipse.codewind.core.internal.connection.RepositoryInfo;
import org.eclipse.codewind.core.internal.console.ProjectLogInfo;
import org.eclipse.codewind.core.internal.messages.Messages;
import org.eclipse.codewind.filewatchers.eclipse.CodewindFilewatcherdConnection;
import org.eclipse.codewind.filewatchers.eclipse.ICodewindProjectTranslator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class CodewindConnection {
    public static final String CODEWIND_WORKSPACE_PROPERTY = "org.eclipse.codewind.internal.workspace";
    private String name;
    private URI baseUri;
    private String conid;
    private AuthToken authToken;
    private ConnectionEnv env = null;
    private String connectionErrorMsg = null;
    private CodewindSocket socket;
    private CodewindFilewatcherdConnection filewatcher;
    private volatile boolean isConnected = false;
    private Map<String, CodewindApplication> appMap = new LinkedHashMap<String, CodewindApplication>();

    public CodewindConnection(String name, URI uri) {
        this(name, uri, null, null);
    }

    public CodewindConnection(String name, URI uri, String conid, AuthToken authToken) {
        this.setName(name);
        this.setBaseURI(uri);
        this.conid = conid;
        this.authToken = authToken;
    }

    public void connect(IProgressMonitor monitor) throws IOException, URISyntaxException, JSONException {
        if (this.isConnected) {
            return;
        }
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        mon.setTaskName(NLS.bind((String)Messages.Connection_TaskLabel, (Object)this.baseUri));
        if (!this.waitForReady((IProgressMonitor)mon.split(20))) {
            if (mon.isCanceled()) {
                return;
            }
            Logger.logError("Timed out waiting for Codewind to go into ready state.");
            this.onInitFail(Messages.Connection_ErrConnection_CodewindNotReady);
        }
        mon.split(25);
        this.env = new ConnectionEnv(CodewindConnection.getEnvData(this.baseUri, this.authToken));
        Logger.log("Codewind version is: " + this.env.getVersion());
        if (!CodewindConnection.isSupportedVersion(this.env.getVersion())) {
            Logger.logError("The detected version of Codewind is not supported: " + this.env.getVersion() + ", url: " + this.baseUri);
            this.onInitFail(NLS.bind((String)Messages.Connection_ErrConnection_OldVersion, (Object)this.env.getVersion(), (Object)"0.6.0"));
        }
        if (mon.isCanceled()) {
            return;
        }
        this.socket = new CodewindSocket(this);
        if (!this.socket.blockUntilFirstConnection((IProgressMonitor)mon.split(35))) {
            Logger.logError("Socket failed to connect: " + this.socket.socketUri);
            this.disconnect();
            throw new CodewindConnectionException(this.socket.socketUri);
        }
        if (mon.isCanceled()) {
            this.socket.close();
            return;
        }
        File cwctl = new File(CLIUtil.getCWCTLExecutable());
        this.filewatcher = new CodewindFilewatcherdConnection(this.baseUri.toString(), cwctl, new ICodewindProjectTranslator(){

            public Optional<String> getProjectId(IProject project) {
                CodewindApplication app;
                if (project != null && (app = CodewindConnection.this.getAppByName(project.getName())) != null) {
                    return Optional.of(app.projectID);
                }
                return Optional.empty();
            }
        });
        if (mon.isCanceled()) {
            this.close();
            return;
        }
        this.isConnected = true;
        Logger.log("Connected to: " + this);
        mon.split(20);
        this.refreshApps(null);
    }

    public String getSocketNamespace() {
        return this.env.getSocketNamespace();
    }

    public CodewindSocket getSocket() {
        return this.socket;
    }

    private void onInitFail(String msg) throws ConnectException {
        Logger.log("Initializing Codewind connection failed: " + msg);
        this.disconnect();
        throw new ConnectException(msg);
    }

    public void disconnect() {
        Logger.log("Disconnecting connection: " + this);
        this.isConnected = false;
        if (this.socket != null) {
            this.socket.close();
        }
        if (this.filewatcher != null) {
            this.filewatcher.dispose();
        }
        for (CodewindApplication app : this.appMap.values()) {
            app.dispose();
        }
        this.appMap.clear();
    }

    public void close() {
        this.disconnect();
        Logger.log("Removing connection: " + this);
        if (this.conid != null) {
            try {
                ConnectionUtil.removeConnection(this.name, this.conid, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (Exception e) {
                Logger.logError("An error occurred trying to de-register the connection: " + this);
            }
        }
    }

    public String getName() {
        if (this.name == null) {
            return "";
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public URI getBaseURI() {
        return this.baseUri;
    }

    public void setBaseURI(URI uri) {
        this.baseUri = uri != null && !uri.toString().endsWith("/") ? uri.resolve("/") : uri;
    }

    public String getConid() {
        return this.conid;
    }

    public void setAuthToken(AuthToken authToken) {
        this.authToken = authToken;
    }

    private static JSONObject getEnvData(URI baseUrl, AuthToken auth) throws JSONException, IOException {
        URI envUrl = baseUrl.resolve("api/v1/environment");
        String envResponse = null;
        try {
            envResponse = HttpUtil.get((URI)envUrl, (AuthToken)auth).response;
        }
        catch (IOException e) {
            Logger.logError("Error contacting Environment endpoint", e);
            throw e;
        }
        return new JSONObject(envResponse);
    }

    public static String getVersion(URI baseURI, AuthToken auth) {
        try {
            ConnectionEnv env = new ConnectionEnv(CodewindConnection.getEnvData(baseURI, auth));
            return env.getVersion();
        }
        catch (Exception e) {
            Logger.logError("An error occurred trying to get the Codewind version.", e);
            return null;
        }
    }

    public static int compareVersions(String versionA, String versionB) throws NumberFormatException {
        int i;
        if (versionA.equals(versionB)) {
            return 0;
        }
        if ("latest".equals(versionA) || "unknown".equals(versionB)) {
            return 1;
        }
        if ("latest".equals(versionB) || "unknown".equals(versionA)) {
            return -1;
        }
        String[] digitsA = versionA.split("\\.");
        String[] digitsB = versionB.split("\\.");
        for (i = 0; i < digitsA.length; ++i) {
            int valueA = Integer.parseInt(digitsA[i]);
            if (i >= digitsB.length) {
                if (valueA == 0) continue;
                return 1;
            }
            int valueB = Integer.parseInt(digitsB[i]);
            if (valueA > valueB) {
                return 1;
            }
            if (valueA >= valueB) continue;
            return -1;
        }
        if (digitsB.length > digitsA.length) {
            for (i = digitsA.length; i < digitsB.length; ++i) {
                int valueB = Integer.parseInt(digitsB[i]);
                if (valueB == 0) continue;
                return -1;
            }
        }
        return 0;
    }

    public static boolean isSupportedVersion(String versionStr) {
        try {
            return CodewindConnection.compareVersions(versionStr, "0.6.0") >= 0;
        }
        catch (NumberFormatException e) {
            Logger.logError("Invalid version: " + versionStr, e);
            return false;
        }
    }

    public String getConnectionErrorMsg() {
        return this.connectionErrorMsg;
    }

    public void refreshApps(String projectID) {
        URI projectsURL = this.baseUri.resolve("api/v1/projects");
        try {
            String projectsResponse = HttpUtil.get((URI)projectsURL, (AuthToken)this.authToken).response;
            CodewindApplicationFactory.getAppsFromProjectsJson(this, projectsResponse, projectID);
            Logger.log("App list update success");
        }
        catch (Exception e) {
            CoreUtil.openDialog(true, Messages.Connection_ErrGettingProjectListTitle, e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addApp(CodewindApplication app) {
        Map<String, CodewindApplication> map = this.appMap;
        synchronized (map) {
            this.appMap.put(app.projectID, app);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CodewindApplication> getApps() {
        Map<String, CodewindApplication> map = this.appMap;
        synchronized (map) {
            return new ArrayList<CodewindApplication>(this.appMap.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getAppIds() {
        Map<String, CodewindApplication> map = this.appMap;
        synchronized (map) {
            return new HashSet<String>(this.appMap.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeApp(String projectID) {
        CodewindApplication app = null;
        Map<String, CodewindApplication> map = this.appMap;
        synchronized (map) {
            app = this.appMap.remove(projectID);
        }
        if (app != null) {
            Logger.log("Removing the " + app.name + " application with id: " + projectID);
            CoreUtil.removeApplication(app);
            app.dispose();
        } else {
            Logger.log("No application found for deleted project: " + projectID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CodewindApplication getAppByID(String projectID) {
        Map<String, CodewindApplication> map = this.appMap;
        synchronized (map) {
            return this.appMap.get(projectID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CodewindApplication getAppByName(String name) {
        Map<String, CodewindApplication> map = this.appMap;
        synchronized (map) {
            for (CodewindApplication app : this.getApps()) {
                if (!app.name.equals(name)) continue;
                return app;
            }
        }
        Logger.log("No application found for name " + name);
        return null;
    }

    public boolean waitForReady(IProgressMonitor monitor) throws IOException {
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IOException exception = null;
        for (int i = 0; i < 10; ++i) {
            try {
                mon.split(10);
                if (this.requestCodewindReady(500, 500)) {
                    return true;
                }
                if (mon.isCanceled()) {
                    return false;
                }
                Thread.sleep(500L);
                if (!mon.isCanceled()) continue;
                return false;
            }
            catch (IOException e) {
                exception = e;
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (exception != null) {
            throw exception;
        }
        return false;
    }

    public boolean requestCodewindReady(int connectTimeoutMS, int readTimeoutMS) throws IOException {
        String endpoint = "ready";
        URI uri = this.baseUri.resolve(endpoint);
        HttpUtil.HttpResult result = HttpUtil.get(uri, this.authToken, connectTimeoutMS, readTimeoutMS);
        this.checkResult(result, uri, true);
        return "true".equals(result.response);
    }

    public void requestProjectRestart(CodewindApplication app, String launchMode) throws JSONException, IOException {
        String restartEndpoint = "api/v1/projects/" + app.projectID + "/" + "restart";
        URI url = this.baseUri.resolve(restartEndpoint);
        JSONObject restartProjectPayload = new JSONObject();
        restartProjectPayload.put("startMode", (Object)launchMode);
        HttpUtil.HttpResult result = HttpUtil.post(url, this.authToken, restartProjectPayload);
        if (!result.isGoodResponse) {
            String msg = String.format("Received bad response from server %d with error message %s", result.responseCode, result.error);
            throw new IOException(msg);
        }
        app.invalidatePorts();
    }

    public void requestProjectOpenClose(CodewindApplication app, boolean enable) throws JSONException, IOException {
        String action = enable ? "open" : "close";
        String restartEndpoint = "api/v1/projects/" + app.projectID + "/" + action;
        URI url = this.baseUri.resolve(restartEndpoint);
        HttpUtil.HttpResult result = HttpUtil.put(url, this.authToken);
        if (!result.isGoodResponse) {
            String msg = String.format("Received bad response from server %d with error message %s", result.responseCode, result.error);
            throw new IOException(msg);
        }
    }

    public JSONObject requestProjectStatus(CodewindApplication app) throws IOException, JSONException {
        URI statusUrl = this.baseUri.resolve("api/v1/projects");
        HttpUtil.HttpResult result = HttpUtil.get(statusUrl, this.authToken);
        if (!result.isGoodResponse) {
            String msg = String.format("Received bad response from server %d with error message %s", result.responseCode, result.error);
            throw new IOException(msg);
        }
        if (result.response == null) {
            throw new IOException("Server returned good response code, but null response when getting initial state");
        }
        JSONArray allProjectStatuses = new JSONArray(result.response);
        for (int i = 0; i < allProjectStatuses.length(); ++i) {
            JSONObject projectStatus = allProjectStatuses.getJSONObject(i);
            if (!projectStatus.getString("projectID").equals(app.projectID)) continue;
            return projectStatus;
        }
        Logger.log("Didn't find status info for project " + app.name);
        return null;
    }

    public JSONObject requestProjectMetricsStatus(CodewindApplication app) throws IOException, JSONException {
        String endpoint = "api/v1/projects/" + app.projectID + "/" + "metrics/status";
        URI uri = this.baseUri.resolve(endpoint);
        HttpUtil.HttpResult result = HttpUtil.get(uri, this.authToken);
        this.checkResult(result, uri, true);
        return new JSONObject(result.response);
    }

    public void requestProjectBuild(CodewindApplication app, String action) throws JSONException, IOException {
        String buildEndpoint = "api/v1/projects/" + app.projectID + "/" + "build";
        URI url = this.baseUri.resolve(buildEndpoint);
        JSONObject buildPayload = new JSONObject();
        buildPayload.put("action", (Object)action);
        HttpUtil.post(url, this.authToken, buildPayload);
    }

    public List<ProjectLogInfo> requestProjectLogs(CodewindApplication app) throws JSONException, IOException {
        ArrayList<ProjectLogInfo> logList = new ArrayList<ProjectLogInfo>();
        String endpoint = "api/v1/projects/" + app.projectID + "/" + "logs";
        URI uri = this.baseUri.resolve(endpoint);
        HttpUtil.HttpResult result = HttpUtil.get(uri, this.authToken);
        this.checkResult(result, uri, true);
        JSONObject logs = new JSONObject(result.response);
        JSONArray buildLogs = logs.getJSONArray("build");
        logList.addAll(CodewindConnection.getLogs(buildLogs, "build"));
        JSONArray appLogs = logs.getJSONArray("app");
        logList.addAll(CodewindConnection.getLogs(appLogs, "app"));
        return logList;
    }

    public static List<ProjectLogInfo> getLogs(JSONArray logs, String type) throws JSONException {
        ArrayList<ProjectLogInfo> logList = new ArrayList<ProjectLogInfo>();
        if (logs != null) {
            for (int i = 0; i < logs.length(); ++i) {
                JSONObject log = logs.getJSONObject(i);
                if (log.has("logName")) {
                    String logName = log.getString("logName");
                    if ("-".equals(logName)) continue;
                    String workspacePath = null;
                    if (log.has("workspaceLogPath")) {
                        workspacePath = log.getString("workspaceLogPath");
                    }
                    ProjectLogInfo logInfo = new ProjectLogInfo(type, logName, workspacePath);
                    logList.add(logInfo);
                    continue;
                }
                Logger.log("An item in the log list does not have the key: logName");
            }
        }
        return logList;
    }

    public void requestEnableLogStream(CodewindApplication app, ProjectLogInfo logInfo) throws IOException {
        String endpoint = "api/v1/projects/" + app.projectID + "/" + "logs" + "/" + logInfo.type + "/" + logInfo.logName;
        URI uri = this.baseUri.resolve(endpoint);
        HttpUtil.HttpResult result = HttpUtil.post(uri, this.authToken);
        this.checkResult(result, uri, false);
    }

    public void requestDisableLogStream(CodewindApplication app, ProjectLogInfo logInfo) throws IOException {
        String endpoint = "api/v1/projects/" + app.projectID + "/" + "logs" + "/" + logInfo.type + "/" + logInfo.logName;
        URI uri = this.baseUri.resolve(endpoint);
        HttpUtil.HttpResult result = HttpUtil.delete(uri, this.authToken);
        this.checkResult(result, uri, false);
    }

    public void requestValidate(CodewindApplication app) throws JSONException, IOException {
        String endpoint = "api/v1/projects/" + app.projectID + "/" + "validate";
        URI url = this.baseUri.resolve(endpoint);
        JSONObject buildPayload = new JSONObject();
        buildPayload.put("projectType", (Object)app.projectType.getId());
        HttpUtil.HttpResult result = HttpUtil.post(url, this.authToken, buildPayload);
        if (!result.isGoodResponse) {
            String msg = String.format("Received bad response from server %d with error message %s", result.responseCode, result.error);
            throw new IOException(msg);
        }
    }

    public void requestValidateGenerate(CodewindApplication app) throws JSONException, IOException {
        String endpoint = "api/v1/projects/" + app.projectID + "/" + "validate/generate";
        URI url = this.baseUri.resolve(endpoint);
        JSONObject buildPayload = new JSONObject();
        buildPayload.put("projectType", (Object)app.projectType.getId());
        buildPayload.put("autoGenerate", true);
        HttpUtil.HttpResult result = HttpUtil.post(url, this.authToken, buildPayload);
        if (!result.isGoodResponse) {
            String msg = String.format("Received bad response from server %d with error message %s", result.responseCode, result.error);
            throw new IOException(msg);
        }
        this.requestValidate(app);
    }

    public JSONObject requestProjectCapabilities(CodewindApplication app) throws IOException, JSONException {
        URI statusUrl = this.baseUri.resolve("api/v1/projects/" + app.projectID + "/" + "capabilities");
        HttpUtil.HttpResult result = HttpUtil.get(statusUrl, this.authToken);
        if (!result.isGoodResponse) {
            String msg = String.format("Received bad response from server %d with error message %s", result.responseCode, result.error);
            throw new IOException(msg);
        }
        if (result.response == null) {
            throw new IOException("Server returned good response code, but empty content when getting project capabilities");
        }
        JSONObject capabilities = new JSONObject(result.response);
        return capabilities;
    }

    public List<ProjectTemplateInfo> requestProjectTemplates(boolean enabledOnly) throws IOException, JSONException, URISyntaxException {
        ArrayList<ProjectTemplateInfo> templates = new ArrayList<ProjectTemplateInfo>();
        URI uri = this.baseUri.resolve("api/v1/templates");
        if (enabledOnly) {
            String query = "showEnabledOnly=true";
            uri = new URI(uri.getScheme(), uri.getAuthority(), uri.getPath(), query, uri.getFragment());
        }
        HttpUtil.HttpResult result = HttpUtil.get(uri, this.authToken);
        this.checkResult(result, uri, false);
        if (result.responseCode == 204) {
            return templates;
        }
        JSONArray templateArray = new JSONArray(result.response);
        for (int i = 0; i < templateArray.length(); ++i) {
            templates.add(new ProjectTemplateInfo(templateArray.getJSONObject(i)));
        }
        return templates;
    }

    public List<RepositoryInfo> requestRepositories() throws IOException, JSONException {
        ArrayList<RepositoryInfo> repos = new ArrayList<RepositoryInfo>();
        URI uri = this.baseUri.resolve("api/v1/templates/repositories");
        HttpUtil.HttpResult result = HttpUtil.get(uri, this.authToken);
        this.checkResult(result, uri, true);
        JSONArray repoArray = new JSONArray(result.response);
        for (int i = 0; i < repoArray.length(); ++i) {
            repos.add(new RepositoryInfo(repoArray.getJSONObject(i)));
        }
        return repos;
    }

    public void requestRepoEnable(String repoUrl, boolean enable) throws IOException, JSONException {
        URI uri = this.baseUri.resolve("api/v1/batch/templates/repositories");
        JSONArray payload = new JSONArray();
        JSONObject obj = new JSONObject();
        obj.put("op", (Object)"enable");
        obj.put("url", (Object)repoUrl);
        obj.put("value", (Object)(enable ? "true" : "false"));
        payload.put((Object)obj);
        HttpUtil.HttpResult result = HttpUtil.patch(uri, payload);
        this.checkResult(result, uri, false);
    }

    public void requestRepoAdd(String url, String name, String description) throws IOException, JSONException {
        URI uri = this.baseUri.resolve("api/v1/templates/repositories");
        JSONObject payload = new JSONObject();
        payload.put("url", (Object)url);
        if (name != null && !name.isEmpty()) {
            payload.put("name", (Object)name);
        }
        if (description != null && !description.isEmpty()) {
            payload.put("description", (Object)description);
        }
        payload.put("enabled", true);
        HttpUtil.HttpResult result = HttpUtil.post(uri, this.authToken, payload);
        this.checkResult(result, uri, false);
    }

    public void requestRepoRemove(String url) throws IOException, JSONException {
        URI uri = this.baseUri.resolve("api/v1/templates/repositories");
        JSONObject payload = new JSONObject();
        payload.put("url", (Object)url);
        HttpUtil.HttpResult result = HttpUtil.delete(uri, this.authToken, payload);
        this.checkResult(result, uri, false);
    }

    public void requestProjectUnbind(String projectID) throws IOException {
        String endpoint = "api/v1/projects/" + projectID + "/" + "unbind";
        URI uri = this.baseUri.resolve(endpoint);
        HttpUtil.HttpResult result = HttpUtil.post(uri, this.authToken);
        this.checkResult(result, uri, false);
        CoreUtil.updateConnection(this);
    }

    public List<ProjectTypeInfo> requestProjectTypes() throws IOException, JSONException {
        ArrayList<ProjectTypeInfo> projectTypes = new ArrayList<ProjectTypeInfo>();
        URI uri = this.baseUri.resolve("api/v1/project-types");
        HttpUtil.HttpResult result = HttpUtil.get(uri, this.authToken);
        this.checkResult(result, uri, true);
        JSONArray array = new JSONArray(result.response);
        for (int i = 0; i < array.length(); ++i) {
            projectTypes.add(new ProjectTypeInfo(array.getJSONObject(i)));
        }
        return projectTypes;
    }

    public String requestRegistryTest(String registry) throws IOException, JSONException {
        URI uri = this.baseUri.resolve("api/v1/registry");
        JSONObject payload = new JSONObject();
        payload.put("deploymentRegistry", (Object)registry);
        payload.put("operation", (Object)"test");
        HttpUtil.HttpResult result = HttpUtil.post(uri, this.authToken, payload);
        this.checkResult(result, uri, true);
        JSONObject resultObj = new JSONObject(result.response);
        if (resultObj.getBoolean("deploymentRegistryTest")) {
            return null;
        }
        String msg = resultObj.getString("msg");
        return msg;
    }

    public void requestRegistrySet(String registry) throws IOException, JSONException {
        URI uri = this.baseUri.resolve("api/v1/registry");
        JSONObject payload = new JSONObject();
        payload.put("deploymentRegistry", (Object)registry);
        payload.put("operation", (Object)"set");
        HttpUtil.HttpResult result = HttpUtil.post(uri, this.authToken, payload);
        this.checkResult(result, uri, false);
    }

    private void checkResult(HttpUtil.HttpResult result, URI uri, boolean checkContent) throws IOException {
        if (!result.isGoodResponse) {
            String msg = String.format("Received bad response code %d for uri %s with error message %s", result.responseCode, uri, result.error);
            throw new IOException(msg);
        }
        if (checkContent && result.response == null) {
            throw new IOException("Server returned good response code, but the content of the result is null for uri: " + uri);
        }
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void onConnectionError() {
        Logger.log("Connection to " + this.baseUri + " lost");
        this.isConnected = false;
        Map<String, CodewindApplication> map = this.appMap;
        synchronized (map) {
            this.appMap.clear();
        }
        CoreUtil.updateAll();
    }

    public synchronized void clearConnectionError() {
        Logger.log("Connection to " + this.baseUri + " restored");
        try {
            String oldSocketNS = this.env.getSocketNamespace();
            this.env = new ConnectionEnv(CodewindConnection.getEnvData(this.baseUri, this.authToken));
            if (!CodewindConnection.isSupportedVersion(this.env.getVersion())) {
                Logger.logError("The detected version of Codewind after reconnect is not supported: " + this.env.getVersion());
                this.connectionErrorMsg = NLS.bind((String)Messages.Connection_ErrConnection_OldVersion, (Object)this.env.getVersion(), (Object)"0.6.0");
                CoreUtil.updateConnection(this);
                return;
            }
            String socketNS = this.env.getSocketNamespace();
            if (socketNS != null && !socketNS.equals(oldSocketNS) || oldSocketNS != null && !oldSocketNS.equals(socketNS)) {
                this.socket.close();
                this.socket = new CodewindSocket(this);
                if (!this.socket.blockUntilFirstConnection((IProgressMonitor)new NullProgressMonitor())) {
                    Logger.logError("Failed to create a new socket with updated URI: " + this.socket.socketUri);
                    this.connectionErrorMsg = null;
                    CoreUtil.updateAll();
                    return;
                }
            }
        }
        catch (Exception e) {
            Logger.logError("An exception occurred while trying to update the connection information", e);
            this.connectionErrorMsg = Messages.Connection_ErrConnection_UpdateCacheException;
            CoreUtil.updateAll();
            return;
        }
        this.connectionErrorMsg = null;
        this.isConnected = true;
        this.refreshApps(null);
        CoreUtil.updateAll();
    }

    public String toString() {
        return String.format("%s @ name=%s baseUrl=%s conid=%s", CodewindConnection.class.getSimpleName(), this.name, this.baseUri == null ? "unknown" : this.baseUri, this.conid == null ? "<none>" : this.conid);
    }

    public void requestProjectDelete(String projectId) throws JSONException, IOException {
        String endpoint = "api/v1/projects/" + projectId;
        URI uri = this.baseUri.resolve(endpoint);
        HttpUtil.HttpResult result = HttpUtil.delete(uri, this.authToken);
        this.checkResult(result, uri, false);
    }

    public ConnectionEnv.TektonDashboard getTektonDashboard() {
        return this.env.getTektonDashboard();
    }

    public URI getNewProjectURI() {
        return this.getProjectURI("new-project");
    }

    public URI getImportProjectURI() {
        return this.getProjectURI("import-project");
    }

    private URI getProjectURI(String projectQuery) {
        try {
            URI uri = this.baseUri;
            String query = projectQuery + "=" + "true";
            uri = new URI(uri.getScheme(), uri.getAuthority(), uri.getPath(), query, uri.getFragment());
            return uri;
        }
        catch (Exception e) {
            Logger.logError("Failed to get the project URI for the query: " + projectQuery, e);
            return null;
        }
    }

    public URL getAppMonitorURL(CodewindApplication app) {
        return this.getAppViewURL(app, "monitor");
    }

    public URL getAppViewURL(CodewindApplication app, String view) {
        try {
            URI uri = this.baseUri;
            String query = "project=" + app.projectID;
            query = query + "&" + "view" + "=" + view;
            uri = new URI(uri.getScheme(), uri.getAuthority(), uri.getPath(), query, uri.getFragment());
            return uri.toURL();
        }
        catch (Exception e) {
            Logger.logError("Failed to get the URL for the " + view + " view and the " + app.name + "application.", e);
            return null;
        }
    }

    public URL getPerformanceMonitorURL(CodewindApplication app) {
        try {
            URI uri = this.baseUri;
            uri = uri.resolve("performance/charts");
            String query = "project=" + app.projectID;
            uri = new URI(uri.getScheme(), uri.getAuthority(), uri.getPath(), query, uri.getFragment());
            return uri.toURL();
        }
        catch (Exception e) {
            Logger.logError("Failed to get the performance monitor URL for the " + app.name + "application.", e);
            return null;
        }
    }

    public boolean isLocal() {
        return false;
    }
}

