/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.filewatchers.core;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.eclipse.codewind.filewatchers.core.FWLogger;
import org.eclipse.codewind.filewatchers.core.FilewatcherUtils;
import org.eclipse.codewind.filewatchers.core.IPlatformWatchService;
import org.eclipse.codewind.filewatchers.core.PathFilter;
import org.eclipse.codewind.filewatchers.core.PathUtils;
import org.eclipse.codewind.filewatchers.core.ProjectToWatch;
import org.eclipse.codewind.filewatchers.core.WatchEventEntry;
import org.eclipse.codewind.filewatchers.core.internal.CLIState;
import org.eclipse.codewind.filewatchers.core.internal.DebugTimer;
import org.eclipse.codewind.filewatchers.core.internal.FileChangeEventBatchUtil;
import org.eclipse.codewind.filewatchers.core.internal.HttpGetStatusThread;
import org.eclipse.codewind.filewatchers.core.internal.HttpPostOutputQueue;
import org.eclipse.codewind.filewatchers.core.internal.HttpUtil;
import org.eclipse.codewind.filewatchers.core.internal.WebSocketManagerThread;
import org.json.JSONObject;

public class Filewatcher {
    private static final FWLogger log = FWLogger.getInstance();
    private final HashMap<String, ProjectObject> projectsMap_synch = new HashMap();
    private final HttpPostOutputQueue outputQueue;
    private final String url;
    private final String wsUrl;
    private final IPlatformWatchService internalWatchService;
    private final IPlatformWatchService externalWatchService;
    private final HttpGetStatusThread getStatusThread;
    private final WebSocketManagerThread webSocketThread;
    private final AtomicBoolean disposed_synch = new AtomicBoolean();
    private final String clientUuid;
    private final Optional<String> pathToInstaller;

    public Filewatcher(String urlParam, String clientUuid, IPlatformWatchService internalWatchService, IPlatformWatchService externalWatchService, String pathToInstallerParam) {
        this.url = FilewatcherUtils.stripTrailingSlash(urlParam);
        this.clientUuid = clientUuid;
        this.pathToInstaller = pathToInstallerParam != null && !pathToInstallerParam.trim().isEmpty() ? Optional.of(pathToInstallerParam) : Optional.empty();
        String calculatedWsUrl = this.url;
        calculatedWsUrl = calculatedWsUrl.replace("http://", "ws://");
        this.wsUrl = calculatedWsUrl = calculatedWsUrl.replace("https://", "wss://");
        this.outputQueue = new HttpPostOutputQueue(this.url);
        FilewatcherWatchListener fwl = new FilewatcherWatchListener(this);
        if (internalWatchService == null) {
            throw new IllegalArgumentException("internalWatchService param must be provided.");
        }
        this.internalWatchService = internalWatchService;
        this.internalWatchService.addListener(fwl);
        if (externalWatchService != null) {
            if (internalWatchService == externalWatchService) {
                this.externalWatchService = null;
            } else {
                this.externalWatchService = externalWatchService;
                this.externalWatchService.addListener(fwl);
            }
        } else {
            this.externalWatchService = null;
        }
        this.getStatusThread = new HttpGetStatusThread(this.url, this);
        this.getStatusThread.start();
        this.getStatusThread.queueStatusUpdate();
        this.webSocketThread = new WebSocketManagerThread(this.wsUrl, this);
        this.webSocketThread.start();
        this.webSocketThread.queueEstablishConnection();
        new DebugTimer(this);
    }

    public void refreshWatchStatus() {
        this.getStatusThread.queueStatusUpdate();
    }

    public void internal_updateFileWatchStateFromWebSocket(List<ProjectToWatch.ProjectToWatchFromWebSocket> ptwList) throws IOException {
        log.logInfo("Examining received file watch state from WebSocket");
        for (ProjectToWatch.ProjectToWatchFromWebSocket ptw : ptwList) {
            if (ptw.getChangeType().equals("add") || ptw.getChangeType().equals("update")) {
                this.createOrUpdateProjectToWatch(ptw);
            }
            if (!ptw.getChangeType().equals("delete")) continue;
            this.removeSingleProjectToWatch(ptw);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Serializable serializable = this.disposed_synch;
        synchronized (serializable) {
            if (this.disposed_synch.get()) {
                return;
            }
            this.disposed_synch.set(true);
        }
        log.logInfo("disposed() called on " + this.getClass().getSimpleName());
        this.outputQueue.dispose();
        try {
            this.internalWatchService.dispose();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.externalWatchService != null) {
                this.externalWatchService.dispose();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.getStatusThread.dispose();
        this.webSocketThread.dispose();
        serializable = this.projectsMap_synch;
        synchronized (serializable) {
            this.projectsMap_synch.values().forEach(e -> ((ProjectObject)e).getEventBatchUtil().dispose());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void internal_updateFileWatchStateFromGetRequest(List<ProjectToWatch> latestState) throws IOException {
        log.logInfo("Examining received file watch state, from GET request");
        ArrayList<ProjectToWatch> removedProjects = new ArrayList<ProjectToWatch>();
        HashMap projectIdInHttpResult = new HashMap();
        latestState.forEach(e -> {
            if (projectIdInHttpResult.containsKey(e.getProjectId())) {
                log.logSevere("Multiple projects in the project list share the same project ID: " + e.getProjectId());
            }
            projectIdInHttpResult.put(e.getProjectId(), true);
        });
        HashMap<String, ProjectObject> hashMap = this.projectsMap_synch;
        synchronized (hashMap) {
            for (ProjectObject po : this.projectsMap_synch.values()) {
                if (projectIdInHttpResult.containsKey(po.getProjectToWatch().getProjectId())) continue;
                removedProjects.add(po.getProjectToWatch());
            }
        }
        removedProjects.forEach(e -> this.removeSingleProjectToWatch((ProjectToWatch)e));
        for (ProjectToWatch ptw : latestState) {
            this.createOrUpdateProjectToWatch(ptw);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void internal_informCwctlOfFileChanges(String projectId) {
        ProjectObject po;
        AtomicBoolean atomicBoolean = this.disposed_synch;
        synchronized (atomicBoolean) {
            if (this.disposed_synch.get()) {
                return;
            }
        }
        if (!this.pathToInstaller.isPresent() || this.pathToInstaller.get().trim().isEmpty()) {
            log.logDebug("Skipping invocation of CLI command due to no installer path.");
            return;
        }
        HashMap<String, ProjectObject> hashMap = this.projectsMap_synch;
        synchronized (hashMap) {
            po = this.projectsMap_synch.get(projectId);
        }
        if (po == null) {
            log.logSevere("Asked to invoke CLI on a project that wasn't in the projects map: " + projectId);
            return;
        }
        po.informCwctlOfFileChanges();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeSingleProjectToWatch(ProjectToWatch removedProject) {
        ProjectObject po;
        HashMap<String, ProjectObject> hashMap = this.projectsMap_synch;
        synchronized (hashMap) {
            po = this.projectsMap_synch.remove(removedProject.getProjectId());
        }
        if (po == null) {
            log.logError("Asked to remove a project that wasn't in the projects map: " + removedProject.getProjectId());
            return;
        }
        log.logInfo("Removing project from watch list: " + po.getProjectToWatch().getProjectId() + " " + po.getProjectToWatch().getPathToMonitor());
        ProjectToWatch ptw = po.getProjectToWatch();
        File fileToMonitor = new File(PathUtils.convertAbsoluteUnixStyleNormalizedPathToLocalFile(ptw.getPathToMonitor()));
        log.logDebug("Calling watch service removePath with file: " + fileToMonitor.getPath());
        po.getWatchService().removePath(fileToMonitor, ptw);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createOrUpdateProjectToWatch(ProjectToWatch ptw) throws IOException {
        ProjectObject po;
        HashMap<String, ProjectObject> hashMap = this.projectsMap_synch;
        synchronized (hashMap) {
            po = this.projectsMap_synch.get(ptw.getProjectId());
        }
        File fileToMonitor = new File(PathUtils.convertAbsoluteUnixStyleNormalizedPathToLocalFile(ptw.getPathToMonitor()));
        if (po == null) {
            IPlatformWatchService watchService = this.externalWatchService == null ? this.internalWatchService : (ptw.isExternal() ? this.externalWatchService : this.internalWatchService);
            if (watchService == null) {
                log.logSevere("Watch service for the new project was null; this shouldn't happen. projectId: " + ptw.getProjectId() + " path: " + ptw.getPathToMonitor());
                return;
            }
            po = new ProjectObject(ptw.getProjectId(), ptw, this, watchService);
            HashMap<String, ProjectObject> hashMap2 = this.projectsMap_synch;
            synchronized (hashMap2) {
                this.projectsMap_synch.put(ptw.getProjectId(), po);
            }
            watchService.addPath(fileToMonitor, ptw);
            log.logInfo("Added new project with path '" + ptw.getPathToMonitor() + "' to watch list, with watch directory: '" + fileToMonitor.getPath() + "' with watch service " + watchService.getClass().getSimpleName(), ptw.getProjectId());
        } else {
            String newTimeInDate;
            ProjectToWatch oldProjectToWatch = po.getProjectToWatch();
            boolean pctUpdated = false;
            Long pctOldProjectToWatch = oldProjectToWatch.getProjectCreationTimeInAbsoluteMsecs().orElse(null);
            Long pctNewProjectToWatch = ptw.getProjectCreationTimeInAbsoluteMsecs().orElse(null);
            Long newPct = null;
            if (pctNewProjectToWatch != null && pctOldProjectToWatch != null && pctNewProjectToWatch != pctOldProjectToWatch) {
                newPct = pctNewProjectToWatch;
                newTimeInDate = pctNewProjectToWatch != null ? new Date(pctNewProjectToWatch).toString() : "";
                log.logInfo("The project creation time has changed, when both values were non-null. Old: " + pctOldProjectToWatch + " New: " + pctNewProjectToWatch + "(" + newTimeInDate + "), for project " + ptw.getProjectId());
                pctUpdated = true;
            }
            if (pctOldProjectToWatch != null && pctNewProjectToWatch == null) {
                newPct = pctOldProjectToWatch;
                log.logInfo("Internal project creation state was preserved, despite receiving a project update w/o this value. Current: " + pctOldProjectToWatch + " Received: " + pctNewProjectToWatch + " for project " + ptw.getProjectId());
                ptw = ptw.cloneWithNewProjectCreationTime(newPct);
                pctUpdated = false;
            }
            if (pctOldProjectToWatch == null && pctNewProjectToWatch != null) {
                newPct = pctNewProjectToWatch;
                newTimeInDate = newPct != null ? new Date(newPct).toString() : "";
                log.logInfo("The project creation time has changed. Old: " + pctOldProjectToWatch + " New: " + pctNewProjectToWatch + "(" + newTimeInDate + "), for project " + ptw.getProjectId());
                pctUpdated = true;
            }
            if (pctUpdated) {
                ptw = ptw.cloneWithNewProjectCreationTime(newPct);
                po.updateProjectToWatch(ptw);
            }
            if (!oldProjectToWatch.getProjectWatchStateId().equals(ptw.getProjectWatchStateId())) {
                log.logInfo("The project watch state has changed: " + oldProjectToWatch.getProjectWatchStateId() + " " + ptw.getProjectWatchStateId() + " for project " + ptw.getProjectId());
                po.updateProjectToWatch(ptw);
                po.getWatchService().removePath(fileToMonitor, oldProjectToWatch);
                log.logInfo("From update, removed project with path '" + ptw.getPathToMonitor() + "' from watch list, with watch directory: '" + fileToMonitor.getPath() + "'", ptw.getProjectId());
                po.getWatchService().addPath(fileToMonitor, ptw);
                log.logInfo("From update, added new project with path '" + ptw.getPathToMonitor() + "' to watch list, with watch directory: '" + fileToMonitor.getPath() + "'", ptw.getProjectId());
            } else {
                log.logInfo("The project watch state has not changed for project " + ptw.getProjectId() + " based on the project watch state id.");
            }
        }
    }

    public void internal_sendBulkFileChanges(String projectId, long mostRecentEntryTimestamp, List<String> base64Compressed) {
        this.outputQueue.addToQueue(projectId, mostRecentEntryTimestamp, base64Compressed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<String> generateDebugString() {
        AtomicBoolean atomicBoolean = this.disposed_synch;
        synchronized (atomicBoolean) {
            if (this.disposed_synch.get()) {
                return Optional.empty();
            }
        }
        String result = "";
        result = result + "---------------------------------------------------------------------------------------\n\n";
        if (this.internalWatchService != null) {
            result = result + "WatchService - " + this.internalWatchService.getClass().getSimpleName() + ":\n";
            result = result + this.internalWatchService.generateDebugState().trim() + "\n";
        }
        if (this.externalWatchService != null) {
            result = result + "WatchService - " + this.externalWatchService.getClass().getSimpleName() + ":\n";
            result = result + this.externalWatchService.generateDebugState().trim() + "\n";
        }
        result = result + "\n";
        HashMap<String, ProjectObject> hashMap = this.projectsMap_synch;
        synchronized (hashMap) {
            result = result + "Project list:\n";
            for (Map.Entry<String, ProjectObject> e : this.projectsMap_synch.entrySet()) {
                ProjectToWatch ptw = e.getValue().getProjectToWatch();
                result = result + "- " + e.getKey() + " | " + ptw.getPathToMonitor();
                if (ptw.getIgnoredPaths().size() > 0) {
                    result = result + " | ignoredPaths: ";
                    for (String path : ptw.getIgnoredPaths()) {
                        result = result + "'" + path + "' ";
                    }
                }
                result = result + "\n";
            }
        }
        result = result + "\nHTTP Post Output Queue:\n" + this.outputQueue.generateDebugString().trim() + "\n\n";
        result = result + "---------------------------------------------------------------------------------------\n\n";
        return Optional.of(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Optional<FileChangeEventBatchUtil> getEventProcessing(String projectId) {
        HashMap<String, ProjectObject> hashMap = this.projectsMap_synch;
        synchronized (hashMap) {
            ProjectObject po = this.projectsMap_synch.getOrDefault(projectId, null);
            if (po != null) {
                return Optional.of(po.getEventBatchUtil());
            }
            return Optional.empty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void receiveNewWatchEventEntries(List<WatchEventEntry> watchEntries, long receivedAtInEpochMsecs) {
        HashMap<String, List> projectIdToList = new HashMap<String, List>();
        ArrayList projectsToWatch = new ArrayList();
        Iterator iterator = this.projectsMap_synch;
        synchronized (iterator) {
            projectsToWatch.addAll(this.projectsMap_synch.values().stream().map(e -> e.getProjectToWatch()).collect(Collectors.toList()));
        }
        Collections.sort(projectsToWatch, (a, b) -> b.getPathToMonitor().length() - a.getPathToMonitor().length());
        for (WatchEventEntry we : watchEntries) {
            if (log.isDebug()) {
                log.logDebug("Received event from watcher: " + we);
            }
            String fullLocalPath = we.getAbsolutePathWithUnixSeparators();
            boolean match = false;
            for (ProjectToWatch ptw : projectsToWatch) {
                if (!fullLocalPath.startsWith(ptw.getPathToMonitor())) continue;
                List list = projectIdToList.computeIfAbsent(ptw.getProjectId(), e -> new ArrayList());
                list.add(we);
                match = true;
                break;
            }
            if (match) continue;
            log.logSevere("Could not find matching project for " + we);
        }
        for (Map.Entry me : projectIdToList.entrySet()) {
            ProjectToWatch ptw = projectsToWatch.stream().filter(e -> e.getProjectId().equals(me.getKey())).findAny().orElse(null);
            if (ptw == null) continue;
            PathFilter filter = new PathFilter(ptw);
            ArrayList<FileChangeEventBatchUtil.ChangedFileEntry> changedFileEntries = new ArrayList<FileChangeEventBatchUtil.ChangedFileEntry>();
            List eventList = (List)me.getValue();
            block6: for (WatchEventEntry we : eventList) {
                Optional<String> initialPath = PathUtils.convertAbsolutePathWithUnixSeparatorsToProjectRelativePath(we.getAbsolutePathWithUnixSeparators(), ptw.getPathToMonitor());
                String path = initialPath.orElse(null);
                if (path == null) continue;
                if (ptw.getIgnoredPaths() != null) {
                    if (filter.isFilteredOutByPath(path)) {
                        log.logDebug("Filtering out " + path + " by path.");
                        continue;
                    }
                    for (String parentPath : PathUtils.splitRelativeProjectPathIntoComponentPaths(path)) {
                        if (!filter.isFilteredOutByPath(parentPath)) continue;
                        log.logDebug("Filtering out " + path + " by parent path.");
                        continue block6;
                    }
                }
                if (ptw.getIgnoredFilenames() != null && filter.isFilteredOutByFilename(path)) {
                    log.logDebug("Filtering out " + path + " by filename.");
                    continue;
                }
                log.logDebug("Adding " + path + " to change list.");
                changedFileEntries.add(new FileChangeEventBatchUtil.ChangedFileEntry(path, we.isDirectory(), we.getEventType(), receivedAtInEpochMsecs));
            }
            if (changedFileEntries.size() <= 0) continue;
            FileChangeEventBatchUtil processing = this.getEventProcessing(ptw.getProjectId()).orElse(null);
            if (processing != null) {
                processing.addChangedFiles(changedFileEntries);
                continue;
            }
            log.logSevere("Could not locate event processing for project id " + ptw.getProjectId());
        }
    }

    private void receiveWatchSuccessStatus(ProjectToWatch ptw, boolean successParam) {
        if (successParam) {
            this.internal_informCwctlOfFileChanges(ptw.getProjectId());
        }
        FilewatcherUtils.newThread(() -> {
            String url = this.url + "/api/v1/projects/" + ptw.getProjectId() + "/file-changes/" + ptw.getProjectWatchStateId() + "/status?clientUuid=" + this.clientUuid;
            FilewatcherUtils.ExponentialBackoffUtil backoffUtil = FilewatcherUtils.getDefaultBackoffUtil(4000L);
            boolean success = false;
            while (!success) {
                try {
                    JSONObject obj = new JSONObject();
                    obj.put("success", successParam);
                    log.logInfo("Issuing PUT request to '" + url + "' with body " + obj);
                    HttpUtil.HttpResult response = HttpUtil.put(new URI(url), obj, e -> {
                        e.setConnectTimeout(10000);
                        e.setReadTimeout(10000);
                    });
                    if (response.responseCode == 200) {
                        success = true;
                        backoffUtil.successReset();
                        continue;
                    }
                    success = false;
                }
                catch (Throwable t) {
                    log.logError("Unable to inform server of watch status for '" + ptw.getProjectWatchStateId() + "'", t);
                    success = false;
                    backoffUtil.sleepIgnoreInterrupt();
                    backoffUtil.failIncrease();
                }
            }
        });
    }

    private static class FilewatcherWatchListener
    implements IPlatformWatchService.IPlatformWatchListener {
        private final Filewatcher parent;

        private FilewatcherWatchListener(Filewatcher parent) {
            this.parent = parent;
        }

        @Override
        public void changeDetected(List<WatchEventEntry> entries) {
            long receivedAt = System.currentTimeMillis();
            this.parent.receiveNewWatchEventEntries(entries, receivedAt);
        }

        @Override
        public void watchAdded(ProjectToWatch ptw, boolean success) {
            this.parent.receiveWatchSuccessStatus(ptw, success);
        }
    }

    private static class ProjectObject {
        private final FileChangeEventBatchUtil batchUtil;
        private ProjectToWatch project_synch_lock;
        private final IPlatformWatchService watchService;
        private final Optional<CLIState> cliState;
        private final Object lock = new Object();

        public ProjectObject(String projectId, ProjectToWatch project, Filewatcher parent, IPlatformWatchService watchService) {
            if (projectId == null || project == null || watchService == null) {
                throw new IllegalArgumentException("Invalid arg: " + projectId + " " + project + " " + watchService);
            }
            this.project_synch_lock = project;
            this.batchUtil = new FileChangeEventBatchUtil(parent, projectId);
            this.watchService = watchService;
            this.cliState = parent.pathToInstaller.isPresent() ? Optional.of(new CLIState(projectId, (String)parent.pathToInstaller.get(), PathUtils.convertAbsoluteUnixStyleNormalizedPathToLocalFile(project.getPathToMonitor()))) : Optional.empty();
        }

        private FileChangeEventBatchUtil getEventBatchUtil() {
            return this.batchUtil;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ProjectToWatch getProjectToWatch() {
            Object object = this.lock;
            synchronized (object) {
                return this.project_synch_lock;
            }
        }

        private void informCwctlOfFileChanges() {
            ProjectToWatch ptw = this.getProjectToWatch();
            if (this.cliState.isPresent()) {
                this.cliState.get().onFileChangeEvent(ptw.getProjectCreationTimeInAbsoluteMsecs().orElse(null));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateProjectToWatch(ProjectToWatch newProjectToWatch) {
            Object object = this.lock;
            synchronized (object) {
                ProjectToWatch existingProjectToWatch = this.project_synch_lock;
                if (!existingProjectToWatch.getPathToMonitor().equals(newProjectToWatch.getPathToMonitor())) {
                    String msg = "The path to monitor of a project cannot be changed once it is set, for a particular project id";
                    log.logSevere(msg, null, existingProjectToWatch.getProjectId());
                }
                this.project_synch_lock = newProjectToWatch;
            }
        }

        public IPlatformWatchService getWatchService() {
            return this.watchService;
        }
    }
}

