/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.ui.internal.prefs;

import org.eclipse.codewind.core.CodewindCorePlugin;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.core.internal.connection.CodewindConnection;
import org.eclipse.codewind.core.internal.connection.CodewindConnectionManager;
import org.eclipse.codewind.ui.CodewindUIPlugin;
import org.eclipse.codewind.ui.internal.messages.Messages;
import org.eclipse.codewind.ui.internal.wizards.NewCodewindConnectionWizard;
import org.eclipse.codewind.ui.internal.wizards.WizardLauncher;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class CodewindConnectionPrefsPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String MC_CONNECTIONS_PREFSKEY = "org.eclipse.codewind.ui.prefs.connections";
    public static final String PAGE_ID = "CodewindConnectionsPage";
    private Table connectionsTable;

    public CodewindConnectionPrefsPage() {
        super(Messages.ConnectionPrefsPage_ShellTitle, CodewindUIPlugin.getImageDescriptor("codewind.png"));
        this.setMessage(Messages.ConnectionPrefsPage_PageTitle);
    }

    public void init(IWorkbench arg0) {
        this.setPreferenceStore((IPreferenceStore)new ScopedPreferenceStore(ConfigurationScope.INSTANCE, MC_CONNECTIONS_PREFSKEY));
        this.noDefaultAndApplyButton();
    }

    protected Control createContents(Composite parent) {
        parent.setLayout((Layout)new GridLayout(2, false));
        Label existingConnections = new Label(parent, 0);
        existingConnections.setText(Messages.ConnectionPrefsPage_TableTitleLabel);
        GridData gridData = new GridData(4, 4, false, false, 2, 1);
        existingConnections.setLayoutData((Object)gridData);
        this.connectionsTable = new Table(parent, 68354);
        this.connectionsTable.setLinesVisible(true);
        this.connectionsTable.setHeaderVisible(true);
        gridData = new GridData(4, 4, true, true, 1, 2);
        gridData.widthHint = 450;
        gridData.heightHint = 300;
        this.connectionsTable.setLayoutData((Object)gridData);
        TableColumn urlsCol = new TableColumn(this.connectionsTable, 2048);
        urlsCol.setText(Messages.ConnectionPrefsPage_URLColumn);
        urlsCol.setWidth(gridData.widthHint / 2);
        Button addButton = new Button(parent, 8);
        addButton.setText(Messages.ConnectionPrefsPage_AddBtn);
        gridData = new GridData(4, 1, false, false);
        addButton.setLayoutData((Object)gridData);
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                NewCodewindConnectionWizard wizard = new NewCodewindConnectionWizard();
                WizardLauncher.launchWizardWithoutSelection(wizard);
            }
        });
        final Button removeButton = new Button(parent, 8);
        removeButton.setText(Messages.ConnectionPrefsPage_RemoveBtn);
        gridData = new GridData(4, 1, false, false);
        removeButton.setLayoutData((Object)gridData);
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                int[] selected;
                for (int i : selected = CodewindConnectionPrefsPage.this.connectionsTable.getSelectionIndices()) {
                    String url = CodewindConnectionPrefsPage.this.connectionsTable.getItem(i).getText(0);
                    CodewindConnectionManager.remove((String)url);
                }
                CodewindConnectionPrefsPage.this.refreshConnectionsList();
                CodewindConnectionPrefsPage.this.connectionsTable.setSelection(selected);
            }
        });
        this.connectionsTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int count = CodewindConnectionPrefsPage.this.connectionsTable.getSelectionCount();
                if (count > 0) {
                    removeButton.setEnabled(true);
                } else {
                    removeButton.setEnabled(false);
                }
            }
        });
        this.refreshConnectionsList();
        addButton.setEnabled(true);
        removeButton.setEnabled(false);
        CodewindCorePlugin.getDefault().getPreferenceStore().addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty() == "codewindConnections") {
                    Logger.log((String)"Reloading preferences in MCCPP");
                    CodewindConnectionPrefsPage.this.refreshConnectionsList();
                }
            }
        });
        return parent;
    }

    private void refreshConnectionsList() {
        if (!this.connectionsTable.isDisposed()) {
            this.connectionsTable.removeAll();
        }
        for (CodewindConnection mcc : CodewindConnectionManager.activeConnections()) {
            this.addTableRow(mcc.getBaseURI().toString(), false);
        }
    }

    private void addTableRow(String url, boolean isBroken) {
        block2: {
            try {
                TableItem ti = new TableItem(this.connectionsTable, 0);
                ti.setText(new String[]{url.toString()});
            }
            catch (SWTException e) {
                if ("Widget is disposed".equals(e.getMessage())) break block2;
                throw e;
            }
        }
    }
}

