/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.core.internal.cli;

import java.io.IOException;
import java.util.concurrent.TimeoutException;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.core.internal.ProcessHelper;
import org.eclipse.codewind.core.internal.cli.CLIUtil;
import org.eclipse.codewind.core.internal.messages.Messages;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;
import org.json.JSONException;
import org.json.JSONObject;

public class ConnectionUtil {
    private static final String CONNECTIONS_CMD = "connections";
    private static final String ADD_OPTION = "add";
    private static final String REMOVE_OPTION = "remove";
    private static final String INSECURE_OPTION = "--insecure";
    private static final String LABEL_OPTION = "--label";
    private static final String URL_OPTION = "--url";
    private static final String CON_ID_OPTION = "--conid";
    private static final String STATUS_KEY = "status";
    private static final String STATUS_MSG_KEY = "status_message";
    private static final String ID_KEY = "id";
    private static final String ERROR_KEY = "error";
    private static final String ERROR_DESCRIPTION_KEY = "error_description";
    private static final String STATUS_OK_VALUE = "OK";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String addConnection(String name, String url, IProgressMonitor monitor) throws IOException, JSONException, TimeoutException {
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (String)NLS.bind((String)Messages.RegisterConnectionTaskLabel, (Object)name), (int)100);
        Process process = null;
        try {
            process = CLIUtil.runCWCTL(INSECURE_OPTION, CONNECTIONS_CMD, ADD_OPTION, LABEL_OPTION, name, URL_OPTION, url);
            ProcessHelper.ProcessResult result = ProcessHelper.waitForProcess(process, 500, 60, (IProgressMonitor)mon);
            if (result.getExitValue() != 0) {
                Logger.logError("Connection add failed with rc: " + result.getExitValue() + " and error: " + result.getErrorMsg());
                throw new IOException(result.getErrorMsg());
            }
            if (result.getOutput() == null || result.getOutput().trim().isEmpty()) {
                Logger.logError("Connection add had 0 return code but the output is empty");
                throw new IOException("The output from connection add is empty.");
            }
            JSONObject resultJson = new JSONObject(result.getOutput());
            if (!resultJson.has(STATUS_KEY) || !STATUS_OK_VALUE.equals(resultJson.getString(STATUS_KEY))) {
                String errorMsg = ConnectionUtil.getErrorMsg(resultJson);
                String msg = "Connection add failed for: " + name;
                if (errorMsg != null) {
                    msg = msg + " with output: " + errorMsg;
                }
                Logger.logError(msg);
                throw new IOException(msg);
            }
            String string = resultJson.getString(ID_KEY);
            return string;
        }
        finally {
            if (process != null && process.isAlive()) {
                process.destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeConnection(String name, String conid, IProgressMonitor monitor) throws IOException, JSONException, TimeoutException {
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (String)NLS.bind((String)Messages.DeregisterConnectionTaskLabel, (Object)name), (int)100);
        Process process = null;
        try {
            process = CLIUtil.runCWCTL(INSECURE_OPTION, CONNECTIONS_CMD, REMOVE_OPTION, CON_ID_OPTION, conid);
            ProcessHelper.ProcessResult result = ProcessHelper.waitForProcess(process, 500, 60, (IProgressMonitor)mon);
            if (result.getExitValue() != 0) {
                Logger.logError("Connection remove failed with rc: " + result.getExitValue() + " and error: " + result.getErrorMsg());
                throw new IOException(result.getErrorMsg());
            }
            if (result.getOutput() == null || result.getOutput().trim().isEmpty()) {
                Logger.logError("Connection remove had 0 return code but the output is empty");
                throw new IOException("The output from connection remove is empty.");
            }
            JSONObject resultJson = new JSONObject(result.getOutput());
            if (!resultJson.has(STATUS_KEY) || !STATUS_OK_VALUE.equals(resultJson.getString(STATUS_KEY))) {
                String errorMsg = ConnectionUtil.getErrorMsg(resultJson);
                String msg = "Connection remove failed for: " + name;
                if (errorMsg != null) {
                    msg = msg + " with output: " + errorMsg;
                }
                Logger.logError(msg);
                throw new IOException(msg);
            }
        }
        finally {
            if (process != null && process.isAlive()) {
                process.destroy();
            }
        }
    }

    private static String getErrorMsg(JSONObject resultJson) throws JSONException {
        String errorMsg = null;
        if (resultJson.has(ERROR_DESCRIPTION_KEY)) {
            errorMsg = resultJson.getString(ERROR_DESCRIPTION_KEY);
        } else if (resultJson.has(STATUS_MSG_KEY)) {
            errorMsg = resultJson.getString(STATUS_MSG_KEY);
        }
        return errorMsg;
    }
}

