/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.core.internal.cli;

import java.io.IOException;
import java.util.concurrent.TimeoutException;
import org.eclipse.codewind.core.CodewindCorePlugin;
import org.eclipse.codewind.core.internal.CodewindManager;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.core.internal.ProcessHelper;
import org.eclipse.codewind.core.internal.cli.CLIUtil;
import org.eclipse.codewind.core.internal.cli.InstallStatus;
import org.eclipse.codewind.core.internal.messages.Messages;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.osgi.util.NLS;
import org.json.JSONException;
import org.json.JSONObject;

public class InstallUtil {
    public static final String STOP_APP_CONTAINERS_PREFSKEY = "stopAppContainers";
    public static final String STOP_APP_CONTAINERS_ALWAYS = "stopAppContainersAlways";
    public static final String STOP_APP_CONTAINERS_NEVER = "stopAppContainersNever";
    public static final String STOP_APP_CONTAINERS_PROMPT = "stopAppContainersPrompt";
    public static final String STOP_APP_CONTAINERS_DEFAULT = "stopAppContainersPrompt";
    public static final int INSTALL_TIMEOUT_DEFAULT = 300;
    public static final int UNINSTALL_TIMEOUT_DEFAULT = 60;
    public static final int START_TIMEOUT_DEFAULT = 60;
    public static final int STOP_TIMEOUT_DEFAULT = 300;
    private static final String INSTALL_CMD = "install";
    private static final String START_CMD = "start";
    private static final String STOP_CMD = "stop";
    private static final String STOP_ALL_CMD = "stop-all";
    private static final String STATUS_CMD = "status";
    private static final String REMOVE_CMD = "remove";
    private static final String UPGRADE_CMD = "upgrade";
    public static final String DEFAULT_INSTALL_VERSION = "0.6.0";
    private static final String TAG_OPTION = "-t";
    private static final String INSTALL_VERSION_VAR = "INSTALL_VERSION";
    private static final String CW_TAG_VAR = "CW_TAG";
    private static final String WORKSPACE_OPTION = "--workspace";
    private static String installVersion = null;
    private static String requestedVersion = null;

    public static InstallStatus getInstallStatus(IProgressMonitor monitor) throws IOException, JSONException, TimeoutException {
        ProcessHelper.ProcessResult result = InstallUtil.statusCodewind(monitor);
        if (result.getExitValue() != 0) {
            String error = result.getError();
            if (error == null || error.isEmpty()) {
                error = result.getOutput();
            }
            String msg = "Installer status command failed with rc: " + result.getExitValue() + " and error: " + error;
            Logger.logError(msg);
            throw new IOException(msg);
        }
        JSONObject status = new JSONObject(result.getOutput());
        return new InstallStatus(status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProcessHelper.ProcessResult startCodewind(String version, IProgressMonitor monitor) throws IOException, TimeoutException {
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.StartCodewindJobLabel, (int)100);
        Process process = null;
        try {
            ProcessHelper.ProcessResult result;
            CodewindManager.getManager().setInstallerStatus(CodewindManager.InstallerStatus.STARTING);
            process = CLIUtil.runCWCTL(START_CMD, TAG_OPTION, version);
            ProcessHelper.ProcessResult processResult = result = ProcessHelper.waitForProcess(process, 500, InstallUtil.getPrefs().getInt("cwStartTimeout"), (IProgressMonitor)mon.split(90));
            return processResult;
        }
        finally {
            if (process != null && process.isAlive()) {
                process.destroy();
            }
            CodewindManager.getManager().refreshInstallStatus((IProgressMonitor)mon.split(10));
            CodewindManager.getManager().setInstallerStatus(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProcessHelper.ProcessResult stopCodewind(boolean stopAll, IProgressMonitor monitor) throws IOException, TimeoutException {
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.StopCodewindJobLabel, (int)100);
        Process process = null;
        try {
            ProcessHelper.ProcessResult result;
            CodewindManager.getManager().setInstallerStatus(CodewindManager.InstallerStatus.STOPPING);
            process = CLIUtil.runCWCTL(stopAll ? STOP_ALL_CMD : STOP_CMD, new String[0]);
            ProcessHelper.ProcessResult processResult = result = ProcessHelper.waitForProcess(process, 500, InstallUtil.getPrefs().getInt("cwStopTimeout"), (IProgressMonitor)mon.split(95));
            return processResult;
        }
        finally {
            if (process != null && process.isAlive()) {
                process.destroy();
            }
            CodewindManager.getManager().refreshInstallStatus((IProgressMonitor)mon.split(5));
            CodewindManager.getManager().setInstallerStatus(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProcessHelper.ProcessResult installCodewind(String version, IProgressMonitor monitor) throws IOException, TimeoutException {
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.InstallCodewindJobLabel, (int)100);
        Process process = null;
        try {
            ProcessHelper.ProcessResult result;
            CodewindManager.getManager().setInstallerStatus(CodewindManager.InstallerStatus.INSTALLING);
            process = CLIUtil.runCWCTL(INSTALL_CMD, TAG_OPTION, version);
            ProcessHelper.ProcessResult processResult = result = ProcessHelper.waitForProcess(process, 1000, InstallUtil.getPrefs().getInt("cwInstallTimeout"), (IProgressMonitor)mon.split(95));
            return processResult;
        }
        finally {
            if (process != null && process.isAlive()) {
                process.destroy();
            }
            CodewindManager.getManager().refreshInstallStatus((IProgressMonitor)mon.split(5));
            CodewindManager.getManager().setInstallerStatus(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProcessHelper.ProcessResult removeCodewind(String version, IProgressMonitor monitor) throws IOException, TimeoutException {
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.RemovingCodewindJobLabel, (int)100);
        Process process = null;
        try {
            ProcessHelper.ProcessResult result;
            CodewindManager.getManager().setInstallerStatus(CodewindManager.InstallerStatus.UNINSTALLING);
            process = version != null ? CLIUtil.runCWCTL(REMOVE_CMD, TAG_OPTION, version) : CLIUtil.runCWCTL(REMOVE_CMD, new String[0]);
            ProcessHelper.ProcessResult processResult = result = ProcessHelper.waitForProcess(process, 500, InstallUtil.getPrefs().getInt("cwUninstallTimeout"), (IProgressMonitor)mon.split(90));
            return processResult;
        }
        finally {
            if (process != null && process.isAlive()) {
                process.destroy();
            }
            CodewindManager.getManager().refreshInstallStatus((IProgressMonitor)mon.split(10));
            CodewindManager.getManager().setInstallerStatus(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProcessHelper.ProcessResult upgradeWorkspace(String path, IProgressMonitor monitor) throws IOException, TimeoutException {
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (String)NLS.bind((String)Messages.UpgradeWorkspaceJobLabel, (Object)path), (int)100);
        Process process = null;
        try {
            ProcessHelper.ProcessResult result;
            process = CLIUtil.runCWCTL(UPGRADE_CMD, WORKSPACE_OPTION, path);
            ProcessHelper.ProcessResult processResult = result = ProcessHelper.waitForProcess(process, 500, 300, (IProgressMonitor)mon);
            return processResult;
        }
        finally {
            if (process != null && process.isAlive()) {
                process.destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ProcessHelper.ProcessResult statusCodewind(IProgressMonitor monitor) throws IOException, TimeoutException {
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.CodewindStatusJobLabel, (int)100);
        Process process = null;
        try {
            ProcessHelper.ProcessResult result;
            process = CLIUtil.runCWCTL(STATUS_CMD, "--json");
            ProcessHelper.ProcessResult processResult = result = ProcessHelper.waitForProcess(process, 500, 120, (IProgressMonitor)mon);
            return processResult;
        }
        finally {
            if (process != null && process.isAlive()) {
                process.destroy();
            }
        }
    }

    public static String getRequestedVersion() {
        if (requestedVersion == null) {
            String value = System.getenv(CW_TAG_VAR);
            if (value == null || value.isEmpty()) {
                value = System.getenv(INSTALL_VERSION_VAR);
            }
            if (value != null && !value.isEmpty()) {
                requestedVersion = value;
            }
        }
        return requestedVersion;
    }

    public static String getVersion() {
        if (installVersion == null) {
            String requestedVersion = InstallUtil.getRequestedVersion();
            installVersion = requestedVersion != null ? requestedVersion : DEFAULT_INSTALL_VERSION;
        }
        return installVersion;
    }

    private static IPreferenceStore getPrefs() {
        return CodewindCorePlugin.getDefault().getPreferenceStore();
    }
}

