/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.filewatchers.core.internal;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.codewind.filewatchers.core.FWLogger;
import org.eclipse.codewind.filewatchers.core.FilewatcherUtils;

public class CLIState {
    private final String projectId;
    private long timestamp_synch_lock = 0L;
    private final String installerPath;
    private final String projectPath;
    private final String mockInstallerPath;
    private final FWLogger log = FWLogger.getInstance();
    private boolean processActive_synch_lock = false;
    private boolean requestWaiting_synch_lock = false;
    private final Object lock = new Object();

    public CLIState(String projectId, String installerPath, String projectPath) {
        if (installerPath == null) {
            throw new RuntimeException("Installer path is null: " + installerPath);
        }
        this.projectId = projectId;
        this.installerPath = installerPath;
        this.projectPath = projectPath;
        this.mockInstallerPath = System.getenv("MOCK_CWCTL_INSTALLER_PATH");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFileChangeEvent(Long projectCreationTimeInAbsoluteMsecsParam) {
        if (this.projectPath == null || this.projectPath.trim().isEmpty()) {
            this.log.logSevere("Project path passed to CLIState is empty, so ignoring file change event.");
            return;
        }
        boolean callCLI = false;
        Object object = this.lock;
        synchronized (object) {
            if (this.processActive_synch_lock) {
                this.requestWaiting_synch_lock = true;
            } else {
                this.processActive_synch_lock = true;
                this.requestWaiting_synch_lock = false;
                callCLI = true;
            }
        }
        if (callCLI) {
            Long debugOldTimestampValue = null;
            Long debugNewTimestampValue = null;
            boolean timestampUpdated = false;
            Object object2 = this.lock;
            synchronized (object2) {
                if (projectCreationTimeInAbsoluteMsecsParam != null && this.timestamp_synch_lock == 0L) {
                    debugOldTimestampValue = this.timestamp_synch_lock;
                    this.timestamp_synch_lock = projectCreationTimeInAbsoluteMsecsParam;
                    debugNewTimestampValue = this.timestamp_synch_lock;
                    timestampUpdated = true;
                }
            }
            if (timestampUpdated) {
                this.log.logInfo("Timestamp updated from " + debugOldTimestampValue + " to " + debugNewTimestampValue + " from project creation time.");
            }
            FilewatcherUtils.newThread(() -> this.callCLI());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void callCLI() {
        Object object;
        block14: {
            Object object2 = this.lock;
            synchronized (object2) {
                if (!this.processActive_synch_lock) {
                    this.log.logSevere(CLIState.class.getSimpleName() + ".callCLI() was called while the processActive value was false. This should never happen.");
                }
            }
            boolean DEBUG_FAKE_CMD_OUTPUT = false;
            try {
                RunProjectReturn result = this.runProjectCommand();
                if (result == null) break block14;
                if (result.errorCode != 0) {
                    this.log.logSevere("Non-zero error code from installer: " + (result != null && result.output != null ? result.output : ""));
                    break block14;
                }
                object = this.lock;
                synchronized (object) {
                    this.timestamp_synch_lock = result.spawnTime;
                    this.log.logInfo("Updating timestamp to latest: " + this.timestamp_synch_lock);
                }
            }
            catch (Throwable e) {
                this.log.logSevere("Unexpected exception from CLI", e, this.projectId);
            }
        }
        boolean requestWaiting = false;
        object = this.lock;
        synchronized (object) {
            this.processActive_synch_lock = false;
            requestWaiting = this.requestWaiting_synch_lock;
        }
        if (requestWaiting) {
            this.onFileChangeEvent(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RunProjectReturn runProjectCommand() throws IOException, InterruptedException {
        long latestTimestamp;
        String currInstallerPath = this.installerPath;
        ArrayList<String> args = new ArrayList<String>();
        Object object = this.lock;
        synchronized (object) {
            latestTimestamp = this.timestamp_synch_lock;
        }
        if (this.mockInstallerPath == null || this.mockInstallerPath.trim().isEmpty()) {
            args.add(this.installerPath);
            args.addAll(Arrays.asList("project", "sync", "-p", this.projectPath, "-i", this.projectId, "-t", "" + latestTimestamp));
        } else {
            args.add("java");
            args.addAll(Arrays.asList("-jar", this.mockInstallerPath, "-p", this.projectPath, "-i", this.projectId, "-t", "" + latestTimestamp));
            currInstallerPath = this.mockInstallerPath;
        }
        String debugStr = args.stream().map(e -> "[" + e + "] ").reduce((a, b) -> a + b).get();
        this.log.logInfo("Calling cwctl project sync with: [" + this.projectId + "] { " + debugStr + "}");
        String installerPwd = new File(currInstallerPath).getParent();
        long spawnTime = System.currentTimeMillis();
        ProcessBuilder pb = new ProcessBuilder(args);
        pb.directory(new File(installerPwd));
        Process p = pb.start();
        ReadThread inputStreamThread = new ReadThread(p.getInputStream(), null);
        inputStreamThread.start();
        ReadThread errorStreamThread = new ReadThread(p.getErrorStream(), null);
        errorStreamThread.start();
        int result = p.waitFor();
        this.log.logInfo("Cwctl call completed, elapsed time of cwctl call: " + (System.currentTimeMillis() - spawnTime));
        String stdout = inputStreamThread.getOutput();
        String stderr = errorStreamThread.getOutput();
        if (result != 0) {
            this.log.logError("Error running 'project sync' installer command");
            this.log.logError("Stdout: " + stdout);
            this.log.logError("Stderr:" + stderr);
            return new RunProjectReturn(result, stdout + stderr, spawnTime);
        }
        this.log.logInfo("Successfully ran installer command: " + debugStr);
        this.log.logInfo("Output:" + stdout + stderr);
        return new RunProjectReturn(result, stdout, spawnTime);
    }

    private class ReadThread
    extends Thread {
        final InputStream is;
        final PrintStream ps;
        private final StringBuilder received_synch = new StringBuilder();
        private boolean isFinished = false;

        public ReadThread(InputStream is, PrintStream ps) {
            this.is = is;
            this.ps = ps;
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            BufferedReader br = new BufferedReader(new InputStreamReader(this.is));
            try {
                String str;
                while (null != (str = br.readLine())) {
                    if (this.ps != null) {
                        this.ps.append(str + "\n");
                    }
                    StringBuilder stringBuilder = this.received_synch;
                    synchronized (stringBuilder) {
                        this.received_synch.append(str + "\n");
                    }
                }
                this.isFinished = true;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String getOutput() {
            StringBuilder stringBuilder = this.received_synch;
            synchronized (stringBuilder) {
                return this.received_synch.toString();
            }
        }
    }

    private static class RunProjectReturn {
        int errorCode;
        String output;
        long spawnTime;

        public RunProjectReturn(int errorCode, String output, long spawnTime) {
            this.errorCode = errorCode;
            this.output = output;
            this.spawnTime = spawnTime;
        }
    }
}

