/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.ui.internal.wizards;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.codewind.core.internal.CodewindObjectFactory;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.core.internal.cli.AuthToken;
import org.eclipse.codewind.core.internal.cli.AuthUtil;
import org.eclipse.codewind.core.internal.cli.ConnectionUtil;
import org.eclipse.codewind.core.internal.connection.CodewindConnection;
import org.eclipse.codewind.core.internal.connection.CodewindConnectionManager;
import org.eclipse.codewind.ui.internal.IDEUtil;
import org.eclipse.codewind.ui.internal.messages.Messages;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.json.JSONException;

public class CodewindConnectionComposite
extends Composite {
    private Container container;
    private CodewindConnection connection;
    private Text connNameText;
    private Text connURLText;
    private Text connUserText;
    private Text connPassText;
    private Button connTestButton;
    private Group regGroup;
    private Text regURLText;
    private Text regUserText;
    private Text regPassText;
    private Button regTestButton;
    private boolean regTested = false;

    public CodewindConnectionComposite(Composite parent, Container container) {
        super(parent, 0);
        this.container = container;
        this.createControl();
    }

    protected void createControl() {
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = 8;
        layout.verticalSpacing = 20;
        this.setLayout((Layout)layout);
        Group connGroup = new Group((Composite)this, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 8;
        layout.marginWidth = 8;
        layout.horizontalSpacing = 7;
        layout.verticalSpacing = 7;
        connGroup.setLayout((Layout)layout);
        GridData data = new GridData(4, 1, true, false);
        connGroup.setLayoutData((Object)data);
        connGroup.setText(Messages.CodewindConnectionComposite_ConnDetailsGroup);
        Text connGroupLabel = new Text((Composite)connGroup, 74);
        connGroupLabel.setText(Messages.CodewindConnectionComposite_ConnDetailsInstructions);
        data = new GridData(4, 0x1000000, false, false, 2, 1);
        data.widthHint = 250;
        connGroupLabel.setLayoutData((Object)data);
        IDEUtil.normalizeBackground((Control)connGroupLabel, (Control)this);
        this.createLabel(Messages.CodewindConnectionComposite_ConnNameLabel, (Composite)connGroup, 1, 15);
        this.connNameText = this.createConnText((Composite)connGroup, 0, 1);
        this.createLabel(Messages.CodewindConnectionComposite_UrlLabel, (Composite)connGroup, 1, 15);
        this.connURLText = this.createConnText((Composite)connGroup, 0, 1);
        this.createLabel(Messages.CodewindConnectionComposite_UserLabel, (Composite)connGroup, 1, 15);
        this.connUserText = this.createConnText((Composite)connGroup, 0, 1);
        this.createLabel(Messages.CodewindConnectionComposite_PasswordLabel, (Composite)connGroup, 1, 15);
        this.connPassText = this.createConnText((Composite)connGroup, 0x400000, 1);
        this.connTestButton = new Button((Composite)connGroup, 8);
        this.connTestButton.setText(Messages.CodewindConnectionComposite_TestConnButton);
        this.connTestButton.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false, 2, 1));
        this.connTestButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                CodewindConnectionComposite.this.testConnection();
                CodewindConnectionComposite.this.validateAndUpdate();
            }
        });
        this.regGroup = new Group((Composite)this, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 8;
        layout.marginWidth = 8;
        layout.horizontalSpacing = 7;
        layout.verticalSpacing = 7;
        this.regGroup.setLayout((Layout)layout);
        data = new GridData(4, 1, true, false);
        this.regGroup.setLayoutData((Object)data);
        this.regGroup.setText(Messages.CodewindConnectionComposite_RegDetailsGroup);
        Text regGroupLabel = new Text((Composite)this.regGroup, 74);
        regGroupLabel.setText(Messages.CodewindConnectionComposite_RegDetailsInstructions);
        data = new GridData(4, 0x1000000, false, false, 2, 1);
        data.widthHint = 250;
        regGroupLabel.setLayoutData((Object)data);
        IDEUtil.normalizeBackground((Control)regGroupLabel, (Control)this);
        this.createLabel(Messages.CodewindConnectionComposite_UrlLabel, (Composite)this.regGroup, 1, 15);
        this.regURLText = this.createRegText((Composite)this.regGroup, 0, 1);
        this.createLabel(Messages.CodewindConnectionComposite_UserLabel, (Composite)this.regGroup, 1, 15);
        this.regUserText = this.createRegText((Composite)this.regGroup, 0, 1);
        this.createLabel(Messages.CodewindConnectionComposite_PasswordLabel, (Composite)this.regGroup, 1, 15);
        this.regPassText = this.createRegText((Composite)this.regGroup, 0x400000, 1);
        this.regTestButton = new Button((Composite)this.regGroup, 8);
        this.regTestButton.setText(Messages.CodewindConnectionComposite_TestRegButton);
        this.regTestButton.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false, 2, 1));
        this.regTestButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                CodewindConnectionComposite.this.testRegistry();
                CodewindConnectionComposite.this.validateAndUpdate();
            }
        });
        this.connTestButton.setEnabled(false);
        this.regTestButton.setEnabled(false);
        this.connNameText.setFocus();
    }

    private void createLabel(String labelStr, Composite parent, int horizontalSpan, int horizontalIndent) {
        Label label = new Label(parent, 0);
        label.setText(labelStr);
        GridData data = new GridData(4, 0x1000000, false, false, horizontalSpan, 1);
        data.horizontalIndent = horizontalIndent;
        label.setLayoutData((Object)data);
    }

    private Text createConnText(Composite parent, int styles, int horizontalSpan) {
        Text text = new Text(parent, 0x800 | styles);
        text.setLayoutData((Object)new GridData(4, 0x1000000, true, false, horizontalSpan, 1));
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                CodewindConnectionComposite.this.removePreviousConnection();
                CodewindConnectionComposite.this.validateAndUpdate();
            }
        });
        return text;
    }

    private Text createRegText(Composite parent, int styles, int horizontalSpan) {
        Text text = new Text(parent, 0x800 | styles);
        text.setLayoutData((Object)new GridData(4, 0x1000000, true, false, horizontalSpan, 1));
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                CodewindConnectionComposite.this.regTested = false;
                CodewindConnectionComposite.this.validateAndUpdate();
            }
        });
        return text;
    }

    private void validateAndUpdate() {
        this.validate();
        this.container.update();
    }

    private void validate() {
        String errorMsg = null;
        errorMsg = this.validateConnectionInfo();
        if (errorMsg == null) {
            errorMsg = this.validateRegistryInfo();
        } else {
            this.regTestButton.setEnabled(false);
        }
        this.container.setErrorMessage(errorMsg);
    }

    private String validateConnectionInfo() {
        String name = this.connNameText.getText().trim();
        if (name == null || name.isEmpty()) {
            this.connTestButton.setEnabled(false);
            return Messages.CodewindConnectionComposite_NoConnNameError;
        }
        CodewindConnection existingConnection = CodewindConnectionManager.getActiveConnectionByName((String)name);
        if (existingConnection != null) {
            this.connTestButton.setEnabled(false);
            return NLS.bind((String)Messages.CodewindConnectionComposite_ConnNameInUseError, (Object)name);
        }
        String url = this.connURLText.getText().trim();
        if (!url.isEmpty()) {
            try {
                new URI(url);
            }
            catch (URISyntaxException e) {
                this.connTestButton.setEnabled(false);
                return NLS.bind((String)Messages.CodewindConnectionComposite_InvalidUrlError, (Object)url);
            }
            CodewindConnection existingConnection2 = CodewindConnectionManager.getActiveConnection((String)(url.endsWith("/") ? url : url + "/"));
            if (existingConnection2 != null) {
                this.connTestButton.setEnabled(false);
                return NLS.bind((String)Messages.CodewindConnectionComposite_UrlInUseError, (Object[])new String[]{existingConnection2.getName(), url});
            }
        }
        String user = this.connUserText.getText().trim();
        String pass = this.connPassText.getText().trim();
        if (url.isEmpty() || user.isEmpty() || pass.isEmpty()) {
            this.connTestButton.setEnabled(false);
            return Messages.CodewindConnectionComposite_MissingConnDetailsError;
        }
        this.connTestButton.setEnabled(true);
        if (this.connection == null) {
            return Messages.CodewindConnectionComposite_TestConnMsg;
        }
        return null;
    }

    public String validateRegistryInfo() {
        String url = this.regURLText.getText().trim();
        if (!url.isEmpty()) {
            try {
                new URI(url);
            }
            catch (URISyntaxException e) {
                this.regTestButton.setEnabled(false);
                return NLS.bind((String)Messages.CodewindConnectionComposite_InvalidUrlError, (Object)url);
            }
        }
        String user = this.regUserText.getText().trim();
        String pass = this.regPassText.getText().trim();
        if (url.isEmpty() || user.isEmpty() || pass.isEmpty()) {
            this.regTestButton.setEnabled(false);
            return Messages.CodewindConnectionComposite_MissingRegDetailsError;
        }
        this.regTestButton.setEnabled(true);
        return null;
    }

    public boolean canFinish() {
        return this.connection != null && this.connection.isConnected() && this.regTested;
    }

    void removePreviousConnection() {
        if (this.connection != null) {
            this.connection.close();
            this.connection = null;
        }
    }

    void testConnection() {
        this.removePreviousConnection();
        String urlStr = this.connURLText.getText().trim();
        URI uri = null;
        try {
            uri = new URI(urlStr);
        }
        catch (URISyntaxException e) {
            Logger.logError((Throwable)e);
            this.container.setErrorMessage(e.getMessage());
        }
        if (uri == null) {
            return;
        }
        Logger.log((String)("Validating connection: " + uri));
        this.connection = this.createConnection(this.connNameText.getText().trim(), this.connUserText.getText().trim(), this.connPassText.getText().trim(), uri);
        if (this.connection != null && this.connection.isConnected()) {
            this.container.setErrorMessage(null);
            this.container.setMessage(NLS.bind((String)Messages.CodewindConnectionComposite_ConnectSucceeded, (Object)this.connection.getBaseURI()));
        } else {
            this.container.setErrorMessage(NLS.bind((String)Messages.CodewindConnectionComposite_ErrCouldNotConnect, (Object)uri));
        }
        this.container.update();
    }

    CodewindConnection getConnection() {
        return this.connection;
    }

    private CodewindConnection createConnection(final String name, final String username, final String password, final URI uri) {
        Throwable exception = null;
        final Boolean[] isCanceled = new Boolean[]{false};
        final CodewindConnection[] connResult = new CodewindConnection[1];
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                String conid = null;
                CodewindConnection conn = null;
                SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                mon.setTaskName(NLS.bind((String)Messages.CodewindConnectionComposite_TestConnectionJobLabel, (Object)uri));
                try {
                    CodewindConnectionComposite.this.removePreviousConnection();
                    conid = ConnectionUtil.addConnection((String)name, (String)uri.toString(), (IProgressMonitor)mon.split(10));
                    AuthToken token = AuthUtil.getAuthToken((String)username, (String)password, (String)conid, (IProgressMonitor)mon.split(30));
                    conn = CodewindObjectFactory.createRemoteConnection((String)name, (URI)uri, (String)conid, (AuthToken)token);
                    conn.connect((IProgressMonitor)mon.split(50));
                    connResult[0] = conn;
                }
                catch (Exception e) {
                    if (conn != null) {
                        conn.close();
                    } else if (conid != null) {
                        try {
                            ConnectionUtil.removeConnection((String)name, (String)conid, (IProgressMonitor)mon.split(10));
                        }
                        catch (Exception e2) {
                            Logger.logError((String)("An error occurred trying to de-register connection: " + name), (Throwable)e2);
                        }
                    }
                    throw new InvocationTargetException(e, NLS.bind((String)Messages.CodewindConnectionComposite_ConnErrorMsg, (Object)uri));
                }
                isCanceled[0] = monitor.isCanceled();
            }
        };
        try {
            this.container.run(runnable);
        }
        catch (InvocationTargetException e) {
            Logger.logError((String)("An error occurred trying to connect to Codewind at: " + uri), (Throwable)e);
            exception = e.getCause();
        }
        catch (InterruptedException e) {
            Logger.logError((String)"Codewind connect was interrupted", (Throwable)e);
            exception = e;
        }
        if (isCanceled[0].booleanValue()) {
            return null;
        }
        if (connResult[0] == null || !connResult[0].isConnected()) {
            if (exception != null) {
                Logger.logError((String)("Failed to connect to Codewind at: " + uri.toString()), (Throwable)exception);
                MultiStatus errorStatus = IDEUtil.getMultiStatus(NLS.bind((String)Messages.CodewindConnectionComposite_ConnErrorMsg, (Object)uri), exception);
                ErrorDialog.openError((Shell)this.getShell(), (String)Messages.CodewindConnectionComposite_ConnErrorTitle, (String)NLS.bind((String)Messages.CodewindConnectionComposite_ConnErrorMsg, (Object)uri), (IStatus)errorStatus);
            } else {
                Logger.logError((String)("Failed to connect to Codewind at: " + uri.toString()));
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.CodewindConnectionComposite_ConnErrorTitle, (String)Messages.CodewindConnectionComposite_ConnFailed);
            }
        }
        return connResult[0];
    }

    private boolean testRegistry() {
        if (this.connection == null || !this.connection.isConnected()) {
            Logger.logError((String)"Registry test requested but connection is null or not connected");
            return false;
        }
        final String urlStr = this.regURLText.getText().trim();
        final String[] msg = new String[1];
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    msg[0] = CodewindConnectionComposite.this.connection.requestRegistryTest(urlStr);
                }
                catch (Exception e) {
                    throw new InvocationTargetException(e, NLS.bind((String)Messages.CodewindConnectionComposite_RegErrorMsg, (Object)urlStr));
                }
            }
        };
        Throwable exception = null;
        try {
            this.container.run(runnable);
        }
        catch (InvocationTargetException e) {
            Logger.logError((String)("An error occurred trying to test the registry: " + urlStr), (Throwable)e);
            exception = e.getCause();
        }
        catch (InterruptedException e) {
            Logger.logError((String)("Registry test was interrupted for: " + urlStr), (Throwable)e);
            exception = e;
        }
        if (exception != null) {
            Logger.logError((String)("Registry test failed for: " + urlStr), (Throwable)exception);
            MultiStatus errorStatus = IDEUtil.getMultiStatus(NLS.bind((String)Messages.CodewindConnectionComposite_RegErrorMsg, (Object)urlStr), exception);
            ErrorDialog.openError((Shell)this.getShell(), (String)Messages.CodewindConnectionComposite_ConnErrorTitle, (String)NLS.bind((String)Messages.CodewindConnectionComposite_RegErrorMsg, (Object)urlStr), (IStatus)errorStatus);
            return false;
        }
        if (msg[0] != null) {
            Logger.logError((String)("Registry test failed for: " + urlStr + ", with message: " + msg[0]));
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.CodewindConnectionComposite_RegErrorTitle, (String)NLS.bind((String)Messages.CodewindConnectionComposite_RegFailed, (Object)msg[0]));
            return false;
        }
        return true;
    }

    public void setRegistry() throws IOException, JSONException {
        String urlStr = this.regURLText.getText().trim();
        this.connection.requestRegistrySet(urlStr);
    }

    public static interface Container {
        public void setErrorMessage(String var1);

        public void setMessage(String var1);

        public void update();

        public void run(IRunnableWithProgress var1) throws InvocationTargetException, InterruptedException;
    }
}

