/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.ui.internal.actions;

import org.eclipse.codewind.core.internal.CodewindApplication;
import org.eclipse.codewind.core.internal.CoreUtil;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.ui.internal.messages.Messages;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.internal.wizards.datatransfer.SmartImportJob;

public class ImportProjectAction
implements IObjectActionDelegate {
    protected CodewindApplication app;

    public void selectionChanged(IAction action, ISelection selection) {
        Object obj;
        if (!(selection instanceof IStructuredSelection)) {
            action.setEnabled(false);
            return;
        }
        IStructuredSelection sel = (IStructuredSelection)selection;
        if (sel.size() == 1 && (obj = sel.getFirstElement()) instanceof CodewindApplication) {
            this.app = (CodewindApplication)obj;
            if (this.app.isAvailable()) {
                IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.app.name);
                action.setEnabled(project == null || !project.exists());
                return;
            }
        }
        action.setEnabled(false);
    }

    public void run(IAction action) {
        if (this.app == null) {
            Logger.logError((String)"ImportProjectAction ran but no application was selected");
            return;
        }
        ImportProjectAction.importProject(this.app);
    }

    public void setActivePart(IAction arg0, IWorkbenchPart arg1) {
    }

    public static void importProject(CodewindApplication app) {
        try {
            IPath path = app.fullLocalPath;
            SmartImportJob importJob = new SmartImportJob(path.toFile(), null, true, false);
            importJob.schedule();
        }
        catch (Exception e) {
            Logger.logError((String)("Error importing project: " + app.name), (Throwable)e);
            CoreUtil.openDialog((boolean)true, (String)NLS.bind((String)Messages.ImportProjectError, (Object)app.name), (String)e.getMessage());
            return;
        }
    }
}

