/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.ui.internal.wizards;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.TimeoutException;
import java.util.regex.Pattern;
import org.eclipse.codewind.core.internal.CodewindManager;
import org.eclipse.codewind.core.internal.CoreUtil;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.core.internal.ProcessHelper;
import org.eclipse.codewind.core.internal.cli.InstallStatus;
import org.eclipse.codewind.core.internal.cli.InstallUtil;
import org.eclipse.codewind.core.internal.cli.TemplateUtil;
import org.eclipse.codewind.core.internal.connection.CodewindConnection;
import org.eclipse.codewind.core.internal.connection.CodewindConnectionManager;
import org.eclipse.codewind.core.internal.connection.ProjectTemplateInfo;
import org.eclipse.codewind.core.internal.constants.ProjectLanguage;
import org.eclipse.codewind.core.internal.constants.ProjectType;
import org.eclipse.codewind.ui.internal.IDEUtil;
import org.eclipse.codewind.ui.internal.messages.Messages;
import org.eclipse.codewind.ui.internal.prefs.RepositoryManagementDialog;
import org.eclipse.codewind.ui.internal.views.ViewHelper;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.SearchPattern;

public class NewCodewindProjectPage
extends WizardPage {
    private static final Pattern projectNamePattern = Pattern.compile("^[a-zA-Z0-9_.-]+$");
    private static final String defaultLocation = ResourcesPlugin.getWorkspace().getRoot().getLocation().toOSString();
    private CodewindConnection connection;
    private List<ProjectTemplateInfo> templateList;
    private SearchPattern pattern = new SearchPattern(35);
    private Text filterText;
    private Table selectionTable;
    private Text descriptionLabel;
    private Text sourceLabel;
    private Text projectNameText;
    private String projectName;
    private String location = defaultLocation;
    private String savedLocation = "";
    private Button defaultLocationButton;
    private Label locationLabel;
    private Text locationText;
    private Button locationBrowse;

    protected NewCodewindProjectPage(CodewindConnection connection, List<ProjectTemplateInfo> templateList) {
        super(Messages.NewProjectPage_ShellTitle);
        this.setTitle(Messages.NewProjectPage_WizardTitle);
        this.setDescription(Messages.NewProjectPage_WizardDescription);
        this.connection = connection;
        this.templateList = templateList;
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        if (this.connection == null) {
            this.setupConnection();
            if (this.connection == null) {
                this.setErrorMessage(Messages.NewProjectPage_CodewindConnectError);
                this.setControl((Control)composite);
                return;
            }
        }
        if (this.templateList == null || this.templateList.isEmpty()) {
            try {
                this.templateList = this.connection.requestProjectTemplates(true);
            }
            catch (Exception e) {
                Logger.logError((String)"An error occurred trying to get the list of templates", (Throwable)e);
                this.setErrorMessage(Messages.NewProjectPage_TemplateListError);
                this.setControl((Control)composite);
                return;
            }
        }
        if (this.templateList.isEmpty()) {
            this.setErrorMessage(Messages.NewProjectPage_EmptyTemplateList);
        } else {
            this.templateList.sort(new Comparator<ProjectTemplateInfo>(){

                @Override
                public int compare(ProjectTemplateInfo info1, ProjectTemplateInfo info2) {
                    return info1.getLabel().compareTo(info2.getLabel());
                }
            });
        }
        this.createContents(composite);
        this.setControl((Control)composite);
    }

    private void createContents(final Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.horizontalSpacing = 8;
        layout.verticalSpacing = 20;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        Label label = new Label(composite, 0);
        label.setText(Messages.NewProjectPage_ProjectNameLabel);
        this.projectNameText = new Text(composite, 2048);
        this.projectNameText.setLayoutData((Object)new GridData(4, 2, true, false));
        Group locationGroup = new Group(composite, 0);
        locationGroup.setText(Messages.NewProjectPage_LocationGroupLabel);
        locationGroup.setLayout((Layout)new GridLayout(3, false));
        locationGroup.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        this.defaultLocationButton = new Button((Composite)locationGroup, 32);
        this.defaultLocationButton.setText(Messages.NewProjectPage_LocationDefaultButton);
        this.defaultLocationButton.setLayoutData((Object)new GridData(1, 2, false, false, 3, 1));
        this.locationLabel = new Label((Composite)locationGroup, 0);
        this.locationLabel.setText(Messages.NewProjectPage_LocationTextLabel);
        this.locationLabel.setLayoutData((Object)new GridData(1, 2, false, false));
        this.locationText = new Text((Composite)locationGroup, 2048);
        this.locationText.setLayoutData((Object)new GridData(4, 2, true, false));
        this.locationBrowse = new Button((Composite)locationGroup, 8);
        this.locationBrowse.setText(Messages.NewProjectPage_LocationBrowseButton);
        this.defaultLocationButton.setSelection(true);
        this.locationText.setText(defaultLocation);
        this.enableLocationWidgets(false);
        this.defaultLocationButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                boolean selected = NewCodewindProjectPage.this.defaultLocationButton.getSelection();
                if (selected) {
                    NewCodewindProjectPage.this.savedLocation = NewCodewindProjectPage.this.locationText.getText().trim();
                    NewCodewindProjectPage.this.location = NewCodewindProjectPage.this.getDefaultLocation(NewCodewindProjectPage.this.projectName);
                    NewCodewindProjectPage.this.locationText.setText(NewCodewindProjectPage.this.location);
                } else {
                    NewCodewindProjectPage.this.locationText.setText(NewCodewindProjectPage.this.savedLocation);
                    NewCodewindProjectPage.this.location = NewCodewindProjectPage.this.savedLocation;
                }
                NewCodewindProjectPage.this.enableLocationWidgets(!selected);
                NewCodewindProjectPage.this.setPageComplete(NewCodewindProjectPage.this.validate());
            }
        });
        this.locationText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                NewCodewindProjectPage.this.location = NewCodewindProjectPage.this.locationText.getText().trim();
                NewCodewindProjectPage.this.setPageComplete(NewCodewindProjectPage.this.validate());
            }
        });
        this.locationBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                DirectoryDialog dialog = new DirectoryDialog(parent.getShell());
                String selectedDirectory = dialog.open();
                if (selectedDirectory != null && !selectedDirectory.trim().isEmpty()) {
                    NewCodewindProjectPage.this.locationText.setText(selectedDirectory.trim());
                    NewCodewindProjectPage.this.location = selectedDirectory.trim();
                } else {
                    NewCodewindProjectPage.this.locationText.setText("");
                    NewCodewindProjectPage.this.location = null;
                }
                NewCodewindProjectPage.this.setPageComplete(NewCodewindProjectPage.this.validate());
            }
        });
        Group templateGroup = new Group(composite, 0);
        templateGroup.setText(Messages.NewProjectPage_TemplateGroupLabel);
        layout = new GridLayout();
        layout.marginHeight = 8;
        layout.marginWidth = 8;
        layout.horizontalSpacing = 7;
        layout.verticalSpacing = 7;
        templateGroup.setLayout((Layout)layout);
        templateGroup.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        Text templateText = new Text((Composite)templateGroup, 8);
        templateText.setText(Messages.NewProjectPage_TemplateGroupDesc);
        templateText.setLayoutData((Object)new GridData(1, 2, false, false));
        IDEUtil.normalizeBackground((Control)templateText, (Control)templateGroup);
        this.filterText = new Text((Composite)templateGroup, 2048);
        this.filterText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.filterText.setMessage(Messages.NewProjectPage_FilterMessage);
        this.selectionTable = new Table((Composite)templateGroup, 68352);
        GridData data = new GridData(4, 4, true, true);
        data.heightHint = 100;
        this.selectionTable.setLayoutData((Object)data);
        final TableColumn templateColumn = new TableColumn(this.selectionTable, 0);
        templateColumn.setText(Messages.NewProjectPage_TemplateColumn);
        templateColumn.setResizable(true);
        templateColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                NewCodewindProjectPage.sortTable(NewCodewindProjectPage.this.selectionTable, templateColumn);
            }
        });
        final TableColumn typeColumn = new TableColumn(this.selectionTable, 0);
        typeColumn.setText(Messages.NewProjectPage_TypeColumn);
        typeColumn.setResizable(true);
        typeColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                NewCodewindProjectPage.sortTable(NewCodewindProjectPage.this.selectionTable, typeColumn);
            }
        });
        final TableColumn languageColumn = new TableColumn(this.selectionTable, 0);
        languageColumn.setText(Messages.NewProjectPage_LanguageColumn);
        languageColumn.setResizable(true);
        languageColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                NewCodewindProjectPage.sortTable(NewCodewindProjectPage.this.selectionTable, languageColumn);
            }
        });
        this.selectionTable.setHeaderVisible(true);
        this.selectionTable.setLinesVisible(false);
        this.selectionTable.setSortDirection(1024);
        this.selectionTable.setSortColumn(templateColumn);
        this.createItems(this.selectionTable, "");
        this.resizeColumns(this.selectionTable);
        ScrolledComposite detailsScroll = new ScrolledComposite((Composite)templateGroup, 512);
        data = new GridData(4, 4, true, false);
        data.widthHint = 300;
        data.heightHint = 70;
        detailsScroll.setLayoutData((Object)data);
        Composite detailsComp = new Composite((Composite)detailsScroll, 0);
        GridLayout detailsLayout = new GridLayout();
        detailsLayout.numColumns = 1;
        detailsComp.setLayout((Layout)detailsLayout);
        detailsComp.setLayoutData((Object)new GridData(4, 4, true, true));
        this.descriptionLabel = new Text(detailsComp, 74);
        this.descriptionLabel.setText("");
        GridData descData = new GridData(4, 2, false, false);
        this.descriptionLabel.setLayoutData((Object)descData);
        IDEUtil.normalizeBackground((Control)this.descriptionLabel, (Control)detailsComp);
        this.sourceLabel = new Text(detailsComp, 74);
        this.sourceLabel.setText("");
        GridData sourceData = new GridData(4, 2, false, false);
        this.descriptionLabel.setLayoutData((Object)sourceData);
        IDEUtil.normalizeBackground((Control)this.sourceLabel, (Control)detailsComp);
        Composite manageReposComp = new Composite(composite, 0);
        manageReposComp.setLayout((Layout)new GridLayout(2, false));
        manageReposComp.setLayoutData((Object)new GridData(3, 4, false, false, 2, 1));
        Label manageRepoLabel = new Label(manageReposComp, 0);
        manageRepoLabel.setText(Messages.NewProjectPage_ManageRepoLabel);
        manageRepoLabel.setLayoutData((Object)new GridData(3, 2, false, false));
        Link manageRepoLink = new Link(manageReposComp, 0);
        manageRepoLink.setText("<a>" + Messages.NewProjectPage_ManageRepoLink + "</a>");
        manageRepoLink.setToolTipText(Messages.NewProjectPage_ManageRepoTooltip);
        manageRepoLink.setLayoutData((Object)new GridData(3, 2, false, false));
        manageRepoLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                block5: {
                    try {
                        List repoList = TemplateUtil.listTemplateSources(null, (IProgressMonitor)new NullProgressMonitor());
                        final RepositoryManagementDialog repoDialog = new RepositoryManagementDialog(NewCodewindProjectPage.this.getShell(), NewCodewindProjectPage.this.connection, repoList);
                        if (repoDialog.open() != 0 || !repoDialog.hasChanges()) break block5;
                        IRunnableWithProgress runnable = new IRunnableWithProgress(){

                            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                                SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.RepoUpdateTask, (int)100);
                                IStatus status = repoDialog.updateRepos((IProgressMonitor)mon.split(75));
                                if (!status.isOK()) {
                                    throw new InvocationTargetException(status.getException(), status.getMessage());
                                }
                                if (mon.isCanceled()) {
                                    return;
                                }
                                try {
                                    mon = mon.split(25);
                                    mon.setTaskName(Messages.NewProjectPage_RefreshTemplatesTask);
                                    NewCodewindProjectPage.this.templateList = NewCodewindProjectPage.this.connection.requestProjectTemplates(true);
                                    mon.worked(25);
                                }
                                catch (Exception e) {
                                    throw new InvocationTargetException(e, Messages.NewProjectPage_RefreshTemplatesError);
                                }
                            }
                        };
                        try {
                            NewCodewindProjectPage.this.getWizard().getContainer().run(true, true, runnable);
                        }
                        catch (InvocationTargetException e) {
                            MessageDialog.openError((Shell)NewCodewindProjectPage.this.getShell(), (String)Messages.RepoUpdateErrorTitle, (String)e.getMessage());
                            return;
                        }
                        catch (InterruptedException e) {
                            return;
                        }
                        NewCodewindProjectPage.this.updateSelectionTable();
                    }
                    catch (Exception e) {
                        MessageDialog.openError((Shell)NewCodewindProjectPage.this.getShell(), (String)Messages.RepoListErrorTitle, (String)NLS.bind((String)Messages.RepoListErrorMsg, (Object)e));
                    }
                }
            }
        });
        this.filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                NewCodewindProjectPage.this.updateSelectionTable();
            }
        });
        this.filterText.addListener(1, new Listener(){

            public void handleEvent(Event event) {
                if (event.keyCode == 0x1000002) {
                    if (NewCodewindProjectPage.this.selectionTable.getItemCount() > 0) {
                        NewCodewindProjectPage.this.selectionTable.setSelection(0);
                        NewCodewindProjectPage.this.updateDetails();
                        NewCodewindProjectPage.this.selectionTable.setFocus();
                    }
                    event.doit = false;
                    NewCodewindProjectPage.this.setPageComplete(NewCodewindProjectPage.this.validate());
                }
            }
        });
        this.selectionTable.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                NewCodewindProjectPage.this.updateDetails();
                NewCodewindProjectPage.this.setPageComplete(NewCodewindProjectPage.this.validate());
            }
        });
        this.projectNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                NewCodewindProjectPage.this.projectName = NewCodewindProjectPage.this.projectNameText.getText().trim();
                if (NewCodewindProjectPage.this.defaultLocationButton.getSelection()) {
                    NewCodewindProjectPage.this.locationText.setText(NewCodewindProjectPage.this.getDefaultLocation(NewCodewindProjectPage.this.projectName));
                }
                NewCodewindProjectPage.this.setPageComplete(NewCodewindProjectPage.this.validate());
            }
        });
        detailsScroll.addListener(11, event -> {
            int width = detailsScroll.getClientArea().width;
            descData.widthHint = width - detailsLayout.marginWidth;
            sourceData.widthHint = width - detailsLayout.marginWidth;
            Point size = detailsComp.computeSize(-1, -1);
            detailsScroll.setMinSize(size);
        });
        detailsScroll.setContent((Control)detailsComp);
        detailsScroll.setExpandHorizontal(true);
        detailsScroll.setExpandVertical(true);
        detailsScroll.setMinSize(detailsScroll.getContent().computeSize(-1, -1));
        if (this.selectionTable.getItemCount() > 0) {
            this.selectionTable.setSelection(0);
        }
        this.updateDetails();
        this.projectNameText.setFocus();
    }

    private void enableLocationWidgets(boolean enabled) {
        this.locationLabel.setEnabled(enabled);
        this.locationText.setEnabled(enabled);
        this.locationBrowse.setEnabled(enabled);
    }

    private String getDefaultLocation(String name) {
        return name.isEmpty() ? defaultLocation : defaultLocation + File.separator + name;
    }

    private boolean validate() {
        if (this.templateList == null || this.templateList.isEmpty()) {
            this.setErrorMessage(Messages.NewProjectPage_EmptyTemplateList);
            return false;
        }
        if (this.projectName == null || this.projectName.isEmpty()) {
            this.setErrorMessage(Messages.NewProjectPage_EmptyProjectName);
            return false;
        }
        if (!projectNamePattern.matcher(this.projectName).matches()) {
            this.setErrorMessage(Messages.NewProjectPage_InvalidProjectName);
            return false;
        }
        if (this.connection.getAppByName(this.projectName) != null) {
            this.setErrorMessage(NLS.bind((String)Messages.NewProjectPage_ProjectExistsError, (Object)this.projectName));
            return false;
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.projectName);
        if (project != null && project.exists()) {
            this.setErrorMessage(NLS.bind((String)Messages.NewProjectPage_EclipseProjectExistsError, (Object)this.projectName));
            return false;
        }
        if (this.location == null || this.location.isEmpty()) {
            this.setErrorMessage(Messages.NewProjectPage_NoLocationError);
            return false;
        }
        File file = new File(this.location);
        if (file.exists() && !file.isDirectory()) {
            this.setErrorMessage(Messages.NewProjectPage_LocationNotValid);
            return false;
        }
        IPath dataPath = CoreUtil.getCodewindDataPath();
        if (dataPath != null && dataPath.isPrefixOf((IPath)new Path(this.location))) {
            this.setErrorMessage(NLS.bind((String)Messages.ProjectLocationInCodewindDataDirError, (Object)dataPath.toOSString()));
            return false;
        }
        if (this.selectionTable.getSelectionCount() != 1) {
            this.setErrorMessage(Messages.NewProjectPage_NoTemplateSelected);
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    public ProjectTemplateInfo getProjectTemplateInfo() {
        int index;
        if (this.selectionTable != null && (index = this.selectionTable.getSelectionIndex()) >= 0) {
            TableItem item = this.selectionTable.getItem(index);
            return (ProjectTemplateInfo)item.getData();
        }
        return null;
    }

    public CodewindConnection getConnection() {
        return this.connection;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getLocation() {
        return this.location;
    }

    private void createItems(Table table, String filter) {
        table.removeAll();
        this.pattern.setPattern("*" + filter + "*");
        for (ProjectTemplateInfo templateInfo : this.templateList) {
            String template = templateInfo.getLabel();
            String type = ProjectType.getDisplayName((String)templateInfo.getProjectType());
            String language = ProjectLanguage.getDisplayName((String)templateInfo.getLanguage());
            String description = templateInfo.getDescription();
            String source = templateInfo.getSource();
            if (!(this.pattern.matches(template) || type != null && this.pattern.matches(type) || language != null && this.pattern.matches(language) || description != null && this.pattern.matches(description)) && (source == null || !this.pattern.matches(source))) continue;
            TableItem item = new TableItem(table, 0);
            item.setForeground(table.getForeground());
            item.setBackground(table.getBackground());
            item.setText(0, template);
            if (type != null) {
                item.setText(1, type);
            }
            if (language != null) {
                item.setText(2, language);
            }
            item.setData((Object)templateInfo);
        }
    }

    public static void sortTable(Table table, TableColumn column) {
        int i;
        TableItem[] items = table.getItems();
        int rows = items.length;
        int dir = table.getSortDirection() == 1024 ? 1 : -1;
        TableColumn currentColumn = table.getSortColumn();
        int columnNum = 0;
        for (int j = 0; j < table.getColumnCount(); ++j) {
            if (!table.getColumn(j).equals(column)) continue;
            columnNum = j;
            break;
        }
        dir = column.equals(currentColumn) ? -dir : 1;
        int[] map = new int[rows];
        for (i = 0; i < rows; ++i) {
            map[i] = i;
        }
        for (i = 0; i < rows - 1; ++i) {
            for (int j = i + 1; j < rows; ++j) {
                TableItem a = items[map[i]];
                TableItem b = items[map[j]];
                if (a.getText(columnNum).toLowerCase().compareTo(b.getText(columnNum).toLowerCase()) * dir <= 0) continue;
                int t = map[i];
                map[i] = map[j];
                map[j] = t;
            }
        }
        for (i = 0; i < rows; ++i) {
            int n = map[i];
            TableItem item = new TableItem(table, 0);
            for (int j = 0; j < table.getColumnCount(); ++j) {
                item.setText(j, items[n].getText(j));
            }
            item.setImage(items[n].getImage());
            item.setForeground(items[n].getForeground());
            item.setBackground(items[n].getBackground());
            item.setGrayed(items[n].getGrayed());
            item.setChecked(items[n].getChecked());
            item.setData(items[n].getData());
            items[n].dispose();
        }
        table.setSortDirection(dir == 1 ? 1024 : 128);
        table.setSortColumn(column);
    }

    private void updateSelectionTable() {
        String text = this.filterText.getText();
        if (text == null) {
            text = "";
        }
        this.createItems(this.selectionTable, text);
        if (this.selectionTable.getItemCount() > 0) {
            this.selectionTable.select(0);
        }
        this.updateDetails();
        this.setPageComplete(this.validate());
    }

    public void updateDetails() {
        TableItem[] items = this.selectionTable.getSelection();
        String description = "";
        String source = "";
        boolean enabled = false;
        if (items.length == 1) {
            enabled = true;
            description = ((ProjectTemplateInfo)items[0].getData()).getDescription();
            if (description == null || description.isEmpty()) {
                description = Messages.NewProjectPage_DetailsNone;
            }
            if ((source = ((ProjectTemplateInfo)items[0].getData()).getSource()) == null || source.isEmpty()) {
                source = Messages.NewProjectPage_DetailsNone;
            }
        }
        this.descriptionLabel.setText(NLS.bind((String)Messages.NewProjectPage_DescriptionLabel, (Object)description));
        this.sourceLabel.setText(NLS.bind((String)Messages.NewProjectPage_SourceLabel, (Object)source));
        this.descriptionLabel.setEnabled(enabled);
        this.sourceLabel.setEnabled(enabled);
        this.resizeEntry(this.descriptionLabel);
        this.resizeEntry(this.sourceLabel);
    }

    private void resizeEntry(Text text) {
        int width = text.getParent().getClientArea().width;
        text.setSize(width, text.computeSize((int)width, (int)-1).y);
        int newWidth = text.getParent().getClientArea().width;
        if (newWidth != width) {
            text.setSize(newWidth, text.computeSize((int)newWidth, (int)-1).y);
        }
    }

    public void resizeColumns(Table table) {
        int i;
        TableLayout tableLayout = new TableLayout();
        int numColumns = table.getColumnCount();
        for (i = 0; i < numColumns; ++i) {
            table.getColumn(i).pack();
        }
        for (i = 0; i < numColumns; ++i) {
            int w = Math.max(75, table.getColumn(i).getWidth());
            tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(w, w, true));
        }
        table.setLayout((Layout)tableLayout);
    }

    private void setupConnection() {
        CodewindManager manager = CodewindManager.getManager();
        this.connection = CodewindConnectionManager.getLocalConnection();
        if (this.connection != null && this.connection.isConnected()) {
            return;
        }
        final InstallStatus status = manager.getInstallStatus();
        if (status.isStarted()) {
            this.connection = CodewindConnectionManager.getLocalConnection();
            return;
        }
        if (!status.isInstalled()) {
            Logger.logError((String)"In NewCodewindProjectPage setupConnection method and Codewind is not installed or has unknown status.");
            this.connection = null;
            return;
        }
        this.connection = null;
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    ProcessHelper.ProcessResult result = InstallUtil.startCodewind((String)status.getVersion(), (IProgressMonitor)monitor);
                    if (result.getExitValue() != 0) {
                        Logger.logError((String)("Installer start failed with return code: " + result.getExitValue() + ", output: " + result.getOutput() + ", error: " + result.getError()));
                        String errorText = result.getError() != null && !result.getError().isEmpty() ? result.getError() : result.getOutput();
                        throw new InvocationTargetException(null, "There was a problem while trying to start Codewind: " + errorText);
                    }
                    NewCodewindProjectPage.this.connection = CodewindConnectionManager.getLocalConnection();
                    ViewHelper.refreshCodewindExplorerView(NewCodewindProjectPage.this.connection);
                }
                catch (IOException e) {
                    throw new InvocationTargetException(e, "An error occurred trying to start Codewind: " + e.getMessage());
                }
                catch (TimeoutException e) {
                    throw new InvocationTargetException(e, "Codewind did not start in the expected time: " + e.getMessage());
                }
            }
        };
        try {
            this.getWizard().getContainer().run(true, true, runnable);
        }
        catch (InvocationTargetException e) {
            Logger.logError((String)"An error occurred trying to start Codewind", (Throwable)e);
            return;
        }
        catch (InterruptedException e) {
            Logger.logError((String)"Codewind start was interrupted", (Throwable)e);
            return;
        }
    }
}

