/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.ui.internal.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.core.internal.cli.ProjectUtil;
import org.eclipse.codewind.core.internal.connection.CodewindConnection;
import org.eclipse.codewind.core.internal.constants.ProjectInfo;
import org.eclipse.codewind.ui.internal.IDEUtil;
import org.eclipse.codewind.ui.internal.messages.Messages;
import org.eclipse.codewind.ui.internal.wizards.BindProjectWizard;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class ProjectValidationPage
extends WizardPage {
    private BindProjectWizard wizard;
    private CodewindConnection connection;
    private IPath projectPath;
    private ProjectInfo projectInfo;
    private Text validateMsg;
    private StyledText typeText;

    protected ProjectValidationPage(BindProjectWizard wizard, CodewindConnection connection, IPath projectPath) {
        super(Messages.ProjectValidationPageName);
        this.setTitle(Messages.ProjectValidationPageTitle);
        this.setDescription(Messages.ProjectValidationPageDescription);
        this.wizard = wizard;
        this.connection = connection;
        this.projectPath = projectPath;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = 5;
        layout.verticalSpacing = 7;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        this.validateMsg = new Text(composite, 74);
        this.validateMsg.setText("");
        GridData data = new GridData(4, 2, true, false);
        data.widthHint = 200;
        this.validateMsg.setLayoutData((Object)data);
        IDEUtil.normalizeBackground((Control)this.validateMsg, (Control)composite);
        new Label(composite, 0).setLayoutData((Object)new GridData(1, 2, false, false));
        this.typeText = new StyledText(composite, 8);
        this.typeText.setText("");
        data = new GridData(4, 2, true, false);
        data.horizontalIndent = 20;
        this.typeText.setLayoutData((Object)data);
        IDEUtil.normalizeBackground((Control)this.typeText, (Control)composite);
        this.setProjectPath(this.projectPath, false);
        this.validateMsg.setFocus();
        this.setControl((Control)composite);
    }

    public boolean canFinish() {
        return this.projectInfo != null;
    }

    public boolean isActivePage() {
        return this.isCurrentPage();
    }

    public ProjectInfo getProjectInfo() {
        return this.projectInfo;
    }

    public void setProjectPath(final IPath projectPath, boolean fromPrevPage) {
        this.projectPath = projectPath;
        this.projectInfo = null;
        if (projectPath == null) {
            return;
        }
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (String)NLS.bind((String)Messages.ProjectValidationTask, (Object)projectPath.lastSegment()), (int)100);
                ProjectValidationPage.this.projectInfo = ProjectValidationPage.this.getProjectInfo((IProgressMonitor)mon.split(100));
            }
        };
        try {
            if (fromPrevPage && this.getWizard() != null && this.getWizard().getContainer() != null) {
                this.getContainer().run(true, true, runnable);
            } else {
                PlatformUI.getWorkbench().getProgressService().busyCursorWhile(runnable);
            }
        }
        catch (InvocationTargetException e) {
            Logger.logError((String)("An error occurred getting the project info for: " + projectPath.lastSegment()), (Throwable)e);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        this.wizard.setProjectInfo(this.projectInfo);
        if (this.projectInfo != null) {
            this.validateMsg.setText(NLS.bind((String)Messages.ProjectValidationPageMsg, (Object)projectPath.lastSegment()));
            this.typeText.setText(this.projectInfo.type.getDisplayName());
            IDEUtil.setBold(this.typeText);
            IDEUtil.normalizeBackground((Control)this.typeText, (Control)this.typeText.getParent());
            this.typeText.setVisible(true);
        } else {
            this.validateMsg.setText(Messages.ProjectValidationPageFailMsg);
            this.typeText.setVisible(false);
        }
        int width = this.validateMsg.getParent().getClientArea().width;
        this.validateMsg.setSize(width, this.validateMsg.computeSize((int)width, (int)-1).y);
    }

    private ProjectInfo getProjectInfo(IProgressMonitor monitor) {
        if (this.connection == null || this.projectPath == null) {
            return null;
        }
        try {
            return ProjectUtil.validateProject((String)this.projectPath.lastSegment(), (String)this.projectPath.toFile().getAbsolutePath(), (IProgressMonitor)monitor);
        }
        catch (Exception e) {
            Logger.logError((String)("An error occurred trying to get the project type for project: " + this.projectPath.lastSegment()), (Throwable)e);
            return null;
        }
    }
}

