/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.core.internal.cli;

import org.eclipse.codewind.core.internal.connection.JSONObjectResult;
import org.eclipse.codewind.core.internal.messages.Messages;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class UpgradeResult
extends JSONObjectResult {
    private static String FAILED_KEY = "failed";
    private static String MIGRATED_KEY = "migrated";
    private static String ERROR_KEY = "error";
    private static String PROJECT_NAME_KEY = "projectName";

    public UpgradeResult(JSONObject result) {
        super(result, "workspace upgrade");
    }

    public String getFormattedResult() throws JSONException {
        int i;
        boolean start;
        JSONArray migrated = this.getArray(MIGRATED_KEY);
        JSONArray failed = this.getArray(FAILED_KEY);
        if (!(migrated != null && migrated.length() != 0 || failed != null && failed.length() != 0)) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        if (migrated != null && migrated.length() > 0) {
            builder.append(Messages.UpgradeResultMigrated + "\n");
            builder.append("  ");
            start = true;
            for (i = 0; i < migrated.length(); ++i) {
                if (start) {
                    start = false;
                } else {
                    builder.append(", ");
                }
                builder.append(migrated.get(i));
            }
        }
        if (failed != null && failed.length() > 0) {
            if (builder.length() > 0) {
                builder.append("\n");
            }
            builder.append(Messages.UpgradeResultNotMigrated + "\n");
            builder.append("  ");
            start = true;
            for (i = 0; i < failed.length(); ++i) {
                if (start) {
                    start = false;
                } else {
                    builder.append("\n  ");
                }
                JSONObject obj = failed.getJSONObject(i);
                String name = obj.getString(PROJECT_NAME_KEY);
                String error = obj.getString(ERROR_KEY);
                builder.append(name + " (" + error + ")");
            }
        }
        return builder.toString();
    }
}

