/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.ui.internal.actions;

import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.core.internal.connection.CodewindConnection;
import org.eclipse.codewind.core.internal.connection.CodewindConnectionManager;
import org.eclipse.codewind.ui.CodewindUIPlugin;
import org.eclipse.codewind.ui.internal.messages.Messages;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.actions.SelectionProviderAction;

public class RemoveConnectionAction
extends SelectionProviderAction {
    protected CodewindConnection connection;

    public RemoveConnectionAction(ISelectionProvider selectionProvider) {
        super(selectionProvider, Messages.RemoveConnectionActionLabel);
        this.setImageDescriptor(CodewindUIPlugin.getDefaultIcon());
        this.selectionChanged(this.getStructuredSelection());
    }

    public void selectionChanged(IStructuredSelection sel) {
        Object obj;
        if (sel.size() == 1 && (obj = sel.getFirstElement()) instanceof CodewindConnection) {
            this.connection = (CodewindConnection)obj;
            this.setEnabled(this.connection != null);
            return;
        }
        this.setEnabled(false);
    }

    public void run() {
        if (this.connection == null) {
            Logger.logError((String)"RemoveConnectionAction ran but no connection was selected");
            return;
        }
        try {
            CodewindConnectionManager.remove((String)this.connection.getBaseURI().toString());
        }
        catch (Exception e) {
            Logger.logError((String)("Error removing connection: " + this.connection.getBaseURI().toString()), (Throwable)e);
        }
    }
}

