/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.openapi.core.maven;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import org.apache.maven.model.Build;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.model.merge.MavenModelMerger;
import org.eclipse.codewind.openapi.core.Activator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class MavenTracker {
    private IFile targetPomFile;
    private IFile sourcePomFile;
    private Model targetPomFileModel;
    private Model sourcePomFileModel;
    private IProject project;
    private String targetGroupId;

    public MavenTracker(IFile target, IFile source, IProject project) {
        this.targetPomFile = target;
        this.sourcePomFile = source;
        this.project = project;
        this.targetPomFileModel = this.getModelObject(target);
        this.sourcePomFileModel = this.getModelObject(source);
        Parent parent = this.targetPomFileModel.getParent();
        if (parent != null) {
            this.targetGroupId = parent.getGroupId();
        }
    }

    public void mergeModels() {
        try {
            Parent parent = this.targetPomFileModel.getParent();
            if (parent != null) {
                try {
                    String sourceDirectory;
                    Build sourceBuild;
                    if (this.targetGroupId != null && this.targetGroupId.toLowerCase().contains("org.springframework.boot") && (sourceBuild = this.sourcePomFileModel.getBuild()) != null && (sourceDirectory = sourceBuild.getSourceDirectory()) != null) {
                        sourceBuild.setSourceDirectory(null);
                    }
                }
                catch (Exception e) {
                    Activator.log(1, "Error:", e);
                }
            }
            MavenModelMerger merger = new MavenModelMerger();
            merger.merge(this.targetPomFileModel, this.sourcePomFileModel, false, null);
            MavenXpp3Writer xpp3writer = new MavenXpp3Writer();
            FileOutputStream fos = new FileOutputStream(this.sourcePomFile.getLocation().toString());
            xpp3writer.write((OutputStream)fos, this.targetPomFileModel);
            this.project.refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception e) {
            Activator.log(1, "Possible issue when merging the two Maven Models:", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Model getModelObject(IFile pomFile) {
        InputStreamReader streamReader = null;
        try {
            Model model;
            MavenXpp3Reader reader = new MavenXpp3Reader();
            streamReader = new InputStreamReader(new FileInputStream(pomFile.getLocation().toFile()));
            Model model2 = model = reader.read((Reader)streamReader);
            return model2;
        }
        catch (Exception e) {
            Activator.log(4, e);
        }
        finally {
            if (streamReader != null) {
                try {
                    streamReader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    public IFile getOriginalPomFile() {
        return this.targetPomFile;
    }

    public IFile getTargetPomFile() {
        return this.sourcePomFile;
    }

    public Model getOriginalPomFileModel() {
        return this.targetPomFileModel;
    }

    public Model getTargetPomFileModel() {
        return this.sourcePomFileModel;
    }

    public String getTargetGroupId() {
        return this.targetGroupId;
    }
}

