/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.core.internal.connection;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.codewind.core.internal.constants.ProjectType;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ProjectTypeInfo {
    private static final String PROJECT_TYPE_KEY = "projectType";
    private static final String PROJECT_SUBTYPES_KEY = "projectSubtypes";
    private static final String ITEMS_KEY = "items";
    private static final String ID_KEY = "id";
    private static final String VERSION_KEY = "version";
    private static final String LABEL_KEY = "label";
    private static final String DESCRIPTION_KEY = "description";
    private String _id;
    private String _subtypesLabel;
    private List<ProjectSubtypeInfo> _subtypes = new ArrayList<ProjectSubtypeInfo>();

    public ProjectTypeInfo(JSONObject json) throws JSONException {
        this._id = json.getString(PROJECT_TYPE_KEY);
        JSONObject subtypes = json.getJSONObject(PROJECT_SUBTYPES_KEY);
        this._subtypesLabel = subtypes.optString(LABEL_KEY);
        JSONArray items = subtypes.getJSONArray(ITEMS_KEY);
        for (int i = 0; i < items.length(); ++i) {
            JSONObject item = items.getJSONObject(i);
            this._subtypes.add(new ProjectSubtypeInfo(item));
        }
    }

    public String getId() {
        return this._id;
    }

    public String getSubtypesLabel() {
        return this._subtypesLabel;
    }

    public List<ProjectSubtypeInfo> getSubtypes() {
        return this._subtypes;
    }

    public void addSubtypes(List<ProjectSubtypeInfo> subtypes) {
        this._subtypes.addAll(subtypes);
    }

    public boolean eq(ProjectType type) {
        return this._id.equals(type.getId());
    }

    public int hashCode() {
        return this._id.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ProjectTypeInfo) {
            return this._id.equals(((ProjectTypeInfo)obj)._id);
        }
        return false;
    }

    public class ProjectSubtypeInfo {
        public final String id;
        public final String version;
        public final String label;
        public final String description;

        private ProjectSubtypeInfo(JSONObject json) throws JSONException {
            this.id = json.getString(ProjectTypeInfo.ID_KEY);
            this.version = json.optString(ProjectTypeInfo.VERSION_KEY);
            this.label = json.getString(ProjectTypeInfo.LABEL_KEY);
            this.description = json.optString(ProjectTypeInfo.DESCRIPTION_KEY);
        }

        public ProjectSubtypeInfo(String language) {
            this.id = language;
            this.version = "";
            this.label = language;
            this.description = "";
        }

        private ProjectTypeInfo getParent() {
            return ProjectTypeInfo.this;
        }

        public int hashCode() {
            return this.getParent().hashCode() + this.id.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof ProjectSubtypeInfo) {
                ProjectSubtypeInfo other = (ProjectSubtypeInfo)obj;
                return this.getParent().equals(other.getParent()) && this.id.equals(other.id);
            }
            return false;
        }
    }
}

