/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.ui.internal.views;

import java.util.HashMap;
import java.util.List;
import org.eclipse.codewind.core.internal.CodewindApplication;
import org.eclipse.codewind.core.internal.IUpdateHandler;
import org.eclipse.codewind.core.internal.connection.CodewindConnection;
import org.eclipse.codewind.core.internal.connection.CodewindConnectionManager;
import org.eclipse.codewind.ui.internal.views.ViewHelper;

public class UpdateHandler
implements IUpdateHandler {
    private HashMap<AppKey, AppUpdateListener> appListeners = new HashMap();

    public void updateAll() {
        ViewHelper.refreshCodewindExplorerView(null);
        this.updateApps();
    }

    public void updateConnection(CodewindConnection connection) {
        ViewHelper.refreshCodewindExplorerView(connection);
        ViewHelper.expandConnection(connection);
        this.updateApps(connection);
    }

    private void updateApps() {
        CodewindConnectionManager.activeConnections().stream().forEach(conn -> this.updateApps((CodewindConnection)conn));
    }

    private void updateApps(CodewindConnection conn) {
        if (conn != null) {
            conn.getApps().stream().forEach(app -> this.updateApplication((CodewindApplication)app));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateApplication(CodewindApplication app) {
        ViewHelper.refreshCodewindExplorerView(app);
        ViewHelper.expandConnection(app.connection);
        HashMap<AppKey, AppUpdateListener> hashMap = this.appListeners;
        synchronized (hashMap) {
            AppUpdateListener listener = this.appListeners.get(new AppKey(app));
            if (listener != null) {
                listener.update();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnection(List<CodewindApplication> apps) {
        ViewHelper.refreshCodewindExplorerView(null);
        HashMap<AppKey, AppUpdateListener> hashMap = this.appListeners;
        synchronized (hashMap) {
            for (CodewindApplication app : apps) {
                AppUpdateListener listener = this.appListeners.get(new AppKey(app));
                if (listener == null) continue;
                listener.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeApplication(CodewindApplication app) {
        ViewHelper.refreshCodewindExplorerView(app.connection);
        ViewHelper.expandConnection(app.connection);
        HashMap<AppKey, AppUpdateListener> hashMap = this.appListeners;
        synchronized (hashMap) {
            AppUpdateListener listener = this.appListeners.get(new AppKey(app));
            if (listener != null) {
                listener.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAppUpdateListener(String connectionId, String projectID, AppUpdateListener listener) {
        HashMap<AppKey, AppUpdateListener> hashMap = this.appListeners;
        synchronized (hashMap) {
            this.appListeners.put(new AppKey(connectionId, projectID), listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAppUpdateListener(String connectionId, String projectID) {
        HashMap<AppKey, AppUpdateListener> hashMap = this.appListeners;
        synchronized (hashMap) {
            this.appListeners.remove(new AppKey(connectionId, projectID));
        }
    }

    private class AppKey {
        public final String connectionId;
        public final String projectId;

        public AppKey(CodewindApplication app) {
            this(app.connection.getConid(), app.projectID);
        }

        public AppKey(String connectionId, String projectID) {
            this.connectionId = connectionId;
            this.projectId = projectID;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof AppKey)) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            AppKey key = (AppKey)obj;
            return this.connectionId.equals(key.connectionId) && this.projectId.equals(key.projectId);
        }

        public int hashCode() {
            return this.connectionId.hashCode() * this.projectId.hashCode();
        }
    }

    public static interface AppUpdateListener {
        public void update();

        public void remove();
    }
}

