/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.filewatchers.core;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.eclipse.codewind.filewatchers.core.PathUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ProjectToWatch {
    private final String projectId;
    private final String pathToMonitor;
    private final List<String> ignoredPaths = new ArrayList<String>();
    private final List<String> ignoredFilenames = new ArrayList<String>();
    private final String projectWatchStateId;
    private final Long projectCreationTimeInAbsoluteMsecs;
    private boolean external = false;

    public ProjectToWatch(JSONObject json, boolean deleteChangeType) throws JSONException {
        long pct;
        JSONArray ignoredFilenamesJson;
        if (deleteChangeType) {
            this.projectId = json.getString("projectID");
            this.pathToMonitor = null;
            this.projectWatchStateId = null;
            this.projectCreationTimeInAbsoluteMsecs = null;
            return;
        }
        String projectType = json.optString("type");
        this.external = projectType != null ? projectType.equalsIgnoreCase("non-project") : false;
        this.projectId = json.getString("projectID");
        this.pathToMonitor = PathUtils.normalizeDriveLetter(json.getString("pathToMonitor"));
        this.projectWatchStateId = json.getString("projectWatchStateId");
        this.validatePathToMonitor();
        JSONArray ignoredPathsJson = json.optJSONArray("ignoredPaths");
        if (ignoredPathsJson != null && ignoredPathsJson.length() > 0) {
            for (int x = 0; x < ignoredPathsJson.length(); ++x) {
                this.ignoredPaths.add(ignoredPathsJson.getString(x));
            }
        }
        if ((ignoredFilenamesJson = json.optJSONArray("ignoredFilenames")) != null && ignoredFilenamesJson.length() > 0) {
            for (int x = 0; x < ignoredFilenamesJson.length(); ++x) {
                this.ignoredFilenames.add(ignoredFilenamesJson.getString(x));
            }
        }
        this.projectCreationTimeInAbsoluteMsecs = (pct = json.optLong("projectCreationTime", 0L)) != 0L ? Long.valueOf(pct) : null;
    }

    private ProjectToWatch(ProjectToWatch old, Long projectCreationTimeInAbsoluteMsecsParam) {
        this.external = old.external;
        this.projectId = old.projectId;
        this.pathToMonitor = old.pathToMonitor;
        this.projectWatchStateId = old.projectWatchStateId;
        this.validatePathToMonitor();
        this.ignoredPaths.addAll(old.ignoredPaths);
        this.ignoredFilenames.addAll(old.ignoredFilenames);
        this.projectCreationTimeInAbsoluteMsecs = projectCreationTimeInAbsoluteMsecsParam;
    }

    public ProjectToWatch cloneWithNewProjectCreationTime(Long projectCreationTimeInAbsoluteMsecsParam) {
        return new ProjectToWatch(this, projectCreationTimeInAbsoluteMsecsParam);
    }

    private void validatePathToMonitor() {
        if (this.pathToMonitor.contains("\\")) {
            throw new IllegalArgumentException("Path to monitor should not contain Windows-style path separators: " + this.pathToMonitor);
        }
        if (!this.pathToMonitor.startsWith("/")) {
            throw new IllegalArgumentException("Path to monitor should always begin with a forward slash: " + this.pathToMonitor);
        }
        if (this.pathToMonitor.endsWith("/") || this.pathToMonitor.endsWith("\\")) {
            throw new IllegalArgumentException("Path to monitor may not end with path separator: " + this.pathToMonitor);
        }
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getPathToMonitor() {
        return this.pathToMonitor;
    }

    public List<String> getIgnoredPaths() {
        return this.ignoredPaths;
    }

    public List<String> getIgnoredFilenames() {
        return this.ignoredFilenames;
    }

    public String getProjectWatchStateId() {
        return this.projectWatchStateId;
    }

    public boolean isExternal() {
        return this.external;
    }

    public Optional<Long> getProjectCreationTimeInAbsoluteMsecs() {
        return Optional.ofNullable(this.projectCreationTimeInAbsoluteMsecs);
    }

    public static class ProjectToWatchFromWebSocket
    extends ProjectToWatch {
        private final String changeType;

        public ProjectToWatchFromWebSocket(JSONObject obj, String changeType) throws JSONException {
            super(obj, changeType.equalsIgnoreCase("delete"));
            this.changeType = changeType;
        }

        public String getChangeType() {
            return this.changeType;
        }
    }
}

