/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.openapi.ui.commands;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.codewind.openapi.core.Activator;
import org.eclipse.codewind.openapi.core.commands.CommandRunner;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public abstract class AbstractOpenApiGeneratorCommand
extends WorkspaceModifyOperation {
    protected IFile openApiFile;
    protected String outputFolderString;
    protected IFolder outputFolder = null;
    protected String codegenJar = null;
    protected String configJson = null;
    protected String argSurround = "";
    protected String pluginLocation = "";
    protected boolean isWindows = true;
    protected IProject project = null;
    protected String language = null;
    protected String generatorType = null;
    protected boolean pomFileExists = false;

    public AbstractOpenApiGeneratorCommand() {
    }

    public AbstractOpenApiGeneratorCommand(ISchedulingRule rule) {
        super(rule);
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    public void setOpenApiFile(IFile openApiFile) {
        this.openApiFile = openApiFile;
    }

    public void setOutputFolder(IFolder outputFolder) {
        this.outputFolder = outputFolder;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public void setGeneratorType(String generatorType) {
        this.generatorType = generatorType;
    }

    public void setOutputFolderString(String outputFolderString) {
        this.outputFolderString = outputFolderString;
    }

    public String getOutputFolderString() {
        return this.outputFolderString;
    }

    public IFolder getOutputFolder() {
        return this.outputFolder;
    }

    public boolean getPomFileExists() {
        return this.pomFileExists;
    }

    public void setPomFileExists(boolean exists) {
        this.pomFileExists = exists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        try {
            monitor.beginTask("Generating", 15);
            ArrayList<String> mainArgsList = new ArrayList<String>();
            IStatus result = this.commonSetup(monitor);
            monitor.worked(5);
            if (!result.isOK()) {
                Activator.log((int)4, (String)"Failed to set up command");
                return;
            }
            monitor.worked(1);
            this.populateArgsList(mainArgsList);
            monitor.worked(4);
            result = this.doExecute(mainArgsList, monitor);
            monitor.worked(5);
        }
        finally {
            monitor.done();
        }
    }

    protected abstract CommandRunner getCommandRunner(List<String> var1);

    protected abstract void populateArgsList(List<String> var1);

    protected IStatus commonSetup(IProgressMonitor monitor) {
        String osName = System.getProperty("os.name").toLowerCase();
        boolean bl = this.isWindows = osName.indexOf("win") >= 0;
        if (this.isWindows) {
            this.argSurround = "\"";
        }
        try {
            URL coreURL = FileLocator.resolve((URL)Activator.getDefault().getBundle().getEntry("/"));
            this.pluginLocation = coreURL.getFile();
            if (this.isWindows && this.pluginLocation != null && this.pluginLocation.startsWith("/")) {
                this.pluginLocation = this.pluginLocation.substring(1);
            }
        }
        catch (IOException e) {
            return new Status(4, "org.eclipse.codewind.openapi.ui", e.getMessage());
        }
        String jarOverride = System.getProperty("org.eclipse.codewind.openapi.cli.jar.path");
        this.codegenJar = jarOverride != null && jarOverride.contains("openapi-generator-cli") ? this.argSurround + jarOverride + this.argSurround : this.argSurround + this.pluginLocation + "lib/" + "openapi-generator-cli-4.2.2.jar" + this.argSurround;
        if (this.isWindows) {
            this.codegenJar = this.codegenJar.replace("/", "\\");
        }
        this.outputFolder = this.outputFolderString.equals(this.project.getFullPath().toString()) ? ResourcesPlugin.getWorkspace().getRoot().getFolder(this.project.getLocation()) : ResourcesPlugin.getWorkspace().getRoot().getFolder((IPath)new Path(this.outputFolderString));
        return new Status(0, "org.eclipse.codewind.openapi.ui", "Setup successful");
    }

    protected IStatus doExecute(List<String> mainArgsList, IProgressMonitor monitor) {
        IStatus result = null;
        CommandRunner cmdRunner = this.getCommandRunner(mainArgsList);
        result = cmdRunner.run();
        if (result.isOK()) {
            try {
                if (this.outputFolderString.equals(this.project.getFullPath().toString())) {
                    this.project.refreshLocal(2, monitor);
                } else {
                    this.outputFolder.refreshLocal(2, monitor);
                }
            }
            catch (CoreException e) {
                result = new Status(4, "org.eclipse.codewind.openapi.ui", e.getMessage());
            }
        }
        return result;
    }
}

