/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.openapi.ui.commands;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.codewind.openapi.core.maven.MavenTracker;
import org.eclipse.codewind.openapi.core.maven.Utils;
import org.eclipse.codewind.openapi.ui.Activator;
import org.eclipse.codewind.openapi.ui.Constants;
import org.eclipse.codewind.openapi.ui.Messages;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class PostGenCommand
extends WorkspaceModifyOperation {
    private boolean ignoreFileExists;
    private String outputFolder;
    private IProject project;
    private Constants.PROJECT_TYPE projectType;
    private String tempOrigFileName;

    public PostGenCommand(IProject project, Constants.PROJECT_TYPE projectType, boolean ignoreFileExists, String outputFolder, String tempOrigFileName) {
        this.project = project;
        this.projectType = projectType;
        this.ignoreFileExists = ignoreFileExists;
        this.outputFolder = outputFolder;
        this.tempOrigFileName = tempOrigFileName;
    }

    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        this.postCodeGenForMaven(monitor);
    }

    private boolean postCodeGenForMaven(IProgressMonitor monitor) {
        boolean isOutputFolderProjectRoot = this.outputFolder.equals(this.project.getFullPath().toString());
        if (this.projectType == Constants.PROJECT_TYPE.MAVEN && isOutputFolderProjectRoot && !this.ignoreFileExists) {
            try {
                IFile originalPomFile = this.project.getFile(this.tempOrigFileName);
                IFile generatedPomFile = this.project.getFile("pom.xml");
                MavenTracker mt = new MavenTracker(originalPomFile, generatedPomFile, this.project);
                mt.mergeModels();
                monitor.beginTask(Messages.JOB_UPDATING_MAVEN_PROJECT, 100);
                Utils.updateProject((IProject[])new IProject[]{this.project}, (boolean)false, (IProgressMonitor)monitor);
                monitor.beginTask(Messages.JOB_UPDATING_CLASSPATH, 100);
                this.postCodeGenUpdateClasspath(monitor);
            }
            catch (Exception e) {
                Activator.log(1, "Exception in postCodeGenForMaven", e);
            }
        }
        return true;
    }

    private void postCodeGenUpdateClasspath(IProgressMonitor monitor) {
        IResource srcGenJavaPath = this.project.findMember("/src/gen/java");
        if (srcGenJavaPath != null && srcGenJavaPath.exists()) {
            this.addGenJavaSourcePathToClasspath(monitor);
        }
    }

    private void addGenJavaSourcePathToClasspath(IProgressMonitor monitor) {
        try {
            IJavaProject javaProject = JavaCore.create((IProject)this.project);
            IClasspathEntry[] rawClasspath = javaProject.getRawClasspath();
            ArrayList<IClasspathEntry> cpEntries = new ArrayList<IClasspathEntry>();
            boolean isAlreadyAdded = false;
            for (int i = 0; i < rawClasspath.length; ++i) {
                IClasspathEntry iClasspathEntry = rawClasspath[i];
                IPath cePath = iClasspathEntry.getPath();
                if (iClasspathEntry.getEntryKind() == 3 && cePath.toString().endsWith("/src/gen/java")) {
                    isAlreadyAdded = true;
                }
                cpEntries.add(iClasspathEntry);
            }
            if (!isAlreadyAdded) {
                IPath p = new Path(this.project.getName()).append("/src/gen/java").makeAbsolute();
                ArrayList<IClasspathAttribute> attrs = new ArrayList<IClasspathAttribute>();
                attrs.add(JavaCore.newClasspathAttribute((String)"maven.pomderived", (String)"true"));
                IClasspathEntry cpEntry = JavaCore.newSourceEntry((IPath)p, null, null, (IPath)new Path(this.project.getName()).append("/target/classes").makeAbsolute(), (IClasspathAttribute[])attrs.toArray(new IClasspathAttribute[0]));
                cpEntries.add(cpEntry);
            }
            javaProject.setRawClasspath(cpEntries.toArray(new IClasspathEntry[0]), monitor);
        }
        catch (Exception e) {
            Activator.log(1, "addGenJavaSourcePathToClasspath issue: ", e);
        }
    }
}

