/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.ui.internal.actions;

import org.eclipse.codewind.core.internal.CodewindApplication;
import org.eclipse.codewind.core.internal.CodewindEclipseApplication;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.ui.internal.messages.Messages;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.actions.SelectionProviderAction;

public class EnableDisableInjectMetricsAction
extends SelectionProviderAction {
    protected CodewindEclipseApplication app;

    public EnableDisableInjectMetricsAction(ISelectionProvider selectionProvider) {
        super(selectionProvider, Messages.EnableInjectMetricsLabel);
        this.selectionChanged(this.getStructuredSelection());
    }

    public void selectionChanged(IStructuredSelection sel) {
        Object obj;
        if (sel.size() == 1 && (obj = sel.getFirstElement()) instanceof CodewindEclipseApplication) {
            this.app = (CodewindEclipseApplication)obj;
            if (this.app.isAvailable() && this.app.canInjectMetrics()) {
                if (this.app.isMetricsInjected()) {
                    this.setText(Messages.DisableInjectMetricsLabel);
                } else {
                    this.setText(Messages.EnableInjectMetricsLabel);
                }
                this.setEnabled(true);
                return;
            }
        }
        this.setEnabled(false);
    }

    public void run() {
        if (this.app == null) {
            Logger.logError((String)(Messages.ErrorOnEnableDisableInjectMetrics + " ran but no application was selected"));
            return;
        }
        EnableDisableInjectMetricsAction.enableDisableInjectMetrics((CodewindApplication)this.app, !this.app.isMetricsInjected());
    }

    public static void enableDisableInjectMetrics(final CodewindApplication app, final boolean enable) {
        Job job = new Job(NLS.bind((String)Messages.EnableDisableInjectMetricsJob, (Object)app.name)){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    app.connection.requestInjectMetrics(app.projectID, enable);
                    app.connection.refreshApps(app.projectID);
                    return Status.OK_STATUS;
                }
                catch (Exception e) {
                    Logger.logError((String)("An error occurred changing inject metric setting for: " + app.name + ", with id: " + app.projectID), (Throwable)e);
                    return new Status(4, "org.eclipse.codewind.ui", NLS.bind((String)Messages.ErrorOnEnableDisableInjectMetrics, (Object)app.name), (Throwable)e);
                }
            }
        };
        job.schedule();
    }

    public boolean showAction() {
        return this.app != null && this.app.canInjectMetrics();
    }
}

