/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.ui.internal.wizards;

import java.util.List;
import org.eclipse.codewind.core.internal.connection.CodewindConnection;
import org.eclipse.codewind.core.internal.connection.LocalConnection;
import org.eclipse.codewind.core.internal.connection.RemoteConnection;
import org.eclipse.codewind.ui.internal.messages.Messages;
import org.eclipse.codewind.ui.internal.views.CodewindNavigatorLabelProvider;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class ConnectionSelectionPage
extends WizardPage {
    private List<CodewindConnection> connections;
    private CodewindConnection connection;

    protected ConnectionSelectionPage(List<CodewindConnection> connections) {
        super(Messages.SelectConnectionPageName);
        this.setTitle(Messages.SelectConnectionPageTitle);
        this.setDescription(Messages.SelectConnectionPageDescription);
        this.connections = connections;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.horizontalSpacing = 5;
        layout.verticalSpacing = 7;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(768);
        composite.setLayoutData((Object)data);
        TableViewer connViewer = new TableViewer(composite, 2564);
        connViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        connViewer.setLabelProvider((IBaseLabelProvider)new ConnLabelProvider());
        connViewer.setInput(this.connections);
        connViewer.getTable().setLayoutData((Object)new GridData(4, 4, true, true));
        connViewer.addSelectionChangedListener(event -> {
            this.connection = (CodewindConnection)connViewer.getStructuredSelection().getFirstElement();
            this.validate();
        });
        this.setControl((Control)composite);
    }

    private void validate() {
        String errorMsg = null;
        if (this.connection == null) {
            errorMsg = Messages.SelectConnectionPageNoSelectionMsg;
        }
        this.setErrorMessage(errorMsg);
        this.getWizard().getContainer().updateButtons();
    }

    public boolean canFlipToNextPage() {
        return this.canFinish();
    }

    public boolean isActivePage() {
        return this.isCurrentPage();
    }

    public boolean canFinish() {
        return this.connection != null;
    }

    public CodewindConnection getConnection() {
        return this.connection;
    }

    private class ConnLabelProvider
    extends LabelProvider {
        private ConnLabelProvider() {
        }

        public Image getImage(Object element) {
            return CodewindNavigatorLabelProvider.getCodewindImage(element);
        }

        public String getText(Object element) {
            if (element instanceof LocalConnection) {
                return ((CodewindConnection)element).getName();
            }
            if (element instanceof RemoteConnection) {
                return ((CodewindConnection)element).getName() + " (" + ((CodewindConnection)element).getBaseURI() + ")";
            }
            return null;
        }
    }
}

