/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.core.internal;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.codewind.core.internal.CodewindApplication;
import org.eclipse.codewind.core.internal.CodewindObjectFactory;
import org.eclipse.codewind.core.internal.CoreUtil;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.core.internal.connection.CodewindConnection;
import org.eclipse.codewind.core.internal.console.ProjectLogInfo;
import org.eclipse.codewind.core.internal.constants.ProjectLanguage;
import org.eclipse.codewind.core.internal.constants.ProjectType;
import org.eclipse.codewind.core.internal.constants.StartMode;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class CodewindApplicationFactory {
    public static void getAppsFromProjectsJson(CodewindConnection connection, String projectsJson) {
        CodewindApplicationFactory.getAppsFromProjectsJson(connection, projectsJson, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void getAppsFromProjectsJson(CodewindConnection connection, String projectsJson, String projectID) {
        try {
            Logger.log(projectsJson);
            JSONArray appArray = new JSONArray(projectsJson);
            HashSet<String> idSet = new HashSet<String>();
            for (int i = 0; i < appArray.length(); ++i) {
                JSONObject appJso = appArray.getJSONObject(i);
                try {
                    String id = appJso.getString("projectID");
                    idSet.add(id);
                    if (projectID != null && !projectID.equals(id)) continue;
                    Class<CodewindApplicationFactory> clazz = CodewindApplicationFactory.class;
                    // MONITORENTER : org.eclipse.codewind.core.internal.CodewindApplicationFactory.class
                    CodewindApplication app = connection.getAppByID(id);
                    if (app != null) {
                        CodewindApplicationFactory.updateApp(app, appJso);
                        if (app.isDeleting()) {
                            connection.removeApp(id);
                        }
                    } else {
                        app = CodewindApplicationFactory.createApp(connection, appJso);
                        if (app != null && !app.isDeleting()) {
                            connection.addApp(app);
                        }
                    }
                    // MONITOREXIT : clazz
                    continue;
                }
                catch (Exception e) {
                    Logger.logError("Error parsing project json: " + appJso, e);
                }
            }
            if (projectID != null) return;
            Iterator<String> iterator = connection.getAppIds().iterator();
            while (iterator.hasNext()) {
                String id = iterator.next();
                if (idSet.contains(id)) continue;
                Logger.log("The application is no longer in the project list so removing: " + id);
                connection.removeApp(id);
            }
            return;
        }
        catch (Exception e) {
            Logger.logError("Error parsing json for project array.", e);
        }
    }

    public static CodewindApplication createApp(CodewindConnection connection, JSONObject appJso) {
        try {
            String name = appJso.getString("name");
            String id = appJso.getString("projectID");
            JSONObject extension = null;
            if (appJso.has("extension")) {
                extension = appJso.getJSONObject("extension");
            }
            ProjectType type = ProjectType.TYPE_UNKNOWN;
            ProjectLanguage language = ProjectLanguage.LANGUAGE_UNKNOWN;
            try {
                String typeStr = appJso.getString("projectType");
                String languageStr = appJso.getString("language");
                type = ProjectType.getType(typeStr, extension);
                language = ProjectLanguage.getLanguage(languageStr);
            }
            catch (JSONException e) {
                Logger.logError(e.getMessage() + " in: " + appJso);
            }
            String localPath = appJso.getString("locOnDisk");
            localPath = CoreUtil.getHostPath(localPath);
            CodewindApplication app = CodewindObjectFactory.createCodewindApplication(connection, id, name, type, language, (IPath)new Path(localPath));
            CodewindApplicationFactory.updateApp(app, appJso);
            return app;
        }
        catch (JSONException e) {
            Logger.logError("Error parsing project json: " + appJso, e);
        }
        catch (Exception e) {
            Logger.logError("Error creating new application for project.", e);
        }
        return null;
    }

    public static void updateApp(CodewindApplication app, JSONObject appJso) {
        try {
            String detail;
            String state;
            if (appJso.has("action")) {
                String action = appJso.getString("action");
                app.setAction(action);
                if ("deleting".equals(action)) {
                    return;
                }
            } else {
                app.setAction(null);
            }
            if (appJso.has("state") && "closed".equals(state = appJso.getString("state"))) {
                app.setEnabled(false);
                return;
            }
            app.setEnabled(true);
            if (appJso.has("appStatus")) {
                JSONObject detailObj;
                String appStatus = appJso.getString("appStatus");
                detail = null;
                if (appJso.has("detailedAppStatus") && (detailObj = appJso.getJSONObject("detailedAppStatus")) != null && detailObj.has("message")) {
                    detail = detailObj.getString("message");
                    String notificationID = CodewindApplicationFactory.getStringValue(detailObj, "notificationID");
                    if (notificationID == null) {
                        app.clearNotificationIDs();
                    } else if (!app.hasNotificationID(notificationID)) {
                        app.addNotificationID(notificationID);
                        CoreUtil.DialogType type = CoreUtil.DialogType.ERROR;
                        if (detailObj.has("severity")) {
                            String severity = detailObj.getString("severity");
                            if ("WARN".equals(severity)) {
                                type = CoreUtil.DialogType.WARN;
                            } else if ("INFO".equals(severity)) {
                                type = CoreUtil.DialogType.INFO;
                            }
                        }
                        String link = null;
                        String linkLabel = null;
                        if (detailObj.has("link") && detailObj.has("linkLabel")) {
                            link = detailObj.getString("link");
                            linkLabel = detailObj.getString("linkLabel");
                        }
                        if (link != null && !link.isEmpty() && linkLabel != null && !linkLabel.isEmpty()) {
                            CoreUtil.openDialogWithLink(type, app.name, detail, linkLabel, link);
                        } else {
                            CoreUtil.openDialog(type, app.name, detail);
                        }
                    }
                }
                app.setAppStatus(appStatus, detail);
            }
            if (appJso.has("buildStatus")) {
                String buildStatus = appJso.getString("buildStatus");
                detail = "";
                if (appJso.has("detailedBuildStatus")) {
                    detail = appJso.getString("detailedBuildStatus");
                }
                app.setBuildStatus(buildStatus, detail);
            }
            if (appJso.has("lastbuild")) {
                long timestamp = appJso.getLong("lastbuild");
                app.setLastBuild(timestamp);
            }
            if (appJso.has("appImageLastBuild")) {
                String timestamp = appJso.getString("appImageLastBuild");
                try {
                    app.setLastImageBuild(Long.parseLong(timestamp));
                }
                catch (NumberFormatException e) {
                    Logger.logError("Error parsing the app image last build value: " + timestamp, e);
                }
            }
            String appBaseUrl = null;
            if (appJso.has("appBaseURL")) {
                appBaseUrl = appJso.getString("appBaseURL");
            }
            app.setAppBaseUrl(appBaseUrl);
            boolean isHttps = false;
            if (appJso.has("isHttps")) {
                isHttps = appJso.getBoolean("isHttps");
            }
            app.setIsHttps(isHttps);
            String containerId = null;
            if (appJso.has("containerId")) {
                containerId = appJso.getString("containerId");
            }
            app.setContainerId(containerId);
            try {
                String debugPort;
                String httpPort;
                JSONObject portsObj = null;
                if (appJso.has("ports") && appJso.get("ports") instanceof JSONObject) {
                    portsObj = appJso.getJSONObject("ports");
                }
                int httpPortNum = -1;
                if (portsObj != null && portsObj.has("exposedPort") && (httpPort = portsObj.getString("exposedPort")) != null && !httpPort.isEmpty()) {
                    httpPortNum = CoreUtil.parsePort(httpPort);
                }
                app.setHttpPort(httpPortNum);
                String internalAppPort = null;
                if (portsObj != null && portsObj.has("internalPort")) {
                    internalAppPort = portsObj.getString("internalPort");
                }
                app.setContainerAppPort(internalAppPort);
                int debugPortNum = -1;
                if (portsObj != null && portsObj.has("exposedDebugPort") && (debugPort = portsObj.getString("exposedDebugPort")) != null && !debugPort.isEmpty()) {
                    debugPortNum = CoreUtil.parsePort(debugPort);
                }
                app.setDebugPort(debugPortNum);
                String internalDebugPort = null;
                if (portsObj != null && portsObj.has("internalDebugPort")) {
                    internalDebugPort = portsObj.getString("internalDebugPort");
                }
                app.setContainerDebugPort(internalDebugPort);
            }
            catch (Exception e) {
                Logger.logError("Failed to get the ports for application: " + app.name, e);
            }
            String contextRoot = null;
            if (appJso.has("contextRoot")) {
                contextRoot = appJso.getString("contextRoot");
            } else if (appJso.has("contextroot")) {
                contextRoot = appJso.getString("contextroot");
            }
            app.setContextRoot(contextRoot);
            app.setStartMode(StartMode.get(appJso));
            if (appJso.has("autoBuild")) {
                app.setAutoBuild(appJso.getBoolean("autoBuild"));
            }
            if (appJso.has("capabilitiesReady")) {
                app.setCapabilitiesReady(appJso.getBoolean("capabilitiesReady"));
            }
            if (appJso.has("injection")) {
                JSONObject injectObj = appJso.getJSONObject("injection");
                app.setMetricsInjectionInfo(injectObj.getBoolean("injectable"), injectObj.getBoolean("injected"));
            }
            if (appJso.has("metricsDashboard")) {
                JSONObject metricsObj = appJso.getJSONObject("metricsDashboard");
                app.setMetricsDashboardInfo(CodewindApplicationFactory.getStringValue(metricsObj, "hosting"), CodewindApplicationFactory.getStringValue(metricsObj, "path"));
            }
            if (appJso.has("perfDashboardPath")) {
                app.setPerfDashboardInfo(CodewindApplicationFactory.getStringValue(appJso, "perfDashboardPath"));
            }
        }
        catch (JSONException e) {
            Logger.logError("Error parsing project json: " + appJso, e);
        }
        try {
            if (appJso.has("logs") && appJso.getJSONObject("logs").length() > 0) {
                List<ProjectLogInfo> logInfos = app.connection.requestProjectLogs(app);
                app.setLogInfos(logInfos);
            }
        }
        catch (Exception e) {
            Logger.logError("An error occurred while updating the log information for project: " + app.name, e);
        }
    }

    private static String getStringValue(JSONObject obj, String key) throws JSONException {
        if (!obj.has(key) || obj.isNull(key)) {
            return null;
        }
        String value = obj.getString(key);
        if (value == null || value.isEmpty()) {
            return null;
        }
        return value;
    }
}

